(************************************************************
 * This program can be used to find any files using the     *
 * set PATH, so you can open and use your TURBO *.COM       *
 * programs together with their data files from any         *
 * subdirectory, if they are located in a PATH-directory.   *
 *          (TURBO cannot find it's MSGs, tsk tsk)          *
 * Uploaded by Wolfgang Siebeck, Aachen W.Germany 72446,415 *
 *   INCLUDES FIX DATED JUNE 25, 1985                       *
 ************************************************************)

type
line     = string[255];

var
input    : line;

(****************************************************************************)

function exist (filename : line) : boolean;

var
found    : boolean;
testfile : file;

begin

    found := FALSE;
    assign (testfile,filename);
    {$I-} reset (testfile); {$I+}
    found := (IOResult = 0);
    if found then close (testfile);

    exist := found;

end; (* exist *)

(****************************************************************************)

function path_finder : line;

const
pfad_prefix = 'PATH=';

var nullz,ende : boolean;
c              : char;
pfad_zaehler   : byte;
pfad           : line;
zahl1, zahl2   : integer;

begin

  nullz := FALSE;
  ende  := FALSE;
  zahl1 := memw[cseg:$2c];
  zahl2 := 0;
  pfad := '';

  repeat
      c := chr(mem[zahl1:zahl2]);
      if c <> #0 then
      begin
          pfad := pfad + c;
          nullz := FALSE;
      end
      else
          if (not nullz) then
          begin
              if pos(pfad_prefix,pfad) = 0 then pfad := ''
                                           else ende := TRUE;
              nullz := TRUE;
          end
          else ende := TRUE;
      zahl2 := succ (zahl2);
  until ende;
  delete (pfad,1,5);

  path_finder := pfad;

end; (* path_finder *)

(****************************************************************************)

function suche_file (var s1: line) : boolean;

var

b1       : byte;
s2,s3    : line;
ok       : boolean;

begin

  ok   := FALSE;
  b1   := 0;
  s2   := '';

  if exist (s1) then
      ok := TRUE
  else
  begin
    s3   := path_finder;
    b1   := pos (';',s3);
    repeat
        s2 := '';
        if (b1>0) then
        begin
            s2 := copy (s3,1,b1-1);
            delete (s3,1,b1);
        end
        else
        begin
            s2 := s3;
            s3 := '';
        end;
        if (copy (s2,length(s2),1) <> '\') then s2 := s2 + '\';
        b1 := 0;
        b1 := pos (';',s3);
        ok := exist (s2+s1);
    until ok or (s3='');

    if ok then s1 := s2 + s1;
  end;

    suche_file := ok;

end; (* suche_file *)

(********************** A little demonstration ... **************************)

begin

    ClrScr;
    WriteLn ('Search for any file on PATH');
    WriteLn ('Hit <RETURN> to end');
    WriteLn;

    input := '';

    repeat

        write ('File to search for: ');
        readln (input);

        if (input <> '') then
            if suche_file (input)
            then
                writeln ('Your file was found as "',input,'"')
            else
                writeln ('The file "',input,'" cannot be found on PATH.');
        WriteLn;

    until (input = '');

end.

