	TITLE 	SIMIL.ASM   written by John W. Ratcliff and David E. Metzener
	
; November 10, 1987
; Uses the Ratcliff/Obershelp pattern recognition algorithm
; This program provides a new function to C on an 8086 based machine.
; The function SIMIL returns a percentage value corresponding to how
; alike any two strings are.  Be certain to upper case the two strings
; passed if you are not concerned about case sensitivity.
; NOTE: This routine is for SMALL model only.  As an exercise for
; the student, feel free to convert it to LARGE.


_TEXT	SEGMENT BYTE PUBLIC 'CODE'
_TEXT	ENDS
CONST	SEGMENT WORD PUBLIC 'CONST'
CONST	ENDS
_BSS	SEGMENT	WORD PUBLIC 'BSS'
_BSS	ENDS
_DATA	SEGMENT	WORD PUBLIC 'DATA'
_DATA	ENDS
DGROUP	GROUP CONST,_BSS,_DATA
	ASSUME	CS:_TEXT, DS:DGROUP, SS:DGROUP, ES:DGROUP
	
_DATA	SEGMENT

ststr1L	dw	25 dup (?)
ststr1R	dw	25 dup (?)
ststr2L	dw	25 dup (?)
ststr2R	dw	25 dup (?)
stcknum	dw	?
score	dw	?
total	dw	?
cl1	dw	?
cr1	dw	?
cl2	dw	?
cr2	dw	?
s2ed	dw	?

_DATA ENDS

	public _simil
	
_TEXT	SEGMENT

_simil	proc	near
	push	bp
	mov	bp,sp
	push	es
	mov	ax,ds
	mov	es,ax
	xor	ax,ax
	mov	score,ax
	mov	stcknum,ax
	mov	si,[bp+4]
	mov	di,[bp+6]
	cmp	[si],al
	je	strerr
	cmp	[di],al
	jne	docmp
strerr:	jmp	donit
docmp:	push	di
	push	si
	xor	al,al
	cld
	mov	cx,-1
	repnz	scasb
	dec	di
	mov	bp,di
	pop	di
	repnz	scasb
	not	cx
	sub	cx,2
	mov	total,cx
	dec	di
	dec	di
	mov	bx,di
	pop	di
	call	pushst
main:	cmp	stcknum,0
	je	done
	call	popst
	call	compare
	cmp	dx,0
	je	main
	shl	dx,1
	add	score,dx
	mov	bp,stcknum
	shl	bp,1
	mov	si,[ststr1l+bp]
	mov	bx,cl1
	mov	di,[ststr2l+bp]
	mov	cx,cl2
	mov	ax,[ststr1r+bp]
	mov	cl1,ax
	mov	ax,[ststr2r+bp]
	mov	cl2,ax
	mov	bp,cx
	cmp	bx,si
	je	chrght
	cmp	bp,di
	je	chrght
	dec	bx
	dec	bp
	cmp	bx,si
	jne	pushit
	cmp	bp,di
	je	chrght
pushit:	call	pushst
chrght:	mov	si,cr1
	mov	bx,cl1
	mov	di,cr2
	mov	bp,cl2
	cmp	si,bx
	je	main
	cmp	di,bp
	je	main
	inc	si
	inc	di
	cmp	bx,si
	jne	push2
	cmp	bp,di
	je	main
push2:	call	pushst
	jmp	short main
done:	mov	ax,score
	mov	cx,100
	mul	cx
	mov	cx,total
	div	cx
donit:	pop	es
	pop	bp
	ret
_simil	endp

compare	proc	near
	mov	s2ed,bp
	xor	dx,dx
forl3:	push	di
forl4:	push	di
	push	si
	mov	cx,s2ed
	sub	cx,di
	inc	cx
	push	cx
	repz	cmpsb
	jz	equal
	inc	cx
equal:	pop	ax
	sub	ax,cx
	jnz	newmax
	pop	si
	pop	di
reent:	inc	di
reent2:	cmp	di,bp
	jle	forl4
	pop	di
	inc	si
	cmp	si,bx
	jle	forl3
	ret
	
newmax:	cmp	ax,dx
	jg	newmx2
	pop	si
	pop	di
	add	di,ax
	jmp	short reent2
newmx2:	pop	si
	pop	di
	mov	cl1,si
	mov	cl2,di
	mov	cx,ax
	sub	ax,dx
	sub	bx,ax
	sub	bp,ax
	mov	dx,cx
	dec	cx
	add	di,cx
	mov	cr2,di
	add	cx,si
	mov	cr1,cx
	jmp	short reent
compare	endp

pushst	proc	near
	mov	cx,bp
	mov	bp,stcknum
	shl	bp,1
	mov	[bp+ststr1l],si
	mov	[bp+ststr1r],bx
	mov	[bp+ststr2l],di
	mov	[bp+ststr2r],cx
	inc	stcknum
	mov	bp,cx
	ret
pushst	endp

popst	proc	near
	dec	stcknum
	mov	bp,stcknum
	shl	bp,1
	mov	si,[bp+ststr1l]
	mov	bx,[bp+ststr1r]
	mov	di,[bp+ststr2l]
	mov	bp,[bp+ststr2r]
	ret
popst	endp

_TEXT	ENDS
	END
	