PROGRAM GifSize;

USES
   Dos;

CONST
   HeadStr1 : STRING = 'Filnamn .Ext   Format(B*H*F) ';
   HeadStr2 = 'Filstorlek   ';
   HeadStr3 = 'Nedladdningstid';

   SearchMask : STRING = '*.GIF';
   CPSRate    : Word   = 220;

   SizeFlag : Boolean = False;
   TimeFlag : Boolean = False;
   HeadFlag : Boolean = False;

TYPE
   Str79 = STRING[79];

PROCEDURE Init;
VAR
   i : Integer;
   s : Str79;

FUNCTION IsSwitch(s : Str79) : Boolean;
BEGIN
   IsSwitch := s[1] IN ['/', '-'];
END;

PROCEDURE SetSwitch(s : Str79);
VAR
   i, code : Integer;
   mask    : STRING;
BEGIN
   CASE UpCase(s[2]) OF
      'S'      : SizeFlag := True;
      'T'      :
      BEGIN
         TimeFlag := True;
         Val(Copy(s, 4, Length(s)), i, code);
         IF code = 0 THEN IF i > 0 THEN CPSRate := i;
      END;
      'M'      :
      BEGIN
         mask := Copy(s, 4, Length(s));
         IF mask <> '' THEN SearchMask := mask;
      END;
      'R'      : HeadFlag := True;
      'H', '?' :
      BEGIN
         Writeln; Writeln;
         Writeln('   ****  GIF-Analysator -- Version 0.1 -- Peter Lewerin  ****');
         Writeln;
         Writeln('   FUNKTION: Letar i aktuell katalog efter *.GIF. Hittade filer');
         Writeln('             analyseras och resultatet skrivs till skrmen.');
         Writeln;
         Writeln('   SWITCHAR: ');
         Writeln;
         Writeln('      /s                   : visar filstorlek i bytes');
         Writeln('      /t                   : visar nedladdningstid med en given');
         Writeln('                             hastighet av 220 tecken per sekund');
         Writeln('      /t:<positivt heltal> : som ovan men stller hastigheten');
         Writeln('      /m:<skmask>         : ndrar skmasken (normalt *.GIF)');
         Writeln('      /r                   : visar rubrikrad');
         Writeln('      /? el /h             : visar denna hjlptext');
         Writeln; Writeln;

         Writeln('--- Tryck p < fr att komma tillbaka till DOS ---');
         Readln;
         Halt;
      END;
   END;
END;

BEGIN (** Init **)
   FOR i := 1 TO ParamCount DO BEGIN
      s := ParamStr(i);
      IF IsSwitch(s) THEN SetSwitch(s);
   END;

   IF SizeFlag THEN HeadStr1 := HeadStr1 + HeadStr2;
   IF TimeFlag THEN HeadStr1 := HeadStr1 + HeadStr3;
   IF HeadFlag THEN Writeln(HeadStr1);
END;

PROCEDURE Analyze;
VAR
   dirInfo : SearchRec;
   s       : STRING;

FUNCTION GetFmtStr(dirInfo : SearchRec) : STRING;
VAR
   f  : FILE;
   r  : Word;
   ba : ARRAY [0..10] OF Byte;
   width, height, colors : STRING;

BEGIN
   Assign(f, dirInfo.Name);
   Reset(f, 11);
   BlockRead(f, ba, 1, r);
   Close(f);

   IF r <> 1 THEN GetFmtStr := '(---*---*---)'
   ELSE BEGIN
      Str(ba[6] + $100 * ba[7], width);
      Str(ba[8] + $100 * ba[9], height);
      CASE (ba[10] AND $07) OF
         $0 : colors :=   '2';
         $1 : colors :=   '4';
         $2 : colors :=   '8';
         $3 : colors :=  '16';
         $4 : colors :=  '32';
         $5 : colors :=  '64';
         $6 : colors := '128';
         $7 : colors := '256';
      ELSE colors := '???';    { ja, jag vet att det inte intrffar, men... }
      END;
      GetFmtStr := '(' + width + '*' + height + '*' + colors + ')';
   END;
END;

PROCEDURE WriteToScreen(dirInfo : SearchRec);
VAR
   D       : DirStr;
   N       : NameStr;
   E       : ExtStr;
BEGIN
   FSplit(dirInfo.Name, D, N, E);
   WHILE Length(N) < 8 DO N := N + ' ';
   Write(N, E, ^I, GetFmtStr(dirInfo));
   IF SizeFlag THEN Write(^I, dirInfo.Size:7);
   IF TimeFlag THEN Write(^I, dirInfo.Size / (CPSRate * 60):5:1,'m');
   Writeln;
END;

BEGIN (** Analyze **)
   GetDir(0, s);
   IF NOT (s[Length(s)] = '\') THEN s := s + '\';
   s := s + SearchMask;
   FindFirst(s, AnyFile, dirInfo);
   WHILE DosError = 0 DO
   BEGIN
      WriteToScreen(dirInfo);
      FindNext(dirInfo);
   END;
END;

BEGIN (*** GifSize ***)
   Init;
   Analyze;
END.