program TestPick;
{------------------------------------------------------------------------------
                              DBase File Lister

       TESTPICK.PAS Copyright (c)  Richard F. Griffin

       20 July 1993

       102 Molded Stone Pl
       Warner Robins, GA  31088

       -------------------------------------------------------------
       This program demonstrates how dBase records may be selected using
       pick menus in Griffin Solutions units.

       See SHOWOFF.PAS for additional examples.

       ---  WILL NOT RUN UNDER WINDOWS ---

-------------------------------------------------------------------------------}

uses
   GSOBShel,
   GSOB_DBS,
   GSOB_Inx,
   GSOB_Str,
   GSOB_Var,
   SmplStuf,
   CRT,
   DOS;

var
   SelectLine: GSO_dbTable;
   LinItem   : longint;
   slct      : word;

Procedure InitializeScreen;
begin
   Window(1,1,80,25);
   SetScreenColors(Yellow,White,Blue,Black,LightGray);
   SetNmMode;
   ClrScr;
end;

Procedure DisplayDataLine(x,y : integer; s1,s2 : string);
begin
   GoToXY(x,y);
   SetHiMode;
   write(s1);
   SetNmMode;
   write(s2);
end;

Procedure DisplayCurRecord;
begin
   InitializeScreen;
   DisplayDataLine(5,2,'Customer ID: ',FieldGet('UNIQUEID'));
   DisplayDataLine(5,3,'Last Name of Selectee: ',FieldGet('LASTNAME'));
   DisplayDataLine(5,4,'First Name: ',FieldGet('FIRSTNAME'));
   DisplayDataLine(5,6,'Street Address: ',FieldGet('STREET'));
   DisplayDataLine(5,7,'City: ',FieldGet('City'));
   DisplayDataLine(42,7,'State: ',FieldGet('State'));
   DisplayDataLine(54,7,'Zip: ',FieldGet('Zip'));
   DisplayDataLine(5,8,'Telephone Number: ',FieldGet('TELEPHONE'));
   DisplayDataLine(5,9,'Date of Birth: ',StringGet('BIRTHDATE'));
   DisplayDataLine(5,10,'Payment Amount: ',FieldGet('PAYMENT'));
end;

Function SelectRecord: longint;
var
   mItem: GSP_IndxEtry;
begin
   window(10,5,70,22);
   SetScreenColors(Black,Yellow,Green,White,Green);
   SetNmMode;
   ClrScr;
   MakeABox('Select Name');
   mItem := GS_Pick_Row(@SelectLine,slct);
   if mItem <> nil then
      SelectRecord := mItem^.Tag
   else
      SelectRecord := 0;
end;

begin
   InitializeScreen;
   slct := 1;                     {Initial menu item to highlight}
   Select(1);                     {Use record area 1 (the default)}
   Use('GSDMO_01');               {Assign the dBase III file GSDMO_01}

   {  Initialize the SelectLine object and build a table of the
      LASTNAME+FIRSTNAME record fields                          }

   SelectLine.Init(DBFActive^,'LASTNAME + FIRSTNAME',SortUp);
   SelectLine.Build_dBTabl;

   repeat
      LinItem := SelectRecord;    {Select a name field to be displayed}
      if LinItem > 0 then
      begin
         Go(LinItem);
         DisplayCurRecord;
         WaitForKey;
      end;
   until LinItem = 0;
   InitializeScreen;
   CloseDataBases;                {Close the file}
end.
