{$X+}
(*                                                  
   This program has context help associated with the 
   WINDOW selection in the main menu. There is also 
   context help for the radio buttons in the dialog.
                                                    *)

program Hints;

uses Objects, Drivers, Views, Menus, Dialogs, App,Gadgets;

const
  cmNewDialog       = 102;
  hcMyDialog        = 3000;
  hcSolid         = 1;
  hcRunny         = hcSolid + 1;
  hcMelted        = hcRunny  + 1;
  hcNext          = 10;
  hcZoom          = 11;
  hcDialog        = 12;



type
  PMyStatusLine = ^TMyStatusLine;
  TMyStatusLine = object(TStatusLine)
    function Hint(AHelpCtx : Word):String;virtual;
    procedure HandleEvent(var Event : TEvent);virtual;
  end;

  TMyApp = object(TApplication)
    HeapViewer : PHeapView;
    constructor Init;
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure InitMenuBar; virtual;
    procedure InitStatusLine; virtual;
    procedure NewDialog;
    procedure Idle;virtual;
  end;

  PDemoDialog = ^TDemoDialog;
  TDemoDialog = object(TDialog)
   MyStatusLine : PMyStatusLine;
  end;

function TMyStatusLine.Hint(AHelpCtx : Word):String;
begin
 case AHelpCtx of
   hcNext : Hint :='NEXT selection now pressed';
   hcZoom : Hint :='ZOOM selection now pressed';
   hcDialog: Hint :='DIALOG selection now pressed';
   hcSolid : Hint := 'Button zero is pressed';
   hcRunny : Hint := 'Button one is pressed';
   hcMelted : Hint := 'Button two is pressed';
 else
  Hint := '';
 end;
end;

procedure TMyStatusLine.HandleEvent(var Event : TEvent);
begin
 TStatusLine.HandleEvent(Event);
 Update;
end;

procedure TMyApp.Idle;
begin
 TApplication.Idle;
 HeapViewer^.Update;
end;

constructor TMyApp.Init;
var
 R : TRect;
begin
  TApplication.Init;
  GetExtent(R);
  Dec(R.B.X);
  R.A.X := R.B.X - 9; R.A.Y := R.B.Y - 1;
  HeapViewer := New(PHeapView,Init(R));
  Insert(HeapViewer);
end;
{ TMyApp }
procedure TMyApp.HandleEvent(var Event: TEvent);
begin
  TApplication.HandleEvent(Event);
  if Event.What = evCommand then
  begin
    case Event.Command of
      cmNewDialog: NewDialog;
    else
      Exit;
    end;
    ClearEvent(Event);
  end;
end;

procedure TMyApp.InitMenuBar;
var R: TRect;
begin
  GetExtent(R);
  R.B.Y := R.A.Y + 1;
  MenuBar := New(PMenuBar, Init(R, NewMenu(
    NewSubMenu('~F~ile', hcNoContext, NewMenu(
      NewLine(
      NewItem('E~x~it', 'Alt-X', kbAltX, cmQuit, hcNoContext,
      nil))),
    NewSubMenu('~W~indow', hcNoContext, NewMenu(
      NewItem('~N~ext', 'F6', kbF6, cmNext, hcNext,
      NewItem('~Z~oom', 'F5', kbF5, cmZoom, hcZoom,
      NewItem('~D~ialog', 'F2', kbF2, cmNewDialog, hcDialog,
      nil)))),
    nil))
  )));

end;

procedure TMyApp.InitStatusLine;
var R: TRect;
begin
  GetExtent(R);
  R.A.Y := R.B.Y - 1;
  StatusLine := New(PMyStatusLine, Init(R,
    NewStatusDef(0,0,
      NewStatusKey('', kbF10, cmMenu,
      NewStatusKey('~Alt-X~ Exit', kbAltX, cmQuit,
      NewStatusKey('~Alt-F3~ Close', kbAltF3, cmClose,
      nil))),
    NewStatusDef(10,10,                          (* used to define hot keys *)
      NewStatusKey('~F6~ Next' ,kbAltF6, cmNext, (* for context help        *)
      nil),
     NewStatusDef(11,11,
      NewStatusKey('~F5~ Zoom' ,kbAltF5, cmZoom,
      nil),nil)))));
end;

procedure TMyApp.NewDialog;
var
  Bruce: PView;
  Dialog: PDemoDialog;
  R: TRect;
  C: Word;
begin
  R.Assign(20, 6, 60, 19);
  Dialog := New(PDemoDialog, Init(R, 'Demo Dialog'));
  with Dialog^ do
  begin
    R.Assign(3, 3, 18, 6);
    Bruce := New(PCheckBoxes, Init(R,
      NewSItem('~H~varti',
      NewSItem('~T~ilset',
      NewSItem('~J~arlsberg',
      nil)))
    ));
    Insert(Bruce);
    R.Assign(2, 2, 10, 3);
    Insert(New(PLabel, Init(R, 'Cheeses', Bruce)));
    R.Assign(22, 3, 34, 6);
    Bruce := New(PRadioButtons, Init(R,
      NewSItem('~S~olid',
      NewSItem('~R~unny',
      NewSItem('~M~elted',
      nil)))
    ));
    Bruce^.HelpCtx := hcSolid;
    Insert(Bruce);
    R.Assign(21, 2, 33, 3);
    Insert(New(PLabel, Init(R, 'Consistency', Bruce)));
    R.Assign(3, 8, 37, 9);
    Bruce := New(PInputLine, Init(R, 34));
    Insert(Bruce);
    R.Assign(2, 7, 24, 8);
    Insert(New(PLabel, Init(R, 'Delivery instructions', Bruce)));
    R.Assign(15, 10, 25, 12);
    Insert(New(PButton, Init(R, '~O~k', cmOK, bfDefault)));
    R.Assign(28, 10, 38, 12);
    Insert(New(PButton, Init(R, 'Cancel', cmCancel, bfNormal)));
  end;

  DeskTop^.ExecView(Dialog);
  Dispose(Dialog, Done);
end;


var
  MyApp: TMyApp;

begin
  MyApp.Init;
  MyApp.Run;
  MyApp.Done;
end.
