unit KeyBoard;
{$O+,F+}
{Ŀ}
{                                                                          }
{   File    : KEYBOARD.PAS                                                 }
{   Author  : Harald Thunem                                                }
{   Purpose : Keyboard routines                                            }
{   Updated : February 16 1992                                             }
{                                                                          }
{}

{}
interface
{}

uses Screen,Dos;

type KeyType = (NullKey,F1,F2,F3,F4,F5,F6,F7,F8,F9,F10,F11,F12,

                ShiftF1,ShiftF2,ShiftF3,ShiftF4,ShiftF5,ShiftF6,
                ShiftF7,ShiftF8,ShiftF9,ShiftF10,ShiftF11,ShiftF12,

                Alt0,Alt1,Alt2,Alt3,Alt4,
                Alt5,Alt6,Alt7,Alt8,Alt9,

                AltF1,AltF2,AltF3,AltF4,AltF5,AltF6,
                AltF7,AltF8,AltF9,AltF10,AltF11,AltF12,

                CtrlF1,CtrlF2,CtrlF3,CtrlF4,CtrlF5,CtrlF6,
                CtrlF7,CtrlF8,CtrlF9,CtrlF10,CtrlF11,CtrlF12,

                AltA,AltB,AltC,AltD,AltE,AltF,AltG,AltH,AltI,
                AltJ,AltK,AltL,AltM,AltN,AltO,AltP,AltQ,AltR,
                AltS,AltT,AltU,AltV,AltW,AltX,AltY,AltZ,

                CtrlA,CtrlB,CtrlC,CtrlD,CtrlE,CtrlF,CtrlG,CtrlH,CtrlI,
                CtrlJ,CtrlK,CtrlL,CtrlM,CtrlN,CtrlO,CtrlP,CtrlQ,CtrlR,
                CtrlS,CtrlT,CtrlU,CtrlV,CtrlW,CtrlX,CtrlY,CtrlZ,

                Return,TabKey,BackSpace,UpArrow,
                DownArrow,RightArrow,LeftArrow,DelKey,
                InsKey,HomeKey,EndKey,TextKey,NumberKey,
                Space,PgUp,PgDn,Escape,

                AltReturn,AltTabKey,AltBackSpace,AltUpArrow,
                AltDownArrow,AltRightArrow,AltLeftArrow,
                AltHomeKey,AltEndKey,AltSpace,AltPgUp,AltPgDn,AltEscape,

                CtrlReturn,CtrlTabKey,CtrlBackSpace,CtrlUpArrow,
                CtrlDownArrow,CtrlRightArrow,CtrlLeftArrow,CtrlDelKey,
                CtrlHomeKey,CtrlEndKey,CtrlPgUp,CtrlPgDn,CtrlInsKey);

     KeySetType = SET OF KeyType;

var  Key      : KeyType;
     Ch       : char;
     InsertOn : boolean;

procedure ReadAscii(var CharCode,ScanCode: byte);
procedure InKey(var Ch:char; var Key:KeyType);
procedure InputString(var S:string; R,C,L:byte; Attr:integer; KeySet:KeySetType);

{}
implementation
{}

var  Regs     : registers;

procedure ReadAscii(var CharCode,ScanCode: byte);
begin
  CharCode := $00;
  ScanCode := $00;
  FillChar(Regs,SizeOf(Regs),0);
  Regs.AH := $10;
  Intr($16,Regs);
  CharCode := Regs.al;
  ScanCode := Regs.ah;
end;


procedure InKey(var Ch:char; var Key:KeyType);
var CC,SC: byte;
    Ascii: word;
begin
  Key := NullKey;
  ReadAscii(CC,SC);
  Ascii := 256*CC+SC;
  Ch    := Chr(CC);
  case Ascii of
    $1B01: Key:=Escape;        $0D1C: Key:=Return;
    $0DE0: Key:=Return;
    $E048: Key:=UpArrow;       $E050: Key:=DownArrow;
    $0048: Key:=UpArrow;       $0050: Key:=DownArrow;
    $E04B: Key:=LeftArrow;     $E04D: Key:=RightArrow;
    $004B: Key:=LeftArrow;     $004D: Key:=RightArrow;
    $E049: Key:=PgUp;          $E051: Key:=PgDn;
    $0049: Key:=PgUp;          $0051: Key:=PgDn;
    $E047: Key:=HomeKey;       $E04F: Key:=EndKey;
    $0047: Key:=HomeKey;       $004F: Key:=EndKey;
    $090F: Key:=TabKey;        $E052: Key:=InsKey;
    $0052: Key:=InsKey;        $080E: Key:=BackSpace;
    $E053: Key:=DelKey;        $0053: Key:=DelKey;
    $2039: Key:=Space;

    $0001: Key:=AltEscape;
    $001C: Key:=AltReturn;        $00A6: Key:=AltReturn;
    $0098: Key:=AltUpArrow;       $00A0: Key:=AltDownArrow;
    $0800: Key:=AltUpArrow;       $0200: Key:=AltDownArrow;
    $009B: Key:=AltLeftArrow;     $009D: Key:=AltRightArrow;
    $0400: Key:=AltLeftArrow;     $0600: Key:=AltRightArrow;
    $0099: Key:=AltPgUp;          $00A1: Key:=AltPgDn;
    $0300: Key:=AltPgUp;          $0900: Key:=AltPgDn;
    $0097: Key:=AltHomeKey;       $009F: Key:=AltEndKey;
    $0700: Key:=AltHomeKey;       $0100: Key:=AltEndKey;
    $00A5: Key:=AltTabKey;        $0002: Key:=AltSpace;

    $0A1C: Key:=CtrlReturn;        $0AE0: Key:=CtrlReturn;
    $E08D: Key:=CtrlUpArrow;       $E091: Key:=CtrlDownArrow;
    $008D: Key:=CtrlUpArrow;       $0091: Key:=CtrlDownArrow;
    $E073: Key:=CtrlLeftArrow;     $E074: Key:=CtrlRightArrow;
    $0073: Key:=CtrlLeftArrow;     $0074: Key:=CtrlRightArrow;
    $E084: Key:=CtrlPgUp;          $E076: Key:=CtrlPgDn;
    $0084: Key:=CtrlPgUp;          $0076: Key:=CtrlPgDn;
    $E077: Key:=CtrlHomeKey;       $E075: Key:=CtrlEndKey;
    $0077: Key:=CtrlHomeKey;       $0075: Key:=CtrlEndKey;
    $0094: Key:=CtrlTabKey;        $E092: Key:=CtrlInsKey;
    $E093: Key:=CtrlDelKey;

    $003B: Key:=F1;         $003C: Key:=F2;         $003D: Key:=F3;
    $003E: Key:=F4;         $003F: Key:=F5;         $0040: Key:=F6;
    $0041: Key:=F7;         $0042: Key:=F8;         $0043: Key:=F9;
    $0044: Key:=F10;        $0045: Key:=F11;        $0046: Key:=F12;

    $0054: Key:=ShiftF1;    $0055: Key:=ShiftF2;    $0056: Key:=ShiftF3;
    $0057: Key:=ShiftF4;    $0058: Key:=ShiftF5;    $0059: Key:=ShiftF6;
    $005A: Key:=ShiftF7;    $005B: Key:=ShiftF8;    $005C: Key:=ShiftF9;
    $005D: Key:=ShiftF10;   $005E: Key:=ShiftF11;   $005F: Key:=ShiftF12;

    $0068: Key:=AltF1;      $0069: Key:=AltF2;      $006A: Key:=AltF3;
    $006B: Key:=AltF4;      $006C: Key:=AltF5;      $006D: Key:=AltF6;
    $006E: Key:=AltF7;      $006F: Key:=AltF8;      $0070: Key:=AltF9;
    $0071: Key:=AltF10;     $0072: Key:=AltF11;     $0073: Key:=AltF12;

    $005E: Key:=CtrlF1;     $005F: Key:=CtrlF2;     $0060: Key:=CtrlF3;
    $0061: Key:=CtrlF4;     $0062: Key:=CtrlF5;     $0063: Key:=CtrlF6;
    $0064: Key:=CtrlF7;     $0065: Key:=CtrlF8;     $0066: Key:=CtrlF9;
    $0067: Key:=CtrlF10;    $0068: Key:=CtrlF11;    $0069: Key:=CtrlF12;

    $0081: Key:=Alt0;     $0078: Key:=Alt1;     $0079: Key:=Alt2;
    $007A: Key:=Alt3;     $007B: Key:=Alt4;     $007C: Key:=Alt5;
    $007D: Key:=Alt6;     $007E: Key:=Alt7;     $007F: Key:=Alt8;
    $0080: Key:=Alt9;

    $001E: Key:=AltA;     $0030: Key:=AltB;     $002E: Key:=AltC;
    $0020: Key:=AltD;     $0012: Key:=AltE;     $0021: Key:=AltF;
    $0022: Key:=AltG;     $0023: Key:=AltH;     $0017: Key:=AltI;
    $0024: Key:=AltJ;     $0025: Key:=AltK;     $0026: Key:=AltL;
    $0032: Key:=AltM;     $0031: Key:=AltN;     $0018: Key:=AltO;
    $0019: Key:=AltP;     $0010: Key:=AltQ;     $0013: Key:=AltR;
    $001F: Key:=AltS;     $0014: Key:=AltT;     $0016: Key:=AltU;
    $002F: Key:=AltV;     $0011: Key:=AltW;     $002D: Key:=AltX;
    $0015: Key:=AltY;     $002C: Key:=AltZ;

    $011E: Key:=CtrlA;     $0130: Key:=CtrlB;     $012E: Key:=CtrlC;
    $0120: Key:=CtrlD;     $0112: Key:=CtrlE;     $0121: Key:=CtrlF;
    $0122: Key:=CtrlG;     $0123: Key:=CtrlH;     $0117: Key:=CtrlI;
    $0124: Key:=CtrlJ;     $0125: Key:=CtrlK;     $0126: Key:=CtrlL;
    $0132: Key:=CtrlM;     $0131: Key:=CtrlN;     $0118: Key:=CtrlO;
    $0119: Key:=CtrlP;     $0110: Key:=CtrlQ;     $0113: Key:=CtrlR;
    $011F: Key:=CtrlS;     $0114: Key:=CtrlT;     $0116: Key:=CtrlU;
    $012F: Key:=CtrlV;     $0111: Key:=CtrlW;     $012D: Key:=CtrlX;
    $0115: Key:=CtrlY;     $012C: Key:=CtrlZ;
  end;
  if (CC in [$21..$A5]) then Key:=TextKey;
  if (CC in [$30..$39]) then Key:=NumberKey;
end;


procedure InputString(var S:string; R,C,L:byte; Attr:integer; KeySet:KeySetType);
const Fill: char = #0;
var   P   : byte;
      I,J : word;
begin
  InsertOn := false;
  I:=Length(S)+1;
  if I>L then
    S:=Copy(S,1,L)
  else begin
    for J:=I to L do
      S[J]:=Fill;
    S[0]:=Chr(L);
  end;
  P:=1;
  repeat
    WriteStr(R,C,Attr,S);
    GoToRC(R,C+P-1);
    if InsertOn then
      SetCursor(CursorBlock)
    else SetCursor(CursorUnderline);
    InKey(Ch,Key);
    SetCursor(CursorOff);
    case Key of
      TextKey,
      NumberKey,
      Space    : begin
                   if InsertOn then
                   begin
                     Insert(Ch,S,P);
                     S[0]:=Chr(L);
                     if P<L then
                     Inc(P);
                   end
                   else begin
                     S[P]:=Ch;
                     if P<L then
                     Inc(P);
                   end;
                 end;
      InsKey   : begin
                   InsertOn:= not InsertOn;
                 end;
      DelKey   : begin
                   Delete(S,P,1);
                   S:=S+Fill;
                 end;
      LeftArrow: begin
                   if P>1 then
                   Dec(P);
                 end;
      RightArrow:begin
                   if (Pos(Fill,S)>0) then
                   begin
                     if (P<Pos(Fill,S)) then
                     Inc(P);
                   end
                   else if (P<L) then
                     Inc(P);
                 end;
    HomeKey     :P := 1;
    EndKey      :P := Pos(Fill,S);
    BackSpace   :begin
                   if P>1 then
                   begin
                     Dec(P);
                     Delete(S,P,1);
                     S:=S+Fill;
                   end;
                 end;
    end;
  until Key in KeySet;
  I:=Pos(Fill,S);
  if I>0 then
    S:=Copy(S,1,I-1);
end;

end.
