unit Strings;
{$O+,F+}
{Ŀ}
{                                                                          }
{   File    : STRINGS.PAS                                                  }
{   Author  : Harald Thunem                                                }
{   Purpose : String routines                                              }
{   Updated : February 16 1992                                             }
{                                                                          }
{}
interface

function StrL(L : longint) : string;
function StrLF(L : longint;   Field : byte) : string;
function StrR(R : real) : string;
function StrRF(R : real;  Field : byte) : string;
function StrRFD(R : real;  Field,Decimal : byte) : string;
function UpcaseStr(s: string): string;

implementation

function StrL(L : longint) : string;
var S : string;
begin
  Str(L,S);
  StrL := S;
end;


function StrLF(L : longint;   Field : byte) : string;
var S : string;
begin
  Str(L:Field,S);
  StrLF := S;
end;


function StrR(R : real) : string;
var S : string;
begin
  Str(R,S);
  StrR := S;
end;


function StrRF(R : real;  Field : byte) : string;
var S : string;
begin
  Str(R:Field,S);
  StrRF := S;
end;


function StrRFD(R : real;  Field,Decimal : byte) : string;
var S : string;
begin
  Str(R:Field:Decimal,S);
  StrRFD := S;
end;


function UpcaseStr(s: string): string;
var i: byte;
begin
  for i := 1 to Length(s) do
    s[i] := Upcase(s[i]);
  UpcaseStr := s;
end;

end.