program NDosInst;
{ INFO Ŀ}
{ File    : NDOSINST.PAS                                                   }
{ Author  : Harald Thunem                                                  }
{ Purpose : Check whether Norton DOS is installed.                         }
{ Updated : July 10 1992                                                   }
{}

{ Compiler directives }
{$A+   Word align data                                                       }
{$B-   Short-circuit Boolean expression evaluation                           }
{$E-   Disable linking with 8087-emulating run-time library                  }
{$G+   Enable 80286 code generation                                          }
{$R-   Disable generation of range-checking code                             }
{$S-   Disable generation of stack-overflow checking code                    }
{$V-   String variable checking                                              }
{$X-   Disable Turbo Pascal's extended syntax                                }
{$N+   80x87 code generation                                                 }
{$D-   Disable generation of debug information                               }
{}

uses Dos;

var  Regs  : registers;
     VMajor,
     VMinor: string[3];

begin
  FillChar(Regs,SizeOf(Regs),$00);
  Regs.AX := $E44D;
  Intr($2F,Regs);
  if Regs.AX = $44EE then
  begin
    Str(Regs.BL,VMajor);
    Str(Regs.BH,VMinor);
    WriteLn('NDOS ',VMajor,'.',VMinor,' installed !');
    Halt(0);     { Return error code 0 if NDOS is installed }
  end
  else begin
    WriteLn('NDOS not installed !');
    Halt(1);     { Return error code 1 if NDOS is not installed }
  end;
end.