program SetKey;
{ INFO Ŀ}
{ File    : SETKEY.PAS                                                     }
{ Author  : Harald Thunem                                                  }
{ Purpose : Set keyboard typematic rate and delay.                         }
{ Updated : July 10 1992                                                   }
{}

{ Compiler directives }
{$A+   Word align data                                                       }
{$B-   Short-circuit Boolean expression evaluation                           }
{$E-   Disable linking with 8087-emulating run-time library                  }
{$G+   Enable 80286 code generation                                          }
{$R-   Disable generation of range-checking code                             }
{$S-   Disable generation of stack-overflow checking code                    }
{$V-   String variable checking                                              }
{$X-   Disable Turbo Pascal's extended syntax                                }
{$N+   80x87 code generation                                                 }
{$D-   Disable generation of debug information                               }
{}

uses Dos;

var Sub1,
    Sub2,
    s1,s2: string;
    Delay,
    Rate : byte;


function UpcaseStr(s: string): string;
var i: byte;
begin
  for i := 1 to Length(s) do
    s[i] := Upcase(s[i]);
  UpcaseStr := s;
end;

function StrToInt(s: string): byte;
var v,code: integer;
begin
  Val(s,v,code);
  if code=0 then
    StrToInt := v
  else StrToInt := $00;
end;


procedure SetRate(Delay,Rate: byte);
var  Regs: registers;
begin
  FillChar(Regs,SizeOf(Regs),$00);
  Regs.AH := $03;
  Regs.AL := $05;
  Regs.BH := Delay;
  Regs.BL := Rate;
  Intr($16,Regs);
end;


procedure Info;
begin
  WriteLn('Program : SETKEY 1.0');
  WriteLn('Author  : Harald Thunem');
  WriteLn('Purpose : Set the keyboard typematic rate and delay');
  WriteLn('Updated : July 10 1992');
  WriteLn('Usage   : SETKEY [D=x R=y] [/fastkey]');
  WriteLn;
  WriteLn('  SetKey sets the typematic rate and delay for the keyboard. The delay D');
  WriteLn('  is given as an integer x in the range [0-3], corresponding to a delay of');
  WriteLn('  250-1000 microseconds. The typematic rate R is given as an integer y');
  WriteLn('  in the range [0-31], corresponding to a rate of 30.0 - 2.0 characters');
  WriteLn('  per second. A shortcut to get the shortest delay and fastest typematic');
  WriteLn('  rate, is to give the parameter /fastkey.');
  WriteLn;
  WriteLn('  Ex.  SETKEY D=0 R=0 {which equals SETKEY /fastkey}');
  WriteLn;
  Halt(1);
end;


begin
  Delay := $00;
  Rate  := $00;
  WriteLn('SetKey 1.0                                                   Written by H.Thunem');
  if ParamCount=0 then
    Info;
  s1 := UpcaseStr(ParamStr(1));
  if ParamCount>1 then
    s2 := UpcaseStr(ParamStr(2));
  if s1='/FASTKEY' then
  begin
    Delay := $00;
    Rate  := $00;
  end
  else
  begin
    if Pos('/',s1)>0 then
      Delete(s1,Pos('/',s1),1);
    if Pos('/',s2)>0 then
      Delete(s2,Pos('/',s2),1);
    Sub1 := Copy(s1,3,Length(s1)-2);
    Sub2 := Copy(s2,3,Length(s2)-2);
    if s1[1]='D' then Delay:=StrToInt(Sub1);
    if s1[1]='R' then Rate:=StrToInt(Sub1);
    if s2[1]='D' then Delay:=StrToInt(Sub2);
    if s2[1]='R' then Rate:=StrToInt(Sub2);
    if Delay>3 then Delay:=3;
    if Rate>31 then Rate:=31;
  end;
  SetRate(Delay,Rate);
end.