program Timer;
{ INFO Ŀ}
{ File    : TIM.PAS                                                        }
{ Author  : Harald Thunem                                                  }
{ Purpose : Find time used in programs/commands.                           }
{ Updated : July 10 1992                                                   }
{}

{ Compiler directives }
{$A+   Word align data                                                       }
{$B-   Short-circuit Boolean expression evaluation                           }
{$E-   Disable linking with 8087-emulating run-time library                  }
{$G+   Enable 80286 code generation                                          }
{$R-   Disable generation of range-checking code                             }
{$S-   Disable generation of stack-overflow checking code                    }
{$V-   String variable checking                                              }
{$X-   Disable Turbo Pascal's extended syntax                                }
{$N+   80x87 code generation                                                 }
{$D-   Disable generation of debug information                               }
{}
{$M $4000,0,0}  { Memory specifications }

uses Dos;

var  Command     : string;
     StartHour,
     StartMinute,
     StartSecond,
     StartSec100,
     StopHour,
     StopMinute,
     StopSecond,
     StopSec100  : word;
     UsedTime,
     StartTime,
     StopTime    : extended;


procedure ShowOptions;
begin
  WriteLn('Program : TIM  --  Program Execution Timer 2.0');
  WriteLn('Author  : Harald Thunem');
  WriteLn('Purpose : Find time used in program/command');
  WriteLn('Updated : July 10 1992');
  WriteLn;
  WriteLn('Usage   : TIM Command');
  WriteLn;
  WriteLn('          Ex:  TIM copy *.pas a:\');
  Halt(1);
end;


function UpcaseStr(s: string): string;
var i: byte;
begin
  for i := 1 to Length(s) do
    s[i] := Upcase(s[i]);
  UpcaseStr := s;
end;


procedure GetCommand(var Command: string);
var i: byte;
begin
  Command := '';
  if ParamCount=0 then ShowOptions;
  for i := 1 to ParamCount do
  Command := Command + UpcaseStr(ParamStr(i)) + ' ';
end;


{$F+}procedure ExecuteCommand(Command: string);{$F-}
begin
  SwapVectors;
  Exec(GetEnv('COMSPEC'),'/C '+Command);
  SwapVectors;
  if DosError<>0 then
    WriteLn('Could not execute ',Command,'. Dos error # ',DosError);
end;


function GetLongTime(H,M,S,S100: word): extended;
begin
  GetLongTime := (0.01*S100) + S + 60*M + 3600*H;
end;


function TimeStr(Time: extended): string;
var s1,s2: string;
    v    : extended;
begin
  v := Trunc(Time / 3600);
  Time := Time - v*3600;
  Str(v:1:0,s1);
  if Length(s1)=1 then s1 := '0'+s1;
  v := Trunc(Time / 60);
  Time := Time - v*60;
  Str(v:1:0,s2);
  if Length(s2)=1 then s2 := '0'+s2;
  s1 := s1 + ':' + s2;
  v := Time;
  Str(v:1:2,s2);
  if Length(s2)=4 then s2 := '0'+s2;
  s1 := s1 + ':' + s2;
  TimeStr := s1;
end;


begin
  GetCommand(Command);
  GetTime(StartHour,StartMinute,StartSecond,StartSec100);
  ExecuteCommand(Command);
  GetTime(StopHour,StopMinute,StopSecond,StopSec100);
  StartTime := GetLongTime(StartHour,StartMinute,StartSecond,StartSec100);
  StopTime := GetLongTime(StopHour,StopMinute,StopSecond,StopSec100);
  UsedTime := StopTime-StartTime;
  WriteLn;
  WriteLn('TIMER 2.0                                                    Written by H.Thunem');
  WriteLn('');
  WriteLn('Command    : ',Command);
  WriteLn('Start time : ',TimeStr(StartTime));
  WriteLn('Stop time  : ',TimeStr(StopTime));
  WriteLn('Used time  : ',TimeStr(UsedTime));
  WriteLn('');
end.
