program LoadVGA;

{ INFO Ŀ}
{ File    : LOADVGA.PAS                                                    }
{ Author  : Harald Thunem                                                  }
{ Purpose : Load a VGA palette from file.                                  }
{ Updated : July 11 1992                                                   }
{}

{ Compiler directives }
{$A+   Word align data                                                       }
{$B-   Short-circuit Boolean expression evaluation                           }
{$E-   Disable linking with 8087-emulating run-time library                  }
{$G+   Enable 80286 code generation                                          }
{$R-   Disable generation of range-checking code                             }
{$S-   Disable generation of stack-overflow checking code                    }
{$V-   String variable checking                                              }
{$X-   Disable Turbo Pascal's extended syntax                                }
{$N+   80x87 code generation                                                 }
{$D-   Disable generation of debug information                               }
{}

uses  Dos,
      Strings,
      Colors;

var   Path : PathStr;
      Dir  : DirStr;
      Name : NameStr;
      Ext  : ExtStr;

begin
  WriteLn('Load VGA Palette v2.0');
  WriteLn;
  if ParamCount<>1 then
  begin
    WriteLn('Wrong number of parameters.');
    WriteLn('Usage : LOADVGA filename[.ext]');
    Halt(1);
  end;
  Path := UpcaseStr(ParamStr(1));
  FSplit(Path,Dir,Name,Ext);
  if Ext='' then
    Path := Dir+Name+'.VGA';
  if ReadDACFile(Path) then
  begin
    SetColorList;
    WriteLn('Palette ',Name,' loaded.');
  end
  else WriteLn('Error loading palette file ',Path);
end.