program FileFinderExecuter;
{ INFO Ŀ}
{ File    : FFE.PAS                                                        }
{ Author  : Harald Thunem                                                  }
{ Purpose : Find files and execute command on them.                        }
{ Updated : July 10 1992                                                   }
{}

{ Compiler directives }
{$A+   Word align data                                                       }
{$B-   Short-circuit Boolean expression evaluation                           }
{$E-   Disable linking with 8087-emulating run-time library                  }
{$G+   Enable 80286 code generation                                          }
{$R-   Disable generation of range-checking code                             }
{$S-   Disable generation of stack-overflow checking code                    }
{$V-   String variable checking                                              }
{$X-   Disable Turbo Pascal's extended syntax                                }
{$N+   80x87 code generation                                                 }
{$D-   Disable generation of debug information                               }
{}
{$M $4000,0,0} { Set memory specifications }

uses Dos;

var  MainDir    : DirStr;
     SearchFile,
     Command    : string;

procedure ShowOptions;
begin
  WriteLn('Program : FFE  --  File Finder / Executer 2.0');
  WriteLn('Author  : Harald Thunem');
  WriteLn('Purpose : Find files and execute any command on them');
  WriteLn('Updated : July 10 1992');
  WriteLn;
  WriteLn('Usage   : FFE [D:]SearchFile [Command]');
  WriteLn;
  WriteLn('          SearchFile may contain wildcard ("*.PAS","NU*.?XE")');
  WriteLn('          Command is optional. Insert @ where you want the filename to appear.');
  WriteLn('          Ex:  FFE *.bak del @');
  Halt(1);
end;


function UpcaseStr(s: string): string;
var i: byte;
begin
  for i := 1 to Length(s) do
    s[i] := Upcase(s[i]);
  UpcaseStr := s;
end;


procedure GetCommands;
var i: byte;
    s: string;
    s2: string[2];
begin
  SearchFile := '';
  GetDir(0,MainDir);
  MainDir := Copy(MainDir,1,2);
  if ParamCount=0 then ShowOptions;

  SearchFile := UpcaseStr(ParamStr(1));

  s := '';
  if ParamCount>1 then
  for i := 2 to ParamCount do
    s := s + ParamStr(i) + ' ';
  s := UpcaseStr(s);
  if Pos('@',s)>0 then
    Command := s
  else Command := '';

  if Pos(':',SearchFile)>0 then
  begin
    MainDir := SearchFile[1]+':';
    Delete(SearchFile,1,2);
  end;
  if SearchFile[1]='\' then Delete(SearchFile,1,1);
end;


{$F+}procedure ProceedFile(MainDir: PathStr;  S: SearchRec);{$F-}
var CommandS: string;
    l: byte;
begin
  if Command='' then
    WriteLn(MainDir+S.Name)
  else begin
    CommandS := Command;
    l := Pos('@',CommandS);
    Delete(CommandS,l,1);
    Insert(MainDir+S.Name,CommandS,l);
    WriteLn(CommandS);
    SwapVectors;
    Exec(GetEnv('COMSPEC'),'/C '+CommandS);
    SwapVectors;
    if DosError<>0 then
      WriteLn('Could not execute ',CommandS,'. Dos error # ',DosError);
  end;
end;


procedure Search(MainDir: DirStr;  SearchFile: string; Attribute: word);
var S: SearchRec;
begin
  { Search for files }
  if Attribute and Directory <> Directory then
    Dec(Attribute,Directory);
  MainDir := MainDir + '\';
  FindFirst(MainDir+SearchFile,Attribute,S);
  while DosError = 0 do
  begin
    if (S.Attr and Attribute<>0) or
       (S.Attr and Directory<>0) then
       ProceedFile(MainDir,S);
    FindNext(S);
  end;

  { Search for sub-directories }
  FindFirst(MainDir+'*.*',Directory,S);
  while DosError = 0 do
  begin
    if (S.Attr and Directory<>0) and (S.Name[1]<>'.') then
      Search(MainDir+S.Name,SearchFile,Attribute);
    FindNext(S);
  end;
end;


begin
  WriteLn('FFE 2.0                                                      Written by H.Thunem');
  WriteLn('');
  GetCommands;
  WriteLn('File-spec: ',SearchFile);
  WriteLn('Command  : ',Command);
  WriteLn;
  Search(MainDir,SearchFile,AnyFile);
end.
