program ScreenEditor;
{ INFO Ŀ}
{ File    : SE.PAS                                                         }
{ Author  : Harald Thunem                                                  }
{ Purpose : Edit text screens.                                             }
{ Updated : July 11 1992                                                   }
{}

{ Compiler directives }
{$A+   Word align data                                                       }
{$B-   Short-circuit Boolean expression evaluation                           }
{$E-   Disable linking with 8087-emulating run-time library                  }
{$G+   Enable 80286 code generation                                          }
{$R-   Disable generation of range-checking code                             }
{$S-   Disable generation of stack-overflow checking code                    }
{$V-   String variable checking                                              }
{$X-   Disable Turbo Pascal's extended syntax                                }
{$N+   80x87 code generation                                                 }
{$D-   Disable generation of debug information                               }
{}

uses  Dos,
      Screen,
      Common,
      Strings,
      Keyboard;

var   DrawChar: char;
      DrawAttr,
      BoxType,
      MainR,
      MainC   : byte;
      Filename: string;
      Dir     : DirStr;
      Name    : NameStr;
      Ext     : ExtStr;
      ShowPos : boolean;
      PosStr  : array[1..5] of record
                                 c: char;
                                 a: byte;
                               end;


procedure About;
const ARow  = 7;
      ACol  = 13;
      ARows = 10;
      ACols = 54;
var A,i,j: byte;
begin
  Fill(1,1,25,80,White+BlueBG,'');
  Fill(ARow,ACol,ARows,ACols,White+LightBlackBG,' ');
  AddShadow(ARow,ACol,ARows,ACols);
  Fill(ARow,ACol,1,ACols,Green+LightWhiteBG,' ');
  WriteC(ARow,ACol+(ACols div 2),SameAttr,'About');
  { Blue }
  Fill(ARow+1,ACol,ARows-1,3,White+LightBlueBG,' ');
  Fill(ARow+1,ACol+ACols-3,ARows-1,3,White+LightBlueBG,' ');
  { Green }
  Fill(ARow+1,ACol+3,ARows-1,3,White+LightGreenBG,' ');
  Fill(ARow+1,ACol+ACols-6,ARows-1,3,White+LightGreenBG,' ');
  { Cyan }
  Fill(ARow+1,ACol+6,ARows-1,3,White+LightCyanBG,' ');
  Fill(ARow+1,ACol+ACols-9,ARows-1,3,White+LightCyanBG,' ');
  { Red }
  Fill(ARow+1,ACol+9,ARows-1,3,White+LightRedBG,' ');
  Fill(ARow+1,ACol+ACols-12,ARows-1,3,White+LightRedBG,' ');
  { Magenta }
  Fill(ARow+1,ACol+12,ARows-1,3,White+LightMagentaBG,' ');
  Fill(ARow+1,ACol+ACols-15,ARows-1,3,White+LightMagentaBG,' ');
  { Change middle attribute }
  for i := (ARow+4) to (ARow+6) do
  for j := ACol to (ACol+ACols-1) do
  begin
    A := ReadAttr(i,j);
    A := A and $7F;
    Attr(i,j,1,1,A);
  end;
  { Text }
  WriteC(ARow+4,ACol+(ACols div 2),SameAttr,'Screen Editor 2.0');
  WriteC(ARow+5,ACol+(ACols div 2),SameAttr,'by');
  WriteC(ARow+6,ACol+(ACols div 2),SameAttr,'Harald  Thunem');
  Inkey(Ch,Key);
  Key := NullKey;
end;


procedure SelectChar(var DrawChar: char);
const SAttr1 = White+BlackBG;
      SAttr2 = Yellow+RedBG;
      SRow   = 5;
      SCol   = 20;
      SRows  = 10;
      SCols  = 34;
var i: byte;
begin
  GetMem(ScrVar,2*25*80);
  StoreToMem(1,1,25,80,ScrVar^);
  Explode(SRow,SCol,SRows,SCols,SAttr1,SingleBorder);
  AddShadow(SRow,SCol,SRows,SCols);
  WriteC(SRow,SCol-1+(SCols div 2),SAttr1,' Select character ');
  for i := 0 to 255 do
    WriteStr(SRow+1+(i div 32),SCol+1+(i mod 32),SAttr1,Chr(i));
  i := Ord(DrawChar);
  WriteStr(SRow+1+(i div 32),SCol+1+(i mod 32),SAttr2,Chr(i));
  repeat
    InKey(Ch,Key);
    WriteStr(SRow+1+(i div 32),SCol+1+(i mod 32),SAttr1,Chr(i));
    case Key of
      UpArrow   : Dec(i,32);
      DownArrow : Inc(i,32);
      LeftArrow : Dec(i);
      RightArrow: Inc(i);
    end;
    WriteStr(SRow+1+(i div 32),SCol+1+(i mod 32),SAttr2,Chr(i));
  until Key in [Escape,Return];
  if Key=Return then
    DrawChar := Chr(i);
  StoreToScr(1,1,25,80,ScrVar^);
  FreeMem(ScrVar,2*25*80);
end;


procedure SelectAttr(var DrawAttr: byte);
const SAttr  = White+BlackBG;
      SRow   = 5;
      SCol   = 20;
      SRows  = 10;
      SCols  = 34;
var i: byte;
begin
  GetMem(ScrVar,2*25*80);
  StoreToMem(1,1,25,80,ScrVar^);
  Explode(SRow,SCol,SRows,SCols,SAttr,SingleBorder);
  AddShadow(SRow,SCol,SRows,SCols);
  WriteC(SRow,SCol-1+(SCols div 2),SAttr,' Select attribute ');
  for i := 0 to 255 do
    WriteStr(SRow+1+(i div 32),SCol+1+(i mod 32),i,'');
  i := DrawAttr;
  WriteStr(SRow+1+(i div 32),SCol+1+(i mod 32),i,'X');
  repeat
    InKey(Ch,Key);
    WriteStr(SRow+1+(i div 32),SCol+1+(i mod 32),i,'');
    case Key of
      UpArrow   : Dec(i,32);
      DownArrow : Inc(i,32);
      LeftArrow : Dec(i);
      RightArrow: Inc(i);
    end;
    WriteStr(SRow+1+(i div 32),SCol+1+(i mod 32),i,'X');
  until Key in [Escape,Return];
  if Key=Return then
    DrawAttr := i;
  StoreToScr(1,1,25,80,ScrVar^);
  FreeMem(ScrVar,2*25*80);
end;


procedure FillCharOrAttr(var DrawChar: char;  var DrawAttr: byte;  DC: boolean);
var R,C: byte;
begin
  if DC then
    SelectChar(DrawChar)
  else SelectAttr(DrawAttr);
  if Key=Escape then Exit;
  GetMem(ScrVar,2*25*80);
  StoreToMem(1,1,25,80,ScrVar^);
  R := MainR;
  C := MainC;
  Inc(MainR);
  Inc(MainC);
  if DC then
    FillCh(R,C,MainR-R+1,MainC-C+1,DrawChar)
  else Attr(R,C,MainR-R+1,MainC-C+1,DrawAttr);
  repeat
    InKey(Ch,Key);
    StoreToScr(1,1,25,80,ScrVar^);
    case Key of
      UpArrow   : Dec(MainR);
      DownArrow : Inc(MainR);
      LeftArrow : Dec(MainC);
      RightArrow: Inc(MainC);
    end;
    if MainR>CRTRows then MainR:=CRTRows;
    if MainR<1 then MainR:=1;
    if MainC>80 then MainC:=80;
    if MainC<1 then MainC:=1;
    if DC then
      FillCh(R,C,MainR-R+1,MainC-C+1,DrawChar)
    else Attr(R,C,MainR-R+1,MainC-C+1,DrawAttr);
  until Key in [Return,Escape];
  if Key=Escape then
    StoreToScr(1,1,25,80,ScrVar^);
  FreeMem(ScrVar,2*25*80);
end;


procedure DrawBox(DrawBox: byte);
var R,C: byte;
begin
  GetMem(ScrVar,2*25*80);
  StoreToMem(1,1,25,80,ScrVar^);
  R := MainR;
  C := MainC;
  Inc(MainR,1);
  Inc(MainC,1);
  Box(R,C,MainR-R+1,MainC-C+1,DrawAttr,BoxType,' ');
  repeat
    InKey(Ch,Key);
    StoreToScr(1,1,25,80,ScrVar^);
    case Key of
      UpArrow   : Dec(MainR);
      DownArrow : Inc(MainR);
      LeftArrow : Dec(MainC);
      RightArrow: Inc(MainC);
    end;
    if MainR>CRTRows then MainR:=CRTRows;
    if MainR<1 then MainR:=1;
    if MainC>80 then MainC:=80;
    if MainC<1 then MainC:=1;
    Box(R,C,MainR-R+1,MainC-C+1,DrawAttr,BoxType,#0);
  until Key in [Return,Escape];
  if Key=Escape then
    StoreToScr(1,1,25,80,ScrVar^);
  FreeMem(ScrVar,2*25*80);
end;


procedure SelectBoxType(var BoxType: byte);
const SRow = 8;
      SCol = 20;
      SRows= 7;
      SCols= 40;
var   i    : byte;
begin
  GetMem(ScrVar,2*25*80);
  StoreToMem(1,1,25,80,ScrVar^);
  Explode(SRow,SCol,SRows,SCols,White+BlackBG,SingleBorder);
  AddShadow(SRow,SCol,SRows,SCols);
  WriteC(SRow,SCol+(SCols div 2),SameAttr,' Select Box Type ');
  WriteStr(SRow+1,SCol+3,White+BlackBG,'Empty Border             -- '+EmptyBorder);
  WriteStr(SRow+2,SCol+3,White+BlackBG,'Single Border            -- '+SBorder);
  WriteStr(SRow+3,SCol+3,White+BlackBG,'Double Border            -- '+DBorder);
  WriteStr(SRow+4,SCol+3,White+BlackBG,'Double Top, Single Side  -- '+DSBorder);
  WriteStr(SRow+5,SCol+3,White+BlackBG,'Single Top, Double Side  -- '+SDBorder);
  i := BoxType+1;
  Attr(SRow+i,SCol+2,1,36,Yellow+RedBG);
  repeat
    InKey(Ch,Key);
    Attr(SRow+i,SCol+2,1,36,White+BlackBG);
    case Key of
      UpArrow  : Dec(i);
      DownArrow: Inc(i);
    end;
    if i<1 then i:=5;
    if i>5 then i:=1;
    Attr(SRow+i,SCol+2,1,36,Yellow+RedBG);
  until Key in [Escape,Return];
  if Key=Return then
    BoxType := i-1;
  StoreToScr(1,1,25,80,ScrVar^);
  FreeMem(ScrVar,2*25*80);
end;


procedure SaveScrFile(var Filename: string);
const SRow=11;
      SCol=26;
var   Tmp: string;
begin
  GetMem(ScrVar,2*25*80);
  StoreToMem(1,1,25,80,ScrVar^);
  Tmp := Filename;
  Box(SRow+1,SCol,3,26,White+GreenBG,SingleBorder,' ');
  AddShadow(Srow,SCol,4,26);
  Fill(SRow,SCol,1,26,Green+LightWhiteBG,' ');
  WriteC(SRow,SCol+13,SameAttr,'Save File');
  WriteStr(SRow+2,SCol+3,SameAttr,'File :');
  InputString(Tmp,SRow+2,SCol+11,12,Yellow+LightBlackBG,[Escape,Return]);
  StoreToScr(1,1,25,80,ScrVar^);
  FreeMem(ScrVar,2*25*80);
  if Key=Return then
  begin
    Filename := Tmp;
    SaveScreenToFile(Filename);
  end;
  Key := NullKey;
end;


procedure OpenScrFile(var Filename: string);
var Tmp: string;
begin
  GetDir(0,CurrentPath);
  if Length(CurrentPath)>3 then
    CurrentPath := CurrentPath + '\';
  SearchPath := '*.SCR';
  OpenFile(4,20,Tmp);
  if Key=Return then
    if LoadScreenFromFile(Tmp) then
    begin
      FSplit(Tmp,Dir,Name,Ext);
      Filename := Name+Ext;
    end
    else MessageBox('Error loading file!');
  Key := NullKey;
end;


procedure Help;
const HRow = 1;
      HCol = 15;
      HRows= 24;
      HCols= 50;
begin
  GetMem(ScrVar,2*25*80);
  StoreToMem(1,1,25,80,ScrVar^);
  Explode(HRow+1,HCol,HRows-1,HCols,White+LightBlackBG,SingleBorder);
  AddShadow(HRow,HCol,HRows,HCols);
  Fill(HRow,HCol,1,HCols,Green+LightWhiteBG,' ');
  WriteC(HRow,HCol+(HCols div 2),SameAttr,'Help');
  WriteStr(HRow+ 2,HCol+3,LightCyan+LightBlackBG,'COMMANDS');
  WriteStr(HRow+ 4,HCol+5,Yellow+LightBlackBG,'F1      ');
  WriteEos(SameAttr,'- This help');
  WriteStr(HRow+ 5,HCol+5,Yellow+LightBlackBG,'F2      ');
  WriteEos(SameAttr,'- Save screen to file');
  WriteStr(HRow+ 6,HCol+5,Yellow+LightBlackBG,'F3      ');
  WriteEos(SameAttr,'- Load screen from file');
  WriteStr(HRow+ 7,HCol+5,Yellow+LightBlackBG,'AltA    ');
  WriteEos(SameAttr,'- Select Attribute');
  WriteStr(HRow+ 8,HCol+5,Yellow+LightBlackBG,'AltB    ');
  WriteEos(SameAttr,'- Draw Box');
  WriteStr(HRow+ 9,HCol+5,Yellow+LightBlackBG,'AltC    ');
  WriteEos(SameAttr,'- Select Character');
  WriteStr(HRow+10,HCol+5,Yellow+LightBlackBG,'AltP    ');
  WriteEos(SameAttr,'- Show Cursor Position');
  WriteStr(HRow+11,HCol+5,Yellow+LightBlackBG,'AltF1   ');
  WriteEos(SameAttr,'- Fill area with Attribute');
  WriteStr(HRow+12,HCol+5,Yellow+LightBlackBG,'AltF2   ');
  WriteEos(SameAttr,'- Fill area with Character');
  WriteStr(HRow+13,HCol+5,Yellow+LightBlackBG,'AltF3   ');
  WriteEos(SameAttr,'- Select Box Type');
  WriteStr(HRow+14,HCol+5,Yellow+LightBlackBG,#27+#24+#25+#26+'    ');
  WriteEos(SameAttr,'- Move Cursor');
  WriteStr(HRow+15,HCol+5,Yellow+LightBlackBG,'Home    ');
  WriteEos(SameAttr,'- Move to upper left corner');
  WriteStr(HRow+16,HCol+5,Yellow+LightBlackBG,'End     ');
  WriteEos(SameAttr,'- Move to lower left corner');
  WriteStr(HRow+17,HCol+5,Yellow+LightBlackBG,'PgUp    ');
  WriteEos(SameAttr,'- Move to upper right corner');
  WriteStr(HRow+18,HCol+5,Yellow+LightBlackBG,'PgDn    ');
  WriteEos(SameAttr,'- Move to lower right corner');
  WriteStr(HRow+19,HCol+5,Yellow+LightBlackBG,'Space   ');
  WriteEos(SameAttr,'- Draw with current Attr and Char');
  WriteStr(HRow+20,HCol+5,Yellow+LightBlackBG,'Char-Key');
  WriteEos(SameAttr,'- Write Char');
  WriteStr(HRow+22,HCol+5,Yellow+LightBlackBG,'AltX    ');
  WriteEos(SameAttr,'- Quit program');

  InKey(Ch,Key);
  StoreToScr(1,1,25,80,ScrVar^);
  FreeMem(ScrVar,2*25*80);
end;


procedure ReadPosBack;
var i: byte;
begin
  for i := 1 to 5 do
  begin
    PosStr[i].C := ReadChar(1,75+i);
    PosStr[i].A := ReadAttr(1,75+i);
  end;
end;


procedure WritePosBack;
var i: byte;
begin
  for i := 1 to 5 do
  with PosStr[i] do
    WriteStr(1,75+i,A,C);
end;


procedure WritePos(R,C: byte);
begin
  WriteStr(1,76,White+BlueBG,'  ,  ');
  WriteStr(1,76,SameAttr,StrLF(R,2));
  WriteStr(1,79,SameAttr,StrLF(C,2));
end;


procedure Main;
var A: byte;
begin
  MainR := 12;
  MainC := 40;
  BoxType := 1;
  ShowPos := false;
  Filename := 'NONAME00.SCR';
  DrawAttr := White+BlueBG;
  DrawChar := 'A';
  repeat
    if ShowPos then
    begin
      ReadPosBack;
      WritePos(MainR,MainC);
    end;
    A := not ReadAttr(MainR,MainC);
    Attr(MainR,MainC,1,1,A);
    Key := NullKey;
    InKey(Ch,Key);
    Attr(MainR,MainC,1,1,not A);
    if ShowPos then WritePosBack;
    case Key of
      UpArrow   : Dec(MainR);
      DownArrow : Inc(MainR);
      LeftArrow : Dec(MainC);
      RightArrow: Inc(MainC);
      TextKey   : begin
                    DrawChar := Ch;
                    WriteStr(MainR,MainC,DrawAttr,DrawChar);
                    Inc(MainC);
                  end;
      Space     : WriteStr(MainR,MainC,DrawAttr,DrawChar);
      AltA      : SelectAttr(DrawAttr);
      AltC      : SelectChar(DrawChar);
      AltB      : DrawBox(BoxType);
      AltP      : ShowPos := not ShowPos;

      HomeKey   : begin
                    MainR := 1;
                    MainC := 1;
                  end;
      EndKey    : begin
                    MainR := 25;
                    MainC := 1;
                  end;
      PgUp      : begin
                    MainR := 1;
                    MainC := 80;
                  end;
      PgDn      : begin
                    MainR := 25;
                    MainC := 80;
                  end;
      F1        : Help;
      F2        : SaveScrFile(Filename);
      F3        : OpenScrFile(Filename);
      AltF1     : FillCharOrAttr(DrawChar,DrawAttr,false);
      AltF2     : FillCharOrAttr(DrawChar,DrawAttr,true);
      AltF3     : SelectBoxType(BoxType);
      AltX      : ;
      else        WriteStr(MainR,MainC,DrawAttr,Ch);
    end;
    if MainR>CRTRows then MainR:=CRTRows;
    if MainR<1 then MainR:=1;
    if MainC>80 then MainC:=80;
    if MainC<1 then MainC:=1;
  until Key=AltX;
  Attr(MainR,MainC,1,1,not A);
  if Confirm('Save file before quitting',true) then
    SaveScrFile(Filename);
end;


begin
  SetCursor(CursorOff);
  SetIntens;
  About;
  ClrScr;
  Main;
  Fill(25,1,1,80,White+BlackBG,' ');
  GoToRC(24,1);
  SetBlink;
  SetCursor(CursorUnderline);
end.