{  Kuba_MSE
   Mouse Routines by Kuba Fast
   Freely distribuitable, modificable and deletable. }

unit Kuba_Mse;


interface

type
     KMCPointer = ^KMCFile;		{Structure of .KMC files}
     KMCFile = record
             HSpotX : byte;
             HSpotY : byte;
             Mask   : array[0..1,0..15] of word;
             end;

var Mouse : boolean;

const Left  : word = 1;
      Right : word = 2;

function  MouseReset : boolean;
procedure ShowMouse;
procedure HideMouse;
function  MouseX : word;
function  MouseY : word;
procedure SetMPos(x, y : word);
function  IsLeftButton : boolean;
function  IsRightButton : boolean;
procedure SetMRange(x1, y1, x2, y2 : word);
procedure SetMCursor(Mask : KMCPointer);
procedure SetMSensivity(XSens, YSens : word);
function  MDispPage : byte;
procedure SetMDispPage(pageNo : byte);
procedure LoadKMC(FName : string; var itspointer : KMCPointer);
procedure WriteKMC(FName : string; pntr : KMCPointer);

implementation

procedure WriteKMC(FName : string; pntr : KMCPointer);
var
f  : file;		{Well, this one is quite straightforward...}
begin
Assign(f, FName);
rewrite(f, 1);
Blockwrite(f, pntr^, SizeOf(KMCFile));
close(f);
end;

procedure LoadKMC(FName : string; var itspointer : KMCPointer);
var
f     : file;
begin
Assign(f, FName);	{This one too}
reset(f, 1);
GetMem(itspointer, sizeof(KMCFile));
Blockread(f, itspointer^, sizeof(KMCFile));
close(f);
end;

function MDispPage : byte; assembler;
asm
        mov ax, 01eh		{int 33h, function 1Eh}
        int 33h
        mov ax, bx
end;

procedure SetMDispPage(pageNo : byte); assembler;
asm
        mov ax, 1dh		{int 33h, function 1Dh}
        mov bl, pageNo		 {in: bl - active display page}
        int 33h
end;

procedure SetMSensivity(XSens, YSens : word); assembler;
asm
        cmp xsens, 0		{if 0 set to 8 (default}
        jne @@1
        mov xsens, 8
@@1:    cmp ysens, 0
        jne @@2
        mov ysens, 16
@@2:    mov ax, 0fh		{int 33h, function 0Fh}
        mov cx, xsens		{in: cx - horizontal sensivity (mickey/pixel)}
        mov dx, ysens		    {dx - vertical sensivity}
        int 33h
end;

procedure SetMCursor(Mask : KMCPointer); assembler;
asm
        les dx, [Mask]		{this one will stay uncommented as I can't}
        mov bp, dx		{remember how it worked and I am not in }
        xor bh, bh		{mood to work it out}
        mov bl, es:[bp]
        xor ch, ch
        mov cl, es:[bp+1]
        inc dx
        inc dx
        mov ax, 9
        int 33h
end;

procedure SetMRange(x1, y1, x2, y2 : word); assembler;
asm
        mov ax, 7		{this one's easy...}
        mov cx, x1
        mov dx, x2
        int 33h
        mov ax, 8
        mov cx, y1
        mov dx, y2
        int 33h
end;

function IsRightButton : boolean; assembler;
asm
        mov ax, 3		{this one too...}
        int 33h
        and bx, right
        cmp bx, right
        jne @@1
        mov al, 1
        jmp @@2
@@1:    xor al, al
@@2:
end;

function IsLeftButton : boolean; assembler;
asm
        mov ax, 3		{that's nearly the same}
        int 33h
        and bx, left
        cmp bx, left
        jne @@1
        mov al, 1
        jmp @@2
@@1:    xor al, al
@@2:
end;

procedure SetMPos(x,y : word); assembler;
asm
        mov ax,4		{another int 33 func}
        mov cx, x
        mov dx, y
        int 33h
end;

function MouseY : word; assembler;
asm
        mov ax, 3		{...}
        int 33h
        mov ax, dx
end;

function MouseX : word; assembler;
asm
        mov ax, 3		{*yawn*}
        int 33h
        mov ax, cx
	shr ax, 1
end;

procedure HideMouse; assembler;
asm
        cmp Mouse, 0		{;-)}
        je @@1
        mov ax, 2
        int 33h
        dec Mouse
@@1:
end;

procedure ShowMouse; assembler;
asm
        cmp Mouse, 0		{:O}
        jne @@1
        mov ax, 1
        int 33h
        inc Mouse
@@1:
end;

function MouseReset : boolean; assembler;
asm
        xor ax, ax
        int 33h
        cmp ax, 0ffffh
        je @@1
        xor ax, ax
        jmp @@2
@@1:    mov ax, 1
@@2:
end;

begin
Mouse:=FALSE;
writeln('Kuba_MSE 1.2 Mouse Handling Library - (c) Jakub Fast 1995');
writeln('     MSE: Init...');
writeln('     MSE: Var Setting...');
end.