Program Line(Input,Output);
Uses Crt, Dos;
Const
     VERSION = 3.05;
Var
   Infile      : Text;                           { input file }
   Buffer      : String;                         { buffer for input file }
   Count       : Longint;                        { current line count }
   FileName    : String;                         { file name of input file }
   s255        : String;                         { buffer for 80+ line }
   LongCount   : Longint;                        { total lines with 80+ }
   Maxlength   : Integer;                        { maximum line length }
   PageCount   : Integer;                        { total page count }
   LineCount   : Longint;                        { total line count }
   LinePerPage : Integer;                        { line per page }


Procedure ReadParam; (* Read all command line paramaters *)
var i,j,k : Integer;
    s   : String;
begin
     LinePerPage := 60;
     FOR i := 1 to ParamCount DO
     BEGIN
          s := ParamStr(i);
          CASE s[1] OF
               '?' : BEGIN
                          Writeln('LINE <Filename.ext> [/Px]');
                          Write  ('      /Px - Define the number of lines ');
                          Writeln('per game.');
                          Halt(0);
                     END;
               '/' : BEGIN
                          CASE s[2] OF
                               'p','P' : BEGIN
                                              Val(Copy(s,3,80),j,k);
                                              LinePerPage := j;
                                          END;
                          END;
                     END;
               ELSE Filename := s;
          END;
     END;
END;

BEGIN
     Writeln;
     Writeln('LINE - Line Counting utility.');
     Writeln('v',VERSION:4:2,' Written by Seng On, 06-14-1991');
     Writeln;

     IF ParamCount = 0 THEN
        Writeln('File name required!')
     ELSE
     BEGIN
          ReadParam;
{$I-}     Assign(Infile,FileName);
          Reset(Infile);
{$I+}
          IF IOResult = 0 THEN
          BEGIN
               TextColor(Blink+7);
               Write('Counting ...');
               TextColor(7);
               Count := 0; LongCount := 0; MaxLength := 0; PageCount := 0;
               LineCount := 0;

               WHILE NOT EOF(Infile) DO
               BEGIN
                    Readln(Infile,s255);
                    Buffer := Copy(s255,1,80);
                    Inc(Count); Inc(LineCount);

                    WHILE ((Pos(Chr(12),Buffer) > 0) AND (Length(Buffer) > 0)) DO
                    BEGIN
                         Inc(PageCount); Count := 1;
                         Buffer := Copy(Buffer,Pos(Chr(12),Buffer)+1,80);
                    END;

                    IF (Count >= LinePerPage) THEN
                    BEGIN
                         Inc(PageCount);
                         Count := Count - LinePerPage;
                    END;

                    IF Length(s255)>80 THEN Inc(LongCount);

                    IF Length(s255)>MaxLength THEN Maxlength := Length(s255);
               END;

               Close(Infile);

               IF Count <> 0 THEN Inc(PageCount);

               Gotoxy(1,Wherey);
               Write('LINE reports ',LineCount,' lines in ',FileName);
               Writeln(' (MPRINT = ',PageCount,' pages[',LinePerPage,'])');
               Write('Number of line(s) with 80+ characters = ',LongCount);
               Writeln(' (Longest line = ',MaxLength,' characters)');
          END ELSE Writeln('Unable to open ',FileName);

     END;
END.
