PROGRAM LinkText;
USES Crt;
TYPE
  AnyStr = STRING[255];
  LinePtr = ^LineRecType;
  LineRecType = RECORD
                  NextLine : LinePtr;
                  LineField : AnyStr;
                END;

VAR
  TextFile : Text;
  Head : LinePtr;
  Hold : LinePtr;
  Cur : LinePtr;
  FileName : AnyStr;
  Ok : Boolean;
  LineBuf : AnyStr;
  L : Integer;

  PROCEDURE LoadFile;

  BEGIN
    ClrScr;
    Write('Enter File Name: ');
    ReadLn(Filename);
    Assign(TextFile, FileName);
    {$I-} Reset(TextFile) {$I+} ;
    Ok := (IoResult = 0);
    IF Ok THEN
      BEGIN
        GetMem(Head, 4);
        Head^.NextLine := NIL;
        Hold := Head;
        WHILE NOT Eof(TextFile) DO
          BEGIN
            ReadLn(TextFile, LineBuf);
            GetMem(Cur, Length(LineBuf)+5);
            Hold^.NextLine := Cur;
            Cur^.NextLine := NIL;
            Hold := Cur;
            Cur^.LineField := LineBuf;
          END;
        Close(TextFile);
    END;
END;

PROCEDURE DisplayFile;

BEGIN
  ClrScr;
  Cur := Head^.NextLine;
  WHILE Cur <> NIL DO
    BEGIN
      WriteLn(Cur^.LineField);
      Cur := Cur^.NextLine;
    END;
END;

PROCEDURE DeleteLine(N : Integer);

VAR
  Count : Integer;
BEGIN
  Hold := Head;
  Cur := Head^.NextLine;
  Count := 1;
  WHILE (Count < N) AND (Cur <> NIL) DO
    BEGIN
      Hold := Cur;
      Cur := Head^.NextLine;
      Count := Succ(Count);
    END;
  IF (Cur <> NIL) AND (Count = N) THEN
    BEGIN
      Hold^.NextLine := Cur^.NextLine;
      FreeMem(Cur, Length(Cur^.LineField)+5);
    END;
END;

PROCEDURE InsertLine(N : Integer; NewStr : AnyStr);

VAR
  Count : Integer;
  NewLine : LinePtr;
BEGIN
  Hold := Head;
  Cur := Head^.NextLine;
  Count := 1;
  WHILE (Count < N) AND (Cur <> NIL) DO
    BEGIN
      Hold := Cur;
      Cur := Cur^.NextLine;
      Count := Succ(Count);
    END;
    GetMem(NewLine, Length(NewStr)+5);
    Hold^.NextLine := NewLine;
    NewLine^.NextLine := Cur;
    NewLine^.LineField := NewStr;
  END;

BEGIN
  LoadFile;
  IF Ok THEN
    BEGIN
      DisplayFile;
      WriteLn; Write('Enter line number to delete: '); ClrEol;
      ReadLn(L);
      DeleteLine(L);
      DisplayFile;
      WriteLn; Write('Insert string before what line? '); ClrEol;
      ReadLN(L);
      InsertLine(L, 'This string to be inserted before line specified');
      DisplayFile;
    END
  ELSE WriteLn(FileName, 'NOT FOUND');
END.


