 {$X+}
 {By Steve Schaeffer}
 program PairedListBoxDemo;

 uses
   Dos,Objects,Drivers,Views,Dialogs,App;

 const
   cmTakeItem = 54321;

 type
   PDemo = ^TDemo;
   TDemo = object (TApplication)
     constructor Init;
     end;

   PPairedListBox = ^TPairedListBox;
   TPairedListBox = object (TListBox)
     procedure SelectItem (Item: Integer); virtual;
     procedure HandleEvent (var Event: TEvent); virtual;
     end;

   PItemRec = ^TItemRec;
   TItemRec = record
     OldOwner,ItemPtr: Pointer;
     end;

 procedure FillWithFiles (C: PStringCollection);

 var
   S: SearchRec;

 begin
 FindFirst ('*.*',AnyFile,S);
 repeat
   if (DosError = 0) and (S.Name[1] <> '.') then
     C^.Insert (NewStr (S.Name));
   FindNext (S);
   until DosError <> 0;
 end;

 
 constructor TDemo.Init;

 var
   D: PDialog;
   R: TRect;
   C: PStringCollection;
   L: PPairedListBox;
   SB: PScrollBar;

 begin
 TApplication.Init;
 R.Assign (20,5,60,15);
 D := New (PDialog,Init (R,'Paired List Boxes'));
 R.Assign (18,1,19,9);
 SB := New (PScrollBar,Init (R));
 D^.Insert (SB);
 R.Assign (1,1,18,9);
 L := New (PPairedListBox,Init (R,1,SB));
 C := New (PStringCollection,Init (10,10));
 FillWithFiles (C);
 L^.NewList (C);
 D^.Insert (L);
 R.Assign (38,1,39,9);
 SB := New (PScrollBar,Init (R));
 D^.Insert (SB);
 R.Assign (21,1,38,9);
 L := New (PPairedListBox,Init (R,1,SB));
 C := New (PStringCollection,Init (10,10));
 L^.NewList (C);
 D^.Insert (L);
 D^.SelectNext (False);
 DeskTop^.ExecView (D);
 end;

 procedure TPairedListBox.SelectItem (Item: Integer);

 var
   P: PItemRec;

 begin
 TListBox.SelectItem (Item);
 New (P);
 P^.ItemPtr := List^.At (Item);
 P^.OldOwner := @Self;
 List^.AtDelete (Item);
 SetRange (List^.Count);
 Message (Owner,evBroadcast,cmTakeItem,P);
 DrawView;
 end;

 procedure TPairedListBox.HandleEvent (var Event: TEvent);

 begin
 TListBox.HandleEvent (Event);
 case Event.What of
   evBroadcast: case Event.Command of
     cmTakeItem: if PItemRec (Event.InfoPtr)^.OldOwner <> @Self then
       begin
       List^.Insert (PItemRec (Event.InfoPtr)^.ItemPtr);
       SetRange (List^.Count);
       Dispose (PItemRec (Event.InfoPtr));
       ClearEvent (Event);
       DrawView;
       end;
     end;
   end;
 end;

 var
   Demo: TDemo;

 begin
 Demo.Init;
 Demo.Run;
 Demo.Done;
 end.
