 {$X+}
 program MultiSelectionListBoxDemo;

 uses
   Dos,Objects,Views,Dialogs,App;

 type
   PDemo = ^TDemo;
   TDemo = object (TApplication)
     constructor Init;
     end;

   PSelStr = ^TSelStr;
   TSelStr = object (TObject)
     Selected: Boolean;
     Name: PString;
     constructor Init (AName: String);
     destructor Done; virtual;
     function GetSel: Boolean; virtual;
     function GetText: String; virtual;
     procedure SetSel (AState: Boolean); virtual;
     end;

   PSelStrCollection = ^TSelStrCollection;
   TSelStrCollection = object (TSortedCollection)
     function Compare (Key1,Key2: Pointer): Integer; virtual;
     end;

   PMultiSelListBox = ^TMultiSelListBox;
   TMultiSelListBox = object (TListBox)
     function GetText (Item: Integer; MaxLen: Integer): String; virtual;
     procedure SelectItem (Item: Integer); virtual;
     end;

 procedure FillWithFiles (C: PSelStrCollection);

 var
   S: SearchRec;

 begin
 FindFirst ('*.*',AnyFile,S);
 repeat
   if (DosError = 0) and (S.Name[1] <> '.') then
     C^.Insert (New (PSelStr,Init (S.Name)));
   FindNext (S);
   until DosError <> 0;
 end;

 constructor TDemo.Init;

 var
   D: PDialog;
   C: PSelStrCollection;
   M: PMultiSelListBox;
   R: TRect;
   SB: PScrollBar;

 begin
 TApplication.Init;
 C := New (PSelStrCollection,Init (10,10));
 FillWithFiles (C);
 R.Assign (13,5,50,15);
 D := New (PDialog,Init (R,'Files available'));
 R.Assign (36,1,37,9);
 SB := New (PScrollBar,Init (R));
 D^.Insert (SB);
 R.Assign (1,1,36,9);
 M := New (PMultiSelListBox,Init (R,2,SB));
 M^.NewList (C);
 D^.Insert (M);
 DeskTop^.ExecView (D);
 end;

 constructor TSelStr.Init (AName: String);

 begin
 TObject.Init;
 Name := NewStr (AName);
 Selected := False;
 end;

 destructor TSelStr.Done;

 begin
 DisposeStr (Name);
 TObject.Done;
 end;

 function TSelStr.GetSel: Boolean;

 begin
 GetSel := Selected;
 end;

 function TSelStr.GetText: String;

 begin
 if Selected then GetText := '* ' + Name^
 else GetText := '  ' + Name^;
 end;

 procedure TSelStr.SetSel (AState: Boolean);

 begin
 Selected := AState;
 end;

 function TSelStrCollection.Compare (Key1,Key2: Pointer): Integer;

 begin
 if PSelStr (Key1)^.Name^ < PSelStr (Key2)^.Name^ then Compare := -1
 else if PSelStr (Key1)^.Name^ > PSelStr (Key2)^.Name^ then Compare := 1
 else Compare := 0;
 end;

 function TMultiSelListBox.GetText (Item: Integer; MaxLen: Integer): String;

 begin
 GetText := PSelStr (List^.At (Item))^.GetText;
 end;

 procedure TMultiSelListBox.SelectItem (Item: Integer);

 begin
 PSelStr (List^.At (Item))^.SetSel (not PSelStr (List^.At (Item))^.GetSel);
 DrawView;
 end;

 var
   Demo: TDemo;

 begin
 Demo.Init;
 Demo.Run;
 Demo.Done;
 end.


