{
      If you want to keep the dialog open while doing other things,
      use Insert rather than ExecView
}

program PARTS;
{$X+}
uses Objects, Drivers, Views, Menus, Dialogs, App, Memory, MsgBox;
     

const
  FileToRead        = 'PARTS.DAT';
  MaxLines          = 100;
  WinCount: Integer =   0;
  cmFileOpen        = 100;
  cmNewWin          = 101;
  cmNewDialog       = 102;
  cmListDlg         = 103;
  cmFinished        = 104;

var
  LineCount: Integer;
  Lines: array[0..MaxLines - 1] of PString;

type
  DialogData = record
    CheckBoxData: Word;
    InputLineData: String[128];
   end;

type
  TListData = record
    List: PStringCollection;
    Item: Integer;
  end;

  PListApp = ^TMyApp;
  TMyApp = object(TApplication)
    constructor Init;
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure InitMenuBar; virtual;
    procedure InitStatusLine; virtual;
    procedure NewDialog;
    procedure ListDlg;
  end;

  PDemoDialog = ^TDemoDialog;
  TDemoDialog = object(TDialog)
  end;

  PListDialog = ^TListDialog;
  TListDialog = object(TDialog)
    constructor Init(R: TRect; AName: TTitleStr);
    destructor Done; virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
  end;

  PMyListBox = ^TMyListBox;
  TMyListBox = Object(TListBox)
    procedure HandleEvent(var Event: TEvent); virtual;
  end;

var
  DemoDialogData: DialogData;

constructor TListDialog.Init(R: TRect; AName: TTitleStr);
var
  Box: PListBox;
  Scroll: PScrollBar;
begin
  TDialog.Init(R,AName);
  R.Assign(37,2,38,16);
  Scroll := New(PScrollBar, Init(R));
  Insert(Scroll);
  R.Assign(2,2,37,16);
  Box := New(PMyListBox, Init(R, 1, Scroll));
  Insert(Box);
  R.Assign(4, 18, 16, 20);
  Insert(New(PButton, Init(R, 'Cancel', cmCancel, bfNormal)));
  R.Assign(24, 18, 36, 20);
  Insert(New(PButton, Init(R, '~O~K', cmFinished, bfDefault)));
end;

destructor TListDialog.Done;
var
  S: String;
  ListData: TListData;
begin
  GetData(ListData);
  S := 'Selected at closing time: ' + PString(ListData.List^.At(ListData.Item))^;
  MessageBox(S, nil, mfOkButton + mfInformation);
  TDialog.Done;
end;

procedure TListDialog.HandleEvent(var Event: TEvent);
begin
  TDialog.HandleEvent(Event);
  if Event.What = evCommand then
  begin
    case Event.Command of
      cmFinished: Done;
    else
      Exit;
    end;
    ClearEvent(Event);
  end;
end;

procedure TMyListBox.HandleEvent(var Event: TEvent);
var
  S: String;
begin
  if Event.What = evMouseDown then
    if Event.Double then begin  
      S := 'You chose: ' + PString(List^.At(Focused))^;
      MessageBox(S, nil, mfOkButton + mfInformation);
      ClearEvent(Event);
    end;
  TListBox.HandleEvent(Event);
end;

constructor TMyApp.Init;
var
  R: TRect;
  Event: TEvent;
begin
  TApplication.Init;

  Event.What := evCommand;
  Event.Command := cmListDlg;
  PutEvent(Event);
end;

{TMyApp }

procedure TMyApp.HandleEvent(var Event: TEvent);
begin
  TApplication.HandleEvent(Event);
  if Event.What = evCommand then
  begin
    case Event.Command of
      cmListDlg: ListDlg;
      cmNewDialog: NewDialog;
    else
      Exit;
    end;
    ClearEvent(Event);
  end;
end;

procedure TMyApp.InitMenuBar;
var R: TRect;
begin
  GetExtent(R);
  R.B.Y := R.A.Y + 1;
  MenuBar := New(PMenuBar, Init(R, NewMenu(
    NewSubMenu('~F~ile', hcNoContext, NewMenu(
      NewLine(
      NewItem('E~x~it', 'Alt-X', kbAltX, cmQuit, hcNoContext,
      nil))),
    NewSubMenu('~W~indow', hcNoContext, NewMenu(
      NewItem('~N~ext', 'F6', kbF6, cmNext, hcNoContext,
      NewItem('~Z~oom', 'F5', kbF5, cmZoom, hcNoContext,
      NewItem('~D~ialog', 'F2', kbF2, cmNewDialog, hcNoContext,
      nil)))),
    nil))
  )));
end;

procedure TMyApp.InitStatusLine;
var R: TRect;
begin
  GetExtent(R);
  R.A.Y := R.B.Y - 1;
  StatusLine := New(PStatusLine, Init(R,
    NewStatusDef(0, $FFFF,
      NewStatusKey('', kbF10, cmMenu,
      NewStatusKey('~Alt-X~ Exit', kbAltX, cmQuit,
      NewStatusKey('~Alt-F3~ Close', kbAltF3, cmClose,
      nil))),
    nil)
  ));
end;

function CreateList: PStringCollection;
var
  F: Text;
  Lister: TListData;
  TheList: PStringCollection;
  S: String;
begin
  TheList := New(PStringCollection, Init(50, 25));
  Assign(F, 'PARTS.DAT');
  Reset(F);
  while not Eof(F) do
  begin
    Readln(F, S);
    if length(S) > 0 then
      TheList^.Insert(NewStr(S))
  end;
  Close(F);
  CreateList := TheList;
end;

procedure TMyApp.ListDlg;
var
  Lister: TListData;
  Dlg: PListDialog;
  R: TRect;
  Result: Word;
  ListData: TListData;
  S: String;
begin
  R.Assign(10,1,50,22);
  Dlg := New(PListDialog, Init(R, 'DblClick on item in list'));
  ListData.List := CreateList;
  ListData.Item := 1;
  Dlg^.SetData(ListData.List);
  DeskTop^.Insert(Dlg);
  {if Result <> cmCancel then begin
    Dlg^.GetData(ListData);
    S := 'Selected at closing time: ' + PString(ListData.List^.At(ListData.Item))^;
    MessageBox(S, nil, mfOkButton + mfInformation);
  end;
  Dispose(Dlg, Done); }
end;

procedure TMyApp.NewDialog;
var
  Ted: PView;
  Dialog: PDemoDialog;
  R: TRect;
  C: Word;
begin
  R.Assign(40, 1, 80, 10);
  Dialog := New(PDemoDialog, Init(R, 'Part Number Select'));
  with Dialog^ do
  begin
    R.Assign(3, 2, 18, 5);
    Ted := New(PCheckBoxes, Init(R,
      NewSItem('~C~heapest',
      NewSItem('~P~referred',
      NewSItem('~S~mallest',
      nil)))
    ));
    Insert(Ted);
    R.Assign(2, 1, 18, 2);
    Insert(New(PLabel, Init(R, 'Search Options', Ted)));
    R.Assign(3, 7, 37, 8);
    Ted := New(PInputLine, Init(R, 34));
    Insert(Ted);
    R.Assign(2, 6, 38, 7);
    Insert(New(PLabel, Init(R, 'Enter Vendor or Collins Part Number', Ted)));
    R.Assign(24, 2, 34, 4);
    Insert(New(PButton, Init(R, '~O~K', cmOK, bfDefault)));
    R.Assign(24, 4, 34, 6);
    Insert(New(PButton, Init(R, 'Cancel', cmCancel, bfNormal)));
  end;
  Dialog^.SetData(DemoDialogData);
  C := DeskTop^.ExecView(Dialog);
  if C <> cmCancel then Dialog^.GetData(DemoDialogData);
  Dispose(Dialog, Done);
end;

var
  MyApp: TMyApp;

begin
  with DemoDialogData do
  begin
     CheckBoxData := 1;
     InputLineData := 'Hi Ted';
  end;
  MyApp.Init;
  MyApp.Run;
  MyApp.Done;
end.
                                                                                                           