{
      Press F1 at any time to select the listbox
}

program PARTS;
{$X+}
uses Dos, Objects, Drivers, Views, Menus, Dialogs, App, Memory, MsgBox;


const
  FileToRead        = 'PARTS.DAT';
  MaxLines          = 100;
  WinCount: Integer =   0;
  cmFileOpen        = 100;
  cmNewWin          = 101;
  cmNewDialog       = 102;
  cmListDlg         = 103;
  cmNone            = 104;

var
  LineCount: Integer;
  Lines: array[0..MaxLines - 1] of PString;



type
  TListData = record
    List: PStringCollection;
    Item: Integer;
    S   : String[35];
    S1  : String[35];
  end;

  PListApp = ^TMyApp;
  TMyApp = object(TApplication)
    constructor Init;
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure InitMenuBar; virtual;
    procedure InitStatusLine; virtual;
    procedure ListDlg;
  end;


  PListDialog = ^TListDialog;
  TListDialog = object(TDialog)
      Box: PListBox;
    constructor Init(R: TRect; AName: TTitleStr);
    procedure HandleEvent(var Event: TEvent); virtual;
  end;

  PMyListBox = ^TMyListBox;
  TMyListBox = Object(TListBox)
    procedure HandleEvent(var Event: TEvent); virtual;
  end;


constructor TListDialog.Init(R: TRect; AName: TTitleStr);
var
  V: PView;
  Scroll: PScrollBar;
begin
  TDialog.Init(R,AName);

  {ListBox}
  R.Assign(37,2,38,12);
  Scroll := New(PScrollBar, Init(R));
  Insert(Scroll);
  R.Assign(2,2,37,12);
  Box := New(PMyListBox, Init(R, 1, Scroll));
  Insert(Box);

  R.Assign(15, 13, 38, 14);
  V := New(PInputLine, Init(R, 35));
  Insert(V);
  R.Assign(2, 13, 14, 14);
  Insert(New(PLabel, Init(R, 'Input Info', V)));

  R.Assign(15, 15, 38, 16);
  V := New(PInputLine, Init(R, 35));
  Insert(V);
  R.Assign(2, 15, 14, 16);
  Insert(New(PLabel, Init(R, 'Input Info', V)));

  {Buttons}
  R.Assign(4, 18, 16, 20);
  Insert(New(PButton, Init(R, 'Cancel', cmCancel, bfNormal)));
  R.Assign(24, 18, 36, 20);
  Insert(New(PButton, Init(R, '~O~K', cmOk, bfDefault)));
end;

procedure TListDialog.HandleEvent(var Event: TEvent);
begin
  TDialog.HandleEvent(Event);
  if Event.What = evKeyDown then
  begin
    case Event.KeyCode of
      kbF1: Box^.Select;
    else
      Exit;
    end;
    ClearEvent(Event);
  end;
end;


procedure TMyListBox.HandleEvent(var Event: TEvent);
var
  S: String;
begin
  if Event.What = evMouseDown then
    if Event.Double then begin  
      S := 'You chose: ' + PString(List^.At(Focused))^;
      MessageBox(S, nil, mfOkButton + mfInformation);
      ClearEvent(Event);
    end;
  TListBox.HandleEvent(Event);
end;

constructor TMyApp.Init;
var
  R: TRect;
  Event: TEvent;
begin
  TApplication.Init;

  Event.What := evCommand;
  Event.Command := cmListDlg;
  PutEvent(Event);
end;

{TMyApp }

procedure TMyApp.HandleEvent(var Event: TEvent);
begin
  TApplication.HandleEvent(Event);
  if Event.What = evCommand then
  begin
    case Event.Command of
      cmListDlg: ListDlg;
    else
      Exit;
    end;
    ClearEvent(Event);
  end;
end;

procedure TMyApp.InitMenuBar;
var R: TRect;
begin
  GetExtent(R);
  R.B.Y := R.A.Y + 1;
  MenuBar := New(PMenuBar, Init(R, NewMenu(
    NewSubMenu('~F~ile', hcNoContext, NewMenu(
      NewLine(
      NewItem('E~x~it', 'Alt-X', kbAltX, cmQuit, hcNoContext,
      nil))),
    NewSubMenu('~W~indow', hcNoContext, NewMenu(
      NewItem('~N~ext', 'F6', kbF6, cmNext, hcNoContext,
      NewItem('~Z~oom', 'F5', kbF5, cmZoom, hcNoContext,
      NewItem('~D~ialog', 'F2', kbF2, cmListDlg, hcNoContext,
      nil)))),
    nil))
  )));
end;

procedure TMyApp.InitStatusLine;
var R: TRect;
begin
  GetExtent(R);
  R.A.Y := R.B.Y - 1;
  StatusLine := New(PStatusLine, Init(R,
    NewStatusDef(0, $FFFF,
      NewStatusKey('', kbF10, cmMenu,
      NewStatusKey('~Alt-X~ Exit', kbAltX, cmQuit,
      NewStatusKey('~Alt-F3~ Close', kbAltF3, cmClose,
      NewStatusKey('~F1~ Focus list box', kbAltF1, cmNone,
      nil)))),
    nil)
  ));
end;

function CreateList: PStringCollection;
var
  TheList: PStringCollection;
  S: PString;
  Info: SearchRec;
begin
  TheList := New(PStringCollection, Init(50, 25));
  FindFirst('*.*', AnyFile, Info);
  While DosError=0 do begin
    S := NewStr(Info.Name);
    TheList^.Insert(S);
    FindNext(Info);
  End;
  CreateList := TheList;
end;

procedure TMyApp.ListDlg;
var
  Lister: TListData;
  Dlg: PListDialog;
  R: TRect;
  Result: Word;
  ListData: TListData;
  S: String;
begin
  R.Assign(10,1,50,22);
  Dlg := New(PListDialog, Init(R, 'DblClick on item in list'));
  ListData.List := CreateList;
  ListData.Item := 1;
  ListData.S := 'Foo';
  ListData.S1 := 'Jones';
  Dlg^.SetData(ListData.List);
  Result := DeskTop^.ExecView(Dlg);
  if Result <> cmCancel then begin
    Dlg^.GetData(ListData);
    S := 'Selected at closing time: ' + PString(ListData.List^.At(ListData.Item))^;
    MessageBox(S, nil, mfOkButton + mfInformation);
  end;
  Dispose(Dlg, Done);
end;

var
  MyApp: TMyApp;

begin
  MyApp.Init;
  MyApp.Run;
  MyApp.Done;
end.
                                                                                                           