{*****************************************************************}
{*   To : Jeff Hookham                                           *}
{    From: Charlie                                                }
{*   Subject : Losing memory using the pcollection in a list box *}
{    The issues were:                                             }
{    PStringCollection, HeapView, Dispose, Done                   }
{*****************************************************************}

{$X+}
program PRGBK16;

uses Objects,Menus,Views,Drivers,App,Dialogs, Gadgets;

type TLea = object(TApplication)
       Heap: PHeapView;
     constructor Init;
     procedure Idle; virtual;
     procedure InitMenuBar; virtual;
     procedure HandleEvent(var Event:TEvent); virtual;
     procedure BreadDialog;
     end;

const  cmBuybread = 100;

constructor TLea.Init;
var
  R: TRect;
begin
  TApplication.Init;
  GetExtent(R);
  Dec(R.B.X);
  R.A.X := R.B.X - 9; R.A.Y := R.B.Y - 1;
  Heap := New(PHeapView, Init(R));
  Insert(Heap);
end;

procedure TLea.Idle;

begin
  TApplication.Idle;
  Heap^.Update;
end;

function CreateColl: PStringCollection;
var
  NList: PStringCollection;
begin
  NList:=New(PStringCollection,Init(10,10));
  NList^.Insert(NewStr('Finished'));
  NList^.Insert(NewStr('Still warm'));
  NList^.Insert(NewStr('From today'));
  NList^.Insert(NewStr('Day old'));
  NList^.Insert(NewStr('A little hard'));
  NList^.Insert(NewStr('Hard'));
  NList^.Insert(NewStr('Hard as stone'));
  CreateColl := NList;
end;

procedure TLea.BreadDialog;
type
  TMyData = Record
    Col: PStringCollection;
    Item: Integer;
  end;

var
  R : TRect;
  D : PDialog;
  LB: PListBox;
  SB: PScrollBar;
  NListe: PStringCollection;
  MyData: TMyData;

begin
  NListe := CreateColl;
  R.Assign(0,0,60,12);
  D:=New(PDialog,Init(R,'Buy bread?'));
  with D^ do begin
    Options:=Options or ofCentered;
    R.Assign(19,3,20,7);
    SB:=New(PScrollBar,Init(R));
    insert(SB);
    R.Assign(3,3,19,7);
    LB:=New(PListBox,Init(R,1,SB));
    Insert(LB);
    R.Assign(30,9,41,11);
    Insert(New(PButton,Init(R, '~O~K', cmOK, bfdefault)));
  end;
  MyData.Col := NListe;
  MyData.Item := 1;
  D^.SetData(MyData);
  DeskTop^.ExecView(D);
  Dispose(Nliste, Done);
  Dispose(D, Done);
end;

procedure TLea.HandleEvent;
begin
TApplication.HandleEvent(Event);
If Event.What = evCommand then
  case Event.Command of
     cmBuybread : BreadDialog;
     end;
end;
 

procedure TLea.InitMenuBar;
var R:TRect;
begin
R.Assign(0,0,80,1);
MenuBar:=New(PMenuBar,Init(R,NewMenu(
 NewSubMenu('~O~ption',hcNoContext,NewMenu(
   NewItem('~B~uy bread','',kbNoKey, cmBuybread,hcNoContext, Nil)),
   NewItem('~Q~uit','',kbnoKey,cmQuit,hcNoContext, Nil)))));
 end;

var
  p:TLea;
begin
  p.init;
  p.run;
  p.done;
end.
