UNIT LogDev;

   (*==========================================================================
       LogDev.pas (c) Copyright M.P.B. Cole, 1990,1991. All Rights Reserved.
     ==========================================================================

    A "Text Device" to write formated entries to Binkley/Opus, FrontDoor
    or D'Bridge style logs.

   
      You are free to use and adapt this code with the following
      restrictions.

        1) You MAY NOT use this code in any commercial application or
           in a "Sharware" or any other such application which
           requests payment from the user, without express permission
           from the copyright holder. Such permission is unlikely to
           be withheld but I shall probably expect a freebi in return!

        2) You are free to distribute the original version of this
           code as long as you do not demand payment other than a
           nominal one to cover your costs (such as a BBS registration
           fee or postage) and in any event such a charge is not to
           exceed 5.00 unless it is a BBS Registration fee. Please
           distribute both the source code (logdev.pas) and the
           documentation (Logdev.doc) together and ensure the the
           dsitribution package name clearly indicates the version
           number. Preferably as an archive file named LOGPAS0x.xxx
           (eg. LOGPAS12.ARJ).

        3) You MAY NOT distribute altered versions of this code unless
           you distribute them with an altered file name AND with my
           original code included AND with all changes documented (in
           a seperate document). The distributed code MUST retain my
           copyright message and must bear the same restrictions on
           use as the original.

     ========================================================================*)


{ $Log:   E:/pavs/bbspavs/logdev.pav  $
 *
 *    Rev 1.7   29 May 1995 13:05:10   mark
 * All types except now add intro when opening log. Minor tidy up.
 * 
 *    Rev 1.6   10 Sep 1992 03:22:50   mark
 * Local "s" in LogDateString was to short, was [10] now [16]
 *
 *    Rev 1.5   13 Dec 1991 19:27:50   mark
 * No Changes.
 * 
 *    Rev 1.4   28 Nov 1991 15:55:56   mark
 * Released version.
 * 
 *    Rev 1.3   27 Nov 1991 16:19:30   mark
 * General tidy up for general release. 
 * Added D'bridge support
 * Removed back-compat with literal flag chars, all entries must now
 * be precceded by level not flag.
 * Tidied up Time/Date stamp functions.
 * Binkley type now adds Begin, End, entries automatically.
 * 
 *    Rev 1.2   11 Nov 1991 22:00:36   mark
 * Added "LogDev_IgnoreLevel". Forces LogLevel to be ignored (as long as it
 * is > 0). Use to save messing with LogLevel to force entries
 * into log.
 * 
 *    Rev 1.1   08 Jul 1991 19:35:14   mark
 * Added support for different log formats. Just Bink and FroDo at
 * the moment. New arg in AssignLog sets format.
 * 
 *    Rev 1.0   27 Dec 1990 18:00:32   mark
 * Initial revision.

Original version 1989.
}


{--------}
INTERFACE
{--------}

uses Dos;

type   Str8 = string[8];
       LogTypes = (Binkley,FrontDoor,DBridge);

const  Logdev_AssumeLastFlag: boolean = true;
       LogDev_ScreenHandle:   word = 2;         { STDERR }
       LogDev_Intro:          string = '';      { Sigature used in log file }
       LogDev_EatErrors:      boolean = false;  { Don't allow errors }
       LogDev_IgnoreLevel:    boolean = false;  { Ignore level flags as long
                                                  as loglevel > 0}

 { Assign a log file - see docs }
Procedure AssignLog(var f: Text; LogName: PathStr; LogType: LogTypes;
                           ProgID: str8; Level: Byte; ScreenLevel: byte);

 { Change the logging level (priority) of an already open log file }
Procedure SetLogLevel(var f: Text; LogLevel,ScreenLevel: byte);


{-------------}
IMPLEMENTATION
{-------------}


type Str4 = string[4];
     Str16 = string[16];

     {* Define parameters for "UserData" section of TP FileRec *}
     Params = record
               LastFlag:  byte;            { Last log flags level }
               FlagNext:  boolean;         { Set after CR }
               UseScreen: byte;            { Echo to screen level }
               WriteOK:   boolean;         { True if loglevel clears entry}
               LogLevel:  byte;
               ProgID:    str8;            { Name for log entries eg "BINK" }
               LogType:   LogTypes;
               Unused:    byte;
             end;

var LogError: word;   { Last error value to pass back to TP }

Const DayNames: array[0..6] of string[3] = ('Sun','Mon','Tue','Wed',
                                            'Thu','Fri','Sat');
      MonthNames:      array[1..12] of string[3] = ('Jan','Feb','Mar','Apr',
                                                     'May','Jun','Jul','Aug',
                                                     'Sep','Oct','Nov','Dec');

      {* Characters to use as flags for different levels, you can fool
         with these but effects may be odd!
         Each set MUST be 5 characters long.
         You can safely define your own FrontDoor flags if you wish bearing
         in mind that they may conflict with other applications!

         xFlags[1] is used for level one entries, xFlags[2] for level 2 etc.
      *}

      BinkleyFlags =   '!+:# '; { note no * ("network") flag used here }
      FrontDoorFlags = '     '; { just spaces unless you change them }
      DBridgeFlags =   '     '; { -ditto- }

      {* FlagChars holds the actual set in use at run time *}
      FlagChars:       string[5] = BinkleyFlags; { default bink }



Procedure SetLogLevel(var f: Text; LogLevel,ScreenLevel: byte);
begin
     { Cannot alter initial level of zero - file is not opened }
  if ScreenLevel > 5 then ScreenLevel := 5;
  Params(TextRec(f).Userdata).UseScreen := ScreenLevel;
  if Params(TextRec(f).UserData).LogLevel = 0 then exit;

  if LogLevel > 5 then LogLevel := 5;
  Params(TextRec(f).UserData).LogLevel := LogLevel;
end;

Function DosOpen(var f: text): word;  { Open via int21 and return handle }

var Regs: Registers;
begin
  LogError := 0;
  if TextRec(f).Name[0] <> #0 then
   begin
     if TextRec(f).Mode = fmInOut then Regs.AX := $3D01 { Open:Write }
      else Regs.AX := $3C00;                            {Create:"normal"}
     { Add TP System File mode (only share bits 4 to 7) }
     Regs.AL := Regs.AL OR (FileMode and $F0);  
     Regs.DS := SEG(TextRec(f).Name);
     Regs.DX := OFS(TextRec(f).Name);
     Regs.CX := 0;
     MSDOS(Regs);
     if (Regs.Flags and FCarry = 0) then TextRec(f).Handle := Regs.AX
     else LogError := Regs.AX;
     { if mode = inout (append) seek eof (using zero offset from end of file) }
     if (LogError = 0) and (TextRec(f).Mode = fmInOut) then
      begin
        Regs.AX := $4202;  { Move Pointer:Method - offset from eof }
        Regs.BX := TextRec(f).Handle;
        Regs.CX := 0;      { Offset is zero           }
        Regs.DX := 0;
        MSDOS(Regs);
        if Regs.Flags and fCarry > 0 then LogError := Regs.AX;
      end;
   end else TextRec(f).Handle := 1;  { STDOUT }
   if LogError > 0 then TextRec(f).Handle := 0;
   DosOpen := LogError;
end;

Function DOSClose(var f: Text): word;
var Regs: Registers;
begin
  LogError := 0;
  if TextRec(f).Handle > 4 then   { don't close DOS standard handles }
   begin
     Regs.AX := $3E00;
     Regs.BX := TextRec(f).Handle;
     MSDos(Regs);
     if Regs.Flags and fCarry > 0 then LogError := Regs.AX;
   end;
  DOSClose := LogError;
end;

Function DOSWrite(Handle: word; s: string): word;
  { DOS Write to file }
var Regs: Registers;
begin
  if Handle = 0 then  { Belt and braces }
   begin
     DOSWrite := 0;
     exit;
   end;

  LogError := 0;
  Regs.AX := $4000;
  Regs.BX := Handle;
  Regs.CX := Length(s);
  Regs.DS := SEG(s[1]);
  Regs.DX := OFS(s[1]);
  MSDOS(Regs);
  if Regs.Flags and fCarry > 0 then LogError := Regs.AX;
  (*****  to flush buffers after each write (slooooow!)
  else begin
         Regs.AX := $6800;      { flush }
         Regs.BX := Handle;
         MSDOS(Regs);
         if Regs.Flags and fCarry > 0 then LogError := Regs.AX;
       end;
  ****)
  DOSWrite := LogError;
end;


Function PadNum(n: word): str4;
  { num to str with leading zero if needed }
var ns: str4;
begin
  str(n,ns);
  if n < 10 then ns := '0'+ns;
  PadNum := Ns;
end;

function LogDateString(LTyp: LogTypes):str16;
   { Date in format for log type
     Frodo  Wed 01 May 91
     Bink   01 May 91
     Dbr    05/01/91
   }
var Year,Month,Day,DayOfWeek:word;
  s: string[16];

begin
  getdate(Year,Month,Day,DayOfWeek);
  case LTyp of
      Binkley,FrontDoor:
       begin
         s := PadNum(Day)+' '+MonthNames[Month];
         s:=s+' '+copy(PadNum(Year),3,2);
         if LTyp = FrontDoor then s := DayNames[DayOfWeek] + ' '+s;
       end;
      DBridge: s := PadNum(Month)+'/'+PadNum(Day)+'/'+copy(PadNum(Year),3,2);
  end;
  LogDateString:=s;
end;

Function TimeString: str16;
  { Time as hh:mm:ss }
var Hour,Minute,Second,Sec100: word;

begin
  GetTime(Hour,Minute,Second,Sec100);
  TimeString := PadNum(Hour)+':'+PadNum(Minute)+':'+PadNum(Second);
end;

Function Stamp(LType: LogTypes): str16;
  { Time stamp appropriate for LogType }
var ds,ts: str16;
begin
  ds := LogDateString(LType);
  ts := TimeString;
  case LType of
       Binkley: Stamp := copy(Ds,1,6)+' '+TimeString;
       FrontDoor: begin
                    if Ts[1] = '0' then Ts[1] := ' ';
                    Stamp := Ts;
                  end;
      DBridge:  Stamp := Ds+' '+copy(Ts,1,5);
  end;
end;
                                      

Function SetLastFlag(var f: text; var Flag: char): boolean;
  { Convert to valid flag ie. '1'..'5' become FlagChar }
var b: byte;
begin
  SetLastFlag := true;
  with Params(TextRec(f).UserData) do
   {+ Is string reeceeded by an actual flag character??? +}
  if pos(Flag,FlagChars) > 0 then LastFlag := pos(Flag,FlagChars)
  else begin  { it should be a level number }
         if Flag in ['1'..'5'] then
          begin
            b := ord(Flag)-48;
            LastFlag := b;
          end
         else
          begin { Use prior flag or default to blank }
            SetLastFlag := false;
            {if not LogDev_AssumeLastFlag then LastFlag := ' ';}
            if not LogDev_AssumeLastFlag then LastFlag := 5;
          end;
       end;
end;

Procedure NewLogLine(var f: Text);
  { begin a new line in the log - add appropriate time/date/flag stamps }
var Ds: str16;
    s:  string;

begin
  with Params(TextRec(f).UserData) do
   begin
     Ds := LogDateString(LogType);
     if LogLevel > 0 then  { Belt & Braces! }
      begin
        case LogType of
          Binkley: s := FlagChars[LastFlag]+' '+Stamp(LogType)+' '
                         +Params(TextRec(f).UserData).ProgID+' ';


          FrontDoor: begin
                       s := FlagChars[LastFlag]+' '+Stamp(LogType)+'  ';
                   end;

          DBridge:   begin
                       s := Stamp(LogType)+' '+FlagChars[LastFlag];
                   end;
        end; { case }
       LogError := DOSWrite(TextRec(f).Handle,s);
      end;
   end;
end;

Function BufferOut(var f: Text): word;
  { Write the buffer.                                                        }
  { Called from "LogOut" which means that the buffer is full or the file is  }
  { being closed. For that reason I don't think that the additional check is }
  { required (below) for buffer full. I have left it in for safety!.         }
var Ch:       char;
    i,p:      integer;
    FlagGiven: boolean;
    ScreenWriteOK,LogWriteOK: boolean;

begin
  with TextRec(f) do
   begin
     p:=0;
     while p<BufPos do
      begin
        Ch := BufPtr^[p];
        with Params(UserData) do
         begin

          { If a flag is expected and this char is ascii > 31 then start a new}
          { line. If the char IS a genuine flag use it otherwise default the  }
          { flag either to the last used flag OR to "blank"                   }
          if FlagNext and (Ch in [#32..#127]) then
           begin { New line with flag given or default in not a flag }
             FlagGiven := SetLastFlag(f,Ch);
             FlagNext := false;
             LogWriteOK := (LogLevel >= LastFlag)
               OR ((LogLevel > 0) and LogDev_IgnoreLevel);
             ScreenWriteOK := UseScreen >= LastFlag;
             if LogWriteOK then NewLogLine(f);
             { If ch not a flag (ie. we defaulted a flag above) then write it }
             if not FlagGiven then
              begin
                if LogWriteOK then LogError := DOSWrite(Handle,ch);
                if ScreenWriteOK then i := DOSWrite(LogDev_ScreenHandle,ch);
              end;
           end
          else
           begin
             LogWriteOK := (LogLevel >= LastFlag)
               OR ((LogLevel > 0) and LogDev_IgnoreLevel);
             ScreenWriteOK := UseScreen >= LastFlag;
             FlagNext := ord(ch) < 32; { Expect flag next time }
             if LogWriteOK then LogError := DosWrite(Handle,ch);
             if ScreenWriteOK then i := DOSWrite(LogDev_ScreenHandle,ch);
           end;
         end;
        inc(p);
      end;
     bufpos:=0;
   end; { with }
  if (LogError > 0) and (LogDev_EatErrors) then
   begin
     Params(TextRec(f).UserData).LogLevel := 0;
     LogError := DosClose(f);
     LogError := 0;
   end;
  BufferOut := LogError;
end;

{$F+}

Function LogOut(var f: Text): integer;
    { The main I/O routine - called by Turbo in response to a READ/WRITE }
    { statement that addresses a file assigned with AssignLog()          }
    { This function is called when the output buffer is FULL and during  }
    { a CLOSE(f)                                                         }
var ch: char;
    i,p: integer;

begin
  LogOut := 0;       { No errors }
  LogError := InOutRes;
  if LogError = 0 then     { Do nothing if previous error exists }
   begin
    with TextRec(f) do
     begin
       if mode <> fmoutput then
        begin
          LogOut := 104;  { File not open for input}
          BufPos := 0;
          exit;
        end;
       LogOut := BufferOut(f);
     end; { with f }
   end; { LogError = 0 }
end;

Function LogFlush(var f: text): integer;
  { Called by TP after every WRITE statement is completed (so one call here }
  { for every WRITE/WRITELN in the main program.                            }
  { IS NOT called by TP when CLOSEing, CLOSE calls @OutFunct instead        }
begin
  LogFlush:=LogOut(f);
end;

Function LogClose(var f: text): integer;
  { Called by TP to close file }
begin
  if Params(TextRec(f).UserData).LogLevel > 0 then
   begin
     if Params(TextRec(f).UserData).LogType = Binkley then with TextRec(f) do
      begin
        LogError := DOSWrite(Handle,
        '+ '+copy(LogDateString(Binkley),1,6)
        +' '+TimeString+' '+
        Params(UserData).ProgID+' End, '+
        +LogDev_Intro+#13#10);
      end;
     LogClose := DosClose(f);
   end
  else LogClose := 0;
end;


Function LogOpen(var f: text): integer;
  { Called by TP RESET/REWRITE/APPEND to open/create file}
begin
  LogError := InOutRes;
  if LogError = 0 then     { Do nothing if previous error exists }
   begin
     with TextRec(f) do
      begin
        if Mode = fmInput then
         begin
           LogOpen := 12;      { Invalid access code - cannot do READ }
           exit;
         end;
        if Params(UserData).LogLevel > 0 then LogError := DosOpen(f);
        if LogError = 0 then
         begin
           InOutFunc:=@LogOut;     { address our i/o functions }
           FlushFunc:=@LogFlush;
           CloseFunc:=@LogClose;
           {BufSize:=1;}
           BufPos:=0;
           BufEnd:=0;
           {# write appropriate signature to newly opened file #}
           {# (none for binkley but write a blank line if APPEND used) #}
           if (Mode and fmOutput = fmOutput) and (Params(UserData).LogLevel > 0) then
            begin
              case Params(UserData).LogType of
                   Binkley:   begin
                                { write blank line if opened with Append()}
                                if Mode and fmInOut = fmInOut then
                                  LogError := DosWrite(Handle,#13#10);

                                LogError := DOSWrite(Handle,'+ '+Stamp(Binkley)
                                 +' '+Params(UserData).ProgID+' Begin, '
                                 +LogDev_Intro+#13#10);
                              end;

                   FrontDoor: LogError := DosWrite(Handle,#13#10'----------  '
                               +LogDateString(FrontDoor)+', '
                               +LogDev_Intro+#13#10);

                   DBridge:   LogError := DOSWrite(Handle,Stamp(DBridge)
                                 +'  '+LogDev_Intro+#13#10);
              end;
             end;
           Mode := fmOutput;      { in case it was fminOut (ie. Append) }
         end;
      end;
    end; { LogError = 0 }
  LogOpen := LogError;
end;

{$F-}

Procedure AssignLog(var f: Text; LogName: PathStr; LogType: LogTypes;
                        ProgID: str8; Level: Byte; ScreenLevel: byte);

var b: boolean;
    i: integer;

{ =========================================================================== }
{ =  This is the routine to be called by any program diverting its I/O      = }
{ =  to the LOG file.                                                       = }
{ =                                                                         = }
{ =  The assign call must, as usual, be followed by the appropriate RESET   = }
{ =  or APPEND command.                                                     = }
{ =                                                                         = }
{ = If a nul LogName is given (ie AssignLog(Output,''.....)                 = }
{ = the effect is the same as turbo assign, ie. file is linked to STDOUT    = }
{ =========================================================================== }


begin
  LogError := 0;
  with textrec(f) do
   begin
     Handle:=$FFFF;
     Mode:=fmClosed;
     Bufsize:=sizeof(Buffer);
     Bufptr:=@buffer;
     OpenFunc:=@LogOpen;
     FlagChars := '     ';
     i := 0;
     case LogType of
           Binkley:   FlagChars := BinkleyFlags;
           FrontDoor: FlagChars := FrontDoorFlags;
           DBridge:   FlagChars := DBridgeFlags;
     end;
     fillchar(Name,Sizeof(Name),0);
     for i := 1 to length(LogName) do Name[Pred(i)] := LogName[i];
     Params(UserData).LastFlag := 1;     { Default last level is 1}
     Params(UserData).FlagNext := TRUE;  { First time or After a CR }
     Params(UserData).LogLevel := Level;
     Params(UserData).WriteOK  := false;
     Params(UserData).ProgID   := ProgID;
     Params(UserData).UseScreen := ScreenLevel;
     Params(UserData).LogType := LogType;
   end;
end;


{============================================================================}
{=                              Initialise Unit                             =}
{============================================================================}

begin
  LogError := 0;
end.
