{************************************************}
{                                                }
{   Turbo Pascal for Windows                     }
{   Tips & Techniques Demo Program               }
{   Copyright (c) 1991 by Borland International  }
{                                                }
{************************************************}

program MenuDemo;

{$R T&TMenu}

uses WinTypes, WinProcs, WObjects;

const
  cm_Toggle  =  100;
  cm_Hello   =  101;
  cm_GoodBye =  102;
  MenuAdded: Boolean = false;

type
  PMyapp = ^TMyApp;
  TMyApp = object(TApplication)
    procedure InitMainWindow; virtual;
  end;

  PMyWindow = ^TMyWindow;
  TMyWindow = object(TWindow)
    constructor Init(AParent: PWindowsObject; ATitle: PChar);
    procedure Hello(var Message: TMessage);
      virtual cm_First + cm_Hello;
    procedure GoodBye(var Message: TMessage);
      virtual cm_First + cm_GoodBye;
    procedure Toggle(var Message: TMessage);
      virtual cm_First + cm_Toggle;
  end;

procedure TMyWindow.Toggle(var Message: TMessage);
begin
  if not MenuAdded then
    AppendMenu(GetSubMenu(Attr.Menu, 0), mf_Enabled, 102, '&GoodBye')
  else
    DeleteMenu(GetSubMenu(Attr.Menu, 0), 102, mf_ByCommand);
  if MenuAdded = True then
    MenuAdded := False
  else
    MenuAdded := True;
end;

procedure TMyWindow.Hello(var Message: TMessage);
begin
  MessageBox(HWindow, 'Hello everyone!', 'Incoming Memo',
    mb_IconInformation);
end;

procedure TMyWindow.GoodBye(var Message: TMessage);
begin
  MessageBox(HWindow, 'Goodbye now!', 'Incoming Memo', mb_IconInformation);
end;

constructor TMyWindow.Init(AParent: PWindowsObject; ATitle: PChar);
var
  GreetingMenu, PopUp: HMenu;
begin
  TWindow.Init(AParent, ATitle);
  GreetingMenu := CreateMenu;
  Attr.Menu := GreetingMenu;
  PopUp := CreatePopupMenu;
  AppendMenu(GreetingMenu, mf_PopUp, PopUp, '&Greetings');
  AppendMenu(PopUp, mf_BitMap or mf_Enabled, cm_Toggle,
    PChar(LoadBitMap(HInstance, 'MenuBitMap')));
  AppendMenu(PopUp, mf_Enabled, cm_Hello, '&Hello');
end;

procedure TMyApp.InitMainWindow;
begin
  MainWindow := New(PMyWindow, Init(Nil, 'Menu Demo'));
end;

var
  MyApp: TMyApp;

begin
  MyApp.Init('My Program');
  MyApp.Run;
  MyApp.Done;
end.