{$X+}
Program Messages;
{
  This example shows the way messages are sent between views
  in a dialog. The key point is that you often need to change
  EventMask of the view you are sending messages to. See the
  Init Procedure for the RadioButtons to understand how this
  is done.

  Capture the "Change Radio" button press and send a message
  to a RadioButton. This demonstrates how to send messages
  between views on a button press or any other event.

  To bring up the dialog select Alt D.
}

Uses
  App,
  Dialogs,
  Drivers,
  Menus,
  MsgBox,
  Views,
  Objects;

Const
  cmDialogBox = 101;
  cmAllDone = 102;
  cmRadioEvent= 125;
  InputLength = 128;

Type
  Consistency = (Solid, Runny, Melted);
  Cheese = (None, Hvarti, Tilset, Jarlsberg);

  PMyRadioButtons = ^TMyRadioButtons;
  TMyRadioButtons = Object(TRadioButtons)
    constructor Init(var Bounds: TRect; AStrings: PSItem);
    procedure HandleEvent(var Event: TEvent); virtual;
  end;

  TTransferRec = Record
    Checks: Word;
    Radio: Word;
    Input: String[InputLength];
  end;

  PTrainDialog = ^TTrainDialog;
  TTrainDialog = Object(TDialog)
    constructor Init(Bounds: TRect; ATitle: String);
  end;

  PMyButton = ^TMyButton;
  TMyButton = Object(TButton)
    procedure HandleEvent(var Event: TEvent); virtual;
  end;

  TMyApp = Object(TApplication)
    procedure InitMenuBar; virtual;
    procedure InitStatusLine; virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure DialogBox;
  end;

{---------------------- Implementation ------------------------}

procedure TMyButton.HandleEvent(var Event: TEvent);
begin
  if (Event.What = EvMouseDown) then
    Message(TopView, evBroadCast, cmRadioEvent, nil);
  TButton.HandleEvent(Event);
end;

constructor TMyRadioButtons.Init(var Bounds: TRect; ASTrings: PSItem);
begin
  TRadioButtons.Init(Bounds, AStrings);
  EventMask := EventMask or evBroadcast; { The key line }
end;

procedure TMyRadioButtons.HandleEvent(var Event: TEvent);
begin
  if (Event.what = evBroadcast) and (Event.Command = cmRadioEvent) then
    MessageBox('Message Sent', nil, mfOkButton);
  TRadioButtons.HandleEvent(Event);
end;

constructor TTrainDialog.Init(Bounds: TRect; ATitle: String);
var
  R: TRect;
  Control: PView;
  Trans: TTransferRec;
begin
  TDialog.Init(Bounds, ATitle);
  R.Assign(2, 2, 10, 3);
  Insert(New(PLabel, Init(R, '~C~heeses', Control)));
  R.Assign(3, 3, 18, 6);
  Control := New(PCheckBoxes, Init(R,
    NewSItem('~H~varti',
    NewSItem('~T~ilset',
    NewSItem('~J~arlsberg',
    nil)))
  ));
  Insert(Control);
  R.Assign(21, 2, 33, 3);
  Insert(New(PLabel, Init(R, 'C~o~nsistency', Control)));
  R.Assign(22, 3, 34, 6);
  Control := New(PMyRadioButtons, Init(R,
    NewSItem('~S~olid',
    NewSItem('~R~unny',
    NewSItem('~M~elted',
    nil)))
  ));
  Insert(Control);

  R.Assign(3, 8, 37, 9);
  Control := New(PInputLine, Init(R, InputLength));
  Insert(Control);
  R.Assign(2, 7, 24, 8);
  Insert(New(PLabel, Init(R, '~D~elivery instructions', Control)));
  R.Assign(15, 10, 25, 12);

  R.Assign(2, (Bounds.B.Y - Bounds.A.Y) - 3 , 20, (Bounds.B.Y - Bounds.A.Y) - 1);
  Insert(New(PMyButton, Init(R, 'Change Radio', cmAllDone, bfNormal)));
  R.Assign(20, (Bounds.B.Y - Bounds.A.Y) - 3, (Bounds.B.X - Bounds.A.X) - 2, (Bounds.B.Y - Bounds.A.Y) - 1);
  Insert(New(PButton, Init(R, 'O~k~', cmOk, bfDefault)));

  with Trans do begin
    Checks := Word(HVarti);
    Radio := Word(Melted);
    Input := 'Fooberg Pepperoni';
  end;

  SetData(Trans);
end;

procedure TMyApp.HandleEvent(var Event: TEvent);
begin
  TApplication.HandleEvent(Event);
  if Event.What = EvCommand then begin
    case Event.Command of
      cmDialogBox: DialogBox;
    else
      Exit;
    end;
    ClearEvent(Event);
  end;
end;

procedure TMyApp.InitMenuBar;
var
  R: TRect;
begin
  GetExtent(R);
  R.B.Y := R.A.Y + 1;
  MenuBar := New(PMenuBar, Init(R, NewMenu(
    NewSubMenu('~F~ile', hcNoContext, NewMenu(
      NewItem('~D~ialogs', 'Alt-D', kbAltD, cmDialogBox, hcNoContext,
      NewLine(
      NewItem('E~x~it', 'Alt-X', kbAltX, cmQuit, hcNoContext,
      nil)))),
    NewSubMenu('~W~indow', hcNoContext, NewMenu(
      NewItem('~N~ext', 'F6', kbF6, cmNext, hcNoContext,
      NewItem('~Z~oom', 'F5', kbF5, cmZoom, hcNoContext,
      nil))),
    nil))
  )));
end;

procedure TMyApp.InitStatusLine;
var R: TRect;
begin
  GetExtent(R);
  R.A.Y := R.B.Y - 1;
  StatusLine := New(PStatusLine, Init(R,
    NewStatusDef(0, $FFFF,
      NewStatusKey('', kbF10, cmMenu,
      NewStatusKey('~Alt-X~ Exit', kbAltX, cmQuit,
      NewStatusKey('~Alt-F3~ Close', kbAltF3, cmClose,
      nil))),
    nil)
  ));
end;

procedure TMyApp.DialogBox;
var
  R: TRect;
  D: PDialog;
  Control: Word;
begin
  R.Assign(20,5,60,21);
  D := New(PTrainDialog, Init(R, 'Training Dialog'));
  if ValidView(D) <> Nil then
    Control := DeskTop^.ExecView(D);
  Dispose(D, Done);
end;

var
  A: TMyApp;
begin
  A.Init;
  A.Run;
  A.Done;
end.