Unit Hooker;
{C Fixed Permanent}
Interface

uses WinProcs, WinTypes, OWindows;

Procedure Unhook;
Procedure InstallHook(hwindow:hwnd);

Implementation
var
  PrevHook: TFarProc;
  CallHandle:HWnd;
  SetBit:Boolean;

function FilterFun(Code: Integer; wParam: Word; lParam: Longint): LongInt; export;
type
  PMsg =^TMsg;
var
  CallPrev: Boolean;
  Result: integer;
  Msg: PMsg;

  procedure HandleMessage;
    begin
      if SetBit then begin
        PostMessage(CallHandle, WM_KeyDown, Vk_F12, LParam);
        SetBit:=false;
      end
      else SetBit := True;
    end;

begin
  CallPrev := False;
  Msg := PMsg(LParam);    
  if Msg^.Message = wm_SysCommand then HandleMessage
  else CallPrev := True;
  if (Code < 0) or CallPrev and (PrevHook <> nil) then
  begin
    Result := DefHookProc(Code, wParam, lParam, @PrevHook);
    FilterFun := Result;
  end;
end;

var
  Filter: TFarProc;

procedure Unhook;
begin
  UnhookWindowsHook(wh_MsgFilter, @FilterFun);
end;


procedure InstallHook(hwindow:hwnd);
begin
  CallHandle:=hWindow;
  SetBit:=False;
  PrevHook := SetWindowsHook(wh_MsgFilter, @FilterFun);
end;

begin
end.