{************************************************}
{                                                }
{   Turbo Pascal for Windows                     }
{   Tips & Techniques Demo Program               }
{   Copyright (c) 1991 by Borland International  }
{                                                }
{************************************************}

program MinMaxRestriction;

uses WinTypes, WinProcs, WObjects;

type
TApp = object(TApplication)
  procedure InitMainWindow; virtual;
end;

PMyWindow = ^TMyWindow;
TMyWindow = Object(TWindow)
  procedure GetMinmaxinfo(var Msg: TMessage); virtual wm_GetMinMaxInfo;
end;

procedure TApp.InitMainWindow;
begin
  MainWindow := New(PMyWindow, Init(nil, 'MinMaxRestriction'));
end;

procedure TMyWindow.GetMinMaxInfo(var Msg:TMessage);
type
  TMyPoints = array[0..4] of TPoint;
var
  MyPoints: ^TMyPoints;

begin
  MyPoints:= Pointer(Msg.lParam);

  MyPoints^[2].x:=100;     { window origin when maximized }
  MyPoints^[2].Y:=100;

  MyPoints^[3].x:=100;     { minimum width and height }
  MyPoints^[3].Y:=200;

  MyPoints^[4].x:=500;     { maximum width and height }
  MyPoints^[4].Y:=400;
end;

var
  App:TApp;

begin
  App.Init('MinMaxDemo');
  App.Run;
  App.Done;
end.
