
                  { Routines developed by Mario A. Guerra
                    MGUERRA@UCRVM2.BITNET for the public domain.

                    Copyright Mario A. Guerra, 1991.
                  }

{ SELECTOR - this unit has these character routines (some similar to C):

              Select     - Asks if some character is in a defined ASCII range
              IsAlpha    - Asks if a char is alpha
              IsAlnum    - Asks if a char is alpha, numeric or space
              IsAscii    - Asks is a char is ASCII (between 00H and 7FH)
              IsControl  - Asks if a char is a control char (00H-1FH and 7FH)
              IsDigit    - Asks if a char is a decimal digit
              IsGraph    - Asks if a char is a graphic (21H-7EH and 80H-FEH)
              IsLower    - Asks if a character is lowercase
              IsPrint    - Asks if a char is printable (20H-FEH)
              IsPunct    - Asks if a char is a punctuation char
              IsBlank    - Asks if a character is tab, return, newline,
                           vertical tab or formfeed (09H-0DH and 20H)
              IsUpper    - Asks if a char is uppercase
              IsDigitH   - Asks if a character is an hex digit
              IsExtend   - Asks if a char is extended (80H-FFH)

  In all the units, the function is true if is in the range specified.

  In function Select, Lo is the lower value and Hi is the higher value-

}

Unit
    Selector;

Interface

Function Select (Ch : Char; Low, Hi : Byte) : Boolean;

Function IsLower     (Ch : Char) : Boolean;
Function IsUpper     (Ch : Char) : Boolean;
Function IsAlpha     (Ch : Char) : Boolean;
Function IsDigit     (Ch : Char) : Boolean;
Function IsAlnum     (Ch : Char) : Boolean;
Function IsAscii     (Ch : Char) : Boolean;
Function IsControl   (Ch : Char) : Boolean;
Function IsGraph     (Ch : Char) : Boolean;
Function IsPrint     (Ch : Char) : Boolean;
Function IsPunct     (Ch : Char) : Boolean;
Function IsBlank     (Ch : Char) : Boolean;
Function IsDigitH    (Ch : Char) : Boolean;
Function IsExtend    (Ch : Char) : Boolean;

Implementation

Function Select (Ch : Char; Low, Hi : Byte) : Boolean;

Begin
  If (Ord (Ch) >= Low) And (Ord (Ch) <= Hi) then
      Select := True
  Else
      Select := False;
End;


Function IsLower     (Ch : Char) : Boolean;

Begin
  If Select (Ch, Ord('a'), Ord('z')) then
      IsLower  := True
  Else
      IsLower  := False;
End;

Function IsUpper     (Ch : Char) : Boolean;

Begin
  If Select (Ch, Ord('A'), Ord('Z')) then
      IsUpper  := True
  Else
      IsUpper  := False;
End;

Function IsAlpha     (Ch : Char) : Boolean;

Begin
  If IsLower (Ch) Or IsUpper (Ch) then
      IsAlpha := True
  Else
      IsAlpha := False;
End;

Function IsDigit     (Ch : Char) : Boolean;

Begin
  If Select (Ch, Ord('0'), Ord('9')) then
      IsDigit  := True
  Else
      IsDigit  := False;
End;

Function IsAlnum     (Ch : Char) : Boolean;

Begin
  If IsAlpha(Ch) Or IsDigit  (Ch) Or (Ch = ' ') then
      IsAlnum := True
  Else
      IsAlnum := False;
End;

Function IsAscii     (Ch : Char) : Boolean;

Begin
  If Select (Ch, 0, 127) then
      IsAscii := True
  Else
      IsAscii := False;
End;

Function IsControl   (Ch : Char) : Boolean;

Begin
  If Select (Ch, 0, 31) Or (Ord (Ch) = 127) then
      IsControl := True
  Else
      IsControl := False;
End;

Function IsGraph     (Ch : Char) : Boolean;

Begin
  If Select (Ch, 33, 126) or Select (Ch, 128, 254) then
      IsGraph:= True
  Else
      IsGraph:= False;
End;

Function IsPrint     (Ch : Char) : Boolean;

Begin
  If IsGraph(Ch) Or (Ch = ' ') then
      IsPrint  := True
  Else
      IsPrint  := False;
End;

Function IsBlank     (Ch : Char) : Boolean;

Begin
  If (Ch = ' ')     Or (Ch = Chr(09)) Or (Ch = Chr(10)) Or
     (Ch = Chr(13)) Or (Ch = Chr(12)) Or (Ch = Chr(05)) then
         IsBlank  := True
  Else
         IsBlank  := False;
End;

Function IsPunct     (Ch : Char) : Boolean;

Begin
  If IsControl (Ch) Or IsBlank  (Ch) then
      IsPunct  := True
  Else
      IsPunct  := False;
End;

Function IsDigitH   (Ch : Char) : Boolean;

Begin
  If IsDigit (Ch) Or Select (Ch, Ord('A'), Ord('F')) then
      IsDigitH := True
  Else
      IsDigitH := False;
End;


Function IsExtend    (Ch : Char) : Boolean;

Begin
  If Select (Ch, 128, 255) then
      IsExtend := True
  Else
      IsExtend := False;
End;

End.
