program twoscrn;
{demonstration of two screen operation}
{(c) 1985 by nathan liskov, waltham mass}
{free to use but not to sell}
var
  n:integer;
  mpos:array [0..31] of array [0..1] of integer;

procedure saveparam(imode:integer);     {save screen state}
var
  n:integer;
begin
  for n:=0 to 29 do
  mpos[n,imode]:=mem[0:1097+n];
  mpos[30,imode]:=wherey;
  mpos[31,imode]:=wherex;
end;

procedure restoreparam(imode:integer);     {restore screen state}
var
  n:integer;
begin
  for n:=0 to 29 do
  mem[0:1097+n]:=mpos[n,imode];
  gotoxy(mpos[31,imode],mpos[30,imode]);
end;

procedure tocolor;     {to color monitor}
begin
  saveparam(0);        {save mono screen state}
  mem[0:1040]:=(mem[0:1040] and 207) or 32;    {to color monitor}
  restoreparam(1);     {restore previous color screen state}
end;

procedure tomono;     {to mono monitor}
begin
  saveparam(1);       {save color screen state}
  mem[0:1040]:=(mem[0:1040] and 207) or 48;      {to mono monitor}
  restoreparam(0);    {restore previous mono screen state}
end;

procedure setupscreens;     {save mono and color screen states}
begin                       {ends up on mono monitor}
 if (mem[0:1040] and 207)=207 then  {if current monitor is mono then...}
 begin
  saveparam(0);      {save mono screen state}
  mem[0:1040]:=(mem[0:1040] and 207) or 32; {to color screen}
 end else
 begin
  saveparam(1)       {save color screen state}
 end;
 textmode(0);
 textbackground(1);
 mem[0:1040]:=(mem[0:1040] and 207) or 48;  {to mono screen}
 textmode;
end;

begin
 setupscreens;
 tocolor;
 graphcolormode;
 graphbackground(1);
 for n:=1 to 20 do
 begin
  tomono;
  writeln('here i am! ',n);
  tocolor;
  draw(0,0,32*n,2*n*n,1);
{  gotoxy(1+n,2*n-1);}
  writeln('no here i am! ',n);
 end;
 tomono;
end.
