Program Calc;

{       CALC.PAS
        Jovo Filipovich
        TO BE CONVERTED TO VAX PASCAL
        CSCI 383-01
}

{ Stack Data Structure Section }

TYPE
    TokType = (EQUALS,EXPRESSION,VALUE,OPERATOR,NOTHING,INVALID);

    StackPtr = ^StackElem;               { Pointer To Stack Element }
    StackElem = RECORD                   { The main Data Structure  }
      Token  : String;                   { The token for this element }
      T_type : TokType;                  { A token is a type }
      Valu   : Real;                     { The value of the token in num }
      Next   : StackPtr;                 { The next is here }
      Prev   : StackPtr;                 { Doubley linked stack }
    END;


Function  InitStack : StackPtr;
  Begin { InitStack }
    InitStack := NIL;
  End;  { InitStack }

Procedure Push(VAR StackHead : StackPtr; Item : StackElem);
  Var
    Temp : StackPtr;

  Begin
    New(Temp);                          { Create new element }
    Temp^ := Item;                      { Copy all the new information }
    Temp^.Next := NIL;                  { And Make sure this is the case }
    Temp^.Prev := StackHead;            { The previous is current stack hd }
    If (StackHead <> NIL)
      then StackHead^.Next := Temp;            { The next up is this and.. }
    StackHead := Temp;                  { the temp is new stackhead }
  End;

Procedure Pop(VAR StackHead : StackPtr; VAR Item : StackElem);

  Var
    Temp : StackPtr;
    Holder : StackElem;

  Function stackempty(sh : StackPtr) : BOOLEAN;
    begin
      stackempty := (sh = NIL);
    end;

  Begin
    If Not stackempty(StackHead)
      Then Begin
             Temp := StackHead^.Prev;       { Go Back One Element }
             Holder := StackHead^;          { Copy this information }
             Dispose(StackHead);            { Get rid of the current thing }
             StackHead := Temp;             { Re-Assign the head }
           End;
    Item := Holder;                         { Garbage if empty }
  End;




Procedure ParseLine(InputLine : String; VAR StackHead : StackPtr);

  Type
    Nea = (DONOTHING,NEGATE);  { What to do to next value }

  Var
    CharT : TokType;
    StrT  : TokType;
    Ws    : String;
    Cp    : INTEGER;
    Len   : INTEGER;
    Rcode : INTEGER;
    Telem : StackElem;
    NextAct : Nea;

  Procedure CharType(Ch : Char; VAR Ct : TokType);
    begin
      Case Ch of
        '+', '-', '*', '/'     : Ct := OPERATOR;
        '='                    : Ct := EQUALS;
        '0','1','2','3','4','5',
        '6','7','8','9','.'    : Ct := VALUE
      Else Ct := NOTHING;
      End;
    end;

  Procedure ClearElem(VAR Elem : StackElem);
    Begin
      With Elem do
        begin
          Token := '';
          T_type := NOTHING;
          Valu := 0.0;
          Next := NIL;
          Prev := NIL;
        end;
    End;



  Begin
    Len := Length(InputLine);
    Cp := 1;
    NextAct := DONOTHING;
    While (Cp <= Len) do
      Begin
        ClearElem(Telem);                { Clear This out }
        Ws := '';
        Strt := NOTHING;
        CharT := NOTHING;
        CharType(InputLine[Cp],Strt);  { Get the starting type }
        Repeat
          Ws := Ws + InputLine[Cp];
          Cp := Cp + 1;
          CharType(InputLine[Cp],CharT);
        Until (CharT <> StrT) OR (Cp > Len);
        { At This point, CP points to next Token or is at END }
        Telem.Token := Ws;      { The token String }
        Telem.T_type := Strt;   { And the Starting Type }
        If (Strt = VALUE)
          Then Begin
                 Val(Ws,Telem.Valu,Rcode);
                 If (NextAct = NEGATE)
                   Then begin
                          Telem.Valu := -Telem.Valu;
                          Telem.Token := '-' + Ws;
                          NextAct := DONOTHING;
                        end;
                 If (Rcode <> 0)
                   then Telem.T_type := INVALID;
               End
          Else If (Strt = OPERATOR)
                 Then Begin
                        NextAct := DONOTHING; { Do Nothin unless }
                        If (Length(Ws) > 1)
                          Then Begin
                                 Case Ws[2] of
                                   '+'  : NextAct := DONOTHING;
                                   '-'  : NextAct := NEGATE;
                                 Else Telem.T_type := INVALID;
                                 End;
                                 Telem.Token := Copy(Ws,1,1);
                               End;
                      End;
        Push(StackHead,Telem);  { Push The Data Object }
      End;
  End;



Procedure PerformCalc(A,O,B : StackElem; VAR Result : REAL; VAR R : INTEGER);
  Begin
    R := 0;
    Case O.Token[1] of
      '+'   : Result := A.Valu + B.Valu;
      '-'   : Result := A.Valu - B.Valu;
      '*'   : Result := A.Valu * B.Valu;
      '/'   : Result := A.Valu / B.Valu;
    Else R := -1;
    End;
  End;




Procedure Syntax(Erm : String; VAR StackHead : StackPtr; Ps : String);
  Var
    Cs : String;
    Te : StackElem;
    Erl : INTEGER;

  Begin
    Cs := '';
    While (StackHead <> NIL) do
      begin
        Pop(StackHead,Te);
        Cs := Te.Token + Cs;          { Compile The Unused String }
      end;
    WriteLn(Cs,Ps,'='); { Write The original String }
    Erl := Length(Cs) + 1;
    WriteLn('^':Erl);
    WriteLn('**** ',Erm,', Syntax Error');
    Halt(1);
  End;



Procedure Compile(VAR StackHead : StackPtr);
  Var
    Elem1 : StackElem;
    Elem2 : StackElem;
    Elem3 : StackElem;
    Result : Real;
    Rcode : INTEGER;
    Fine : BOOLEAN;

  Begin
    Fine := FALSE;
    Pop(StackHead,Elem1);         { The First Item must be }
    If (Elem1.T_type <> EQUALS)
      Then Syntax('Expected "="',StackHead,'');
    While Not Fine do
      Begin
        If (StackHead = NIL)
          Then Syntax('Expression Expected',StackHead,'');
        Pop(StackHead,Elem1);
        If (Elem1.T_type = VALUE)
          Then
            Begin
              Elem1.T_type := EXPRESSION;   { Convert to Expression }
              Push(StackHead,Elem1);        { And Put it back }
            End
          Else
            If (Elem1.T_type <> EXPRESSION)
              Then Syntax('Expression Expected',StackHead,Elem1.Token)
              Else
                Begin
                  If (StackHead = NIL)
                    Then
                      Begin
                        Fine := TRUE;  { We Are Done }
                        Push(StackHead,Elem1);  { Put it back }
                      End
                    Else
                      Begin
                        Pop(StackHead,Elem2);
                        Pop(StackHead,Elem3);
                        If ((Elem2.T_type <> OPERATOR) AND
                            (Elem3.T_type <> VALUE))
                          Then Syntax('Expected <value><op><expression>',StackHead,Elem1.Token)
                          Else
                            Begin
                              PerformCalc(Elem3,Elem2,Elem1,Result,Rcode);
                              Elem1.Token := Elem3.Token +
                                             Elem2.Token +
                                             Elem1.Token;
                              If (Rcode <> 0)
                                Then Syntax('Expected <value><op><expression>',StackHead,Elem1.Token);
                              Elem1.T_type := EXPRESSION;
                              Elem1.Valu := Result;
                              Push(StackHead,Elem1);
                            End;
                      End;
                End;
      End; { While Loop }
    Pop(StackHead,Elem1);
    WriteLn(Elem1.Token,'= ',Elem1.Valu:5:7);
  End;


Procedure Dbg(VAR StackHead : StackPtr);
  Var
    Telem : StackElem;

  Procedure Wtell(Tt : TokType);
    Begin
      Case Tt of
        EQUALS     : Write('Equal Term');
        EXPRESSION : Write('Expression');
        VALUE      : Write('Value Term');
        OPERATOR   : Write('Op        ');
        NOTHING    : Write('UNDEFINED ');
        INVALID    : Write('INVALID VALUE TYPE (NON-CONVERTABLE)');
      END;
    End;





  Begin
    While (StackHead <> NIL) do
      begin
        Pop(StackHead,Telem);        { Get An Element }
        Write('"',Telem.Token,'"     ');
        Write('Type = ');
        Wtell(Telem.T_type);
        WriteLn('  Value = ',Telem.Valu:2:4);
      end;
    WriteLn;
  End;




VAR
  CalcText : String;
  StackHead : StackPtr;

Begin   { The MAIN PROGRAM !!!!! }
  StackHead := InitStack;
  CalcText := '';
  While Not Eof Do
    Begin
      ReadLn(CalcText);
      ParseLine(CalcText,StackHead);
{      Dbg(StackHead); }
      Compile(StackHead);
    End;
End.
