Program Multi_D_Volumes;

{  AUTHOR : Jovo Filipovich
   DATE   : September 2, 1990

   The purpose of this program is to calculate volumes of spheres in
   multiple dimentions.  As we know, the volume of a sphere in 3-space
   is 4/3*pi*radius^2.  This program is made to observe what happens
   in larger dimentions with respect to the sphere's volume.
   Also, we know that...
                                            2    2          2
                  #( [ (X ,X ,X ,...,X ) : X  + X  + ... + X   <= 1] )
         d               1  2  3      d     1    2          d
   V  = 2    *    ----------------------------------------------------
    d                      Total Number of points tested

   Where d is the number of dimensions
}

Uses Crt;

VAR
  Dimensions,
  Indx1, Indx2,
  MaxPoints,
  InsidePointCount : Longint;
  SubT,
  VolumeApprox,
  DivPi,
  HitMiss           : REAL;



Begin
  ClrScr;
  Randomize;
  Write('What dimension sphere do you want to calculate -> ');
  Readln(Dimensions);
  Write('How Many Random Points would you like -> ');
  Readln(MaxPoints);
  Write('Computing ');
  InsidePointCount := 0;
  HitMiss := 0.0;
  VolumeApprox := 0.0;
  DivPi := 0.0;
  For Indx1 := 1 to MaxPoints do
    begin
      SubT := 0.0;
      For Indx2 := 1 to Dimensions do
        SubT := SubT + Sqr(Random);  { Squares and adds }
      If SubT <= 1.0 then Inc(InsidePointCount);
      If ((Indx1 Mod 1000) = 0) Then Write('.');
    End;
  VolumeApprox := (1 shl Dimensions) * (InsidePointCount / MaxPoints);
  WriteLn;
  Writeln('Volume Approximation is ',VolumeApprox:5:11);
  DivPi := VolumeApprox / Pi;
  WriteLn('This is about pi * ',DivPi:5:11);
  HitMiss := MaxPoints / InsidePointCount;
  WriteLn('Hit to miss ratio is ',HitMiss:3:3,' to 1');
  WriteLn;
  WriteLn('Press Enter to end.');
  Readln;
End.
