PROGRAM TaskWindows;

{$R-,S-,I-,D-,F-,V-,B-,N-,L- }
{
  Code-Sharing Demo

  Christian Philipps
  Dsseldorfer Str. 316
  4130 Moers 1

  November 1988
}

USES Crt, CpMulti;

TYPE WinType = RECORD
                 Top,
                 Left,
                 Bottom,
                 Right  : word;
               END;

CONST NoWin  = 8;
      TaskWin : ARRAY[1..8] OF WinType =
                ((Top:2;Left:5;Bottom:9;Right:15),
                 (Top:2;Left:25;Bottom:9;Right:35),
                 (Top:2;Left:45;Bottom:9;Right:55),
                 (Top:2;Left:65;Bottom:9;Right:75),
                 (Top:12;Left:5;Bottom:19;Right:15),
                 (Top:12;Left:25;Bottom:19;Right:35),
                 (Top:12;Left:45;Bottom:19;Right:55),
                 (Top:12;Left:65;Bottom:19;Right:75));

VAR   Sem    : Pointer;
      Screen : Pointer;
      TaskNo : Word;

{---------------------------------------------------------------------------}

PROCEDURE Frame (X1,Y1,X2,Y2:BYTE);

VAR N : BYTE;

BEGIN { Frame }
  SemWait(Screen);
  Window(1,1,80,25);
  GotoXY(X1,Y1);
  Write('');
  FOR N := 1 TO X2-X1-1 DO
    Write('');
  Write('');
  FOR N := 1 TO Y2-Y1-1 DO
  BEGIN
    GotoXY(X1,Y1+N);
    Write('');
    GotoXY(X2,Y1+N);
    Write('');
  END;
  GotoXY(X1,Y2);
  Write('');
  FOR N := 1 TO X2-X1-1 DO
    Write('');
  Write('');
  SemSignal(Screen);
END;  { Frame }

{---------------------------------------------------------------------------}

PROCEDURE SubTask;

VAR  MyNo : Word;
     Pass : Word;

BEGIN {SubTask}
  MyNo := TaskNo;
  Pass := 1;
  SemSignal(Sem);
  WITH TaskWin[MyNo] DO
    Frame(Left-1,Top-1,Right+1,Bottom+1);
  REPEAT
    SemWait(Screen);
    WITH TaskWin[MyNo] DO
    BEGIN
      Window(Left,Top,Right,Bottom);
      GotoXY(2,8);
      Writeln('--',Pass:4,' --');
      Inc(Pass);
    END;
    SemSignal(Screen);
    Sleep(Random(Seconds(1)));
  UNTIL False;
END;  {SubTask}

{---------------------------------------------------------------------------}

BEGIN {Main}
  ClrScr;
  GotoXY(20,23);
  Writeln('Press any key to end program...');
  IF (CreateSem(Sem) <> Sem_OK)    OR
     (CreateSem(Screen) <> Sem_Ok)
     THEN BEGIN
            Writeln('Could not create semaphore!');
            Halt(1);
          END;

  SemClear(Screen);
  FOR TaskNo := 1 TO NoWin DO
  BEGIN
    SemClear(Sem);
    IF CreateTask(@SubTask,Pri_User,500) < 0
       THEN BEGIN
              Writeln(^G'Could not create task no. ',TaskNo);
              Halt(1);
            END;
    SemWait(Sem);
  END;
  SemSignal(Screen);
  REPEAT
    Sleep(Seconds(1));
  UNTIL Keypressed;
  SemWait(Screen);
  Window(1,1,80,25);
  GotoXY(1,23);
END.