{ Charts3.pas      --Sample program illustrating business charts.
                   --Uses dynamic objects
                   --Demonstrates object-oriented programming in
                     Turbo Pascal 5.5.
                   --Written by Zack Urlocker
                     Copyright 1990, The Whitewater Group.
                     All rights reserved.
                   --mzu 06/01/90
}
program Charts3;

uses Charts;

var
   PChart1 : VBarChartPtr;
   PChart2 : HBarChartPtr;

begin { main }
  new(PChart1, Init);
  new(PChart2, Init);

  if (PChart1 = nil) or (PChart2 = nil) then
  begin
     writeln('**Heap error!');
     writeln('**press return.');
     readLn;
     halt(1);
  end;

  PChart1^.SetName('PChart1');
  PChart1^.SetLoc(0,0,300,150);
  PChart1^.Add('Jan', 3);
  PChart1^.Add('Feb', 10);
  PChart1^.Add('Mar', 15);
  PChart1^.Add('Apr', 20);
  PChart1^.Add('May', 12);
  PChart1^.SetColor(1);
  PChart1^.Draw;
  dispose(PChart1, Done);

  with PChart2^ do
  begin
    Init;
    SetName('PChart2');
    SetLoc(302,152,550,350);
    Add('Jan', 4);
    Add('Feb', 12);
    Add('Mar', 20);
    Add('Apr',  4);
    Add('May',  7);
    Draw;
  end;  { with }
  dispose(PChart2, Done);

  readLn;
end.  { main }