{ Sample Turbo Pascal 5.5 program demonstrating use of object libraries.
  This file definest the employee types used.  }

{$D+,L+,S-,R-}

unit EMPOBJ;

interface

type

EmployeePtr = ^employee;

Employee = object

  { instance variables }

  { personal info. }
  EmpNum : integer;
  EmpName : string[30];
  EmpAddr : string[30];
  EmpCity : string[15];
  EmpState : string[2];
  EmpZip : integer;
  EmpPhone : string[8];
  EmpTitle : integer;

  { payroll info. }
  Salary : real;                  {Salary per pay period}
  RegRate : real;                 {Hourly wage rate}
  OtRate : real;                  {Overtime wage rate}
  RegHours : real;                {Regular hours worked this period}
  OtHours : real;                 {Overtime hours worked this period}
  Commission : real;              {Commission earned this period}
  GrossPay : real;                {Gross pay this period}
  NetPay : real;                  {Net pay this period}

  { deduction info. }
  FedTax : real;                  {Federal income tax per period}
  StateTax : real;                {State income tax per period}
  FicaTax : real;                 {Social security per period}

  { historical info. }
  YtdGrossPay : real;
  YtdFedTax : real;
  YtdStateTax : real;
  YtdFicaTax : real;
  YtdNetPay : real;

  {methods}
  constructor init;               {Constructors are never virtual}
  procedure addYtdGrossPay(money : real); virtual;
  procedure addYtdFedTax(money : real); virtual;
  procedure addYtdStateTax(money : real); virtual;
  procedure addYtdFicaTax(money : real); virtual;
  procedure addYtdNetPay(money : real); virtual;
  procedure addYtdTotals; virtual;
  procedure pay; virtual;
  destructor done; virtual;       {destructors should always be virtual}

end;

programmerPtr = ^programmer;

programmer = object(employee)
  procedure pay; virtual
end;

clerkPtr = ^ clerk;

clerk = object(employee)
  procedure pay; virtual;
end;

salesmanPtr = ^salesman;

salesman = object(employee)
  procedure pay; virtual;
end;

implementation

constructor employee.init;
begin
  EmpNum := 0;
  EmpName := '';
  EmpAddr := '';
  EmpCity := '';
  EmpState := '';
  EmpZip := 0;
  EmpPhone := '';
  EmpTitle := 0;
  Salary := 0.0;
  RegRate := 0.0;
  RegHours := 0.0;
  OtRate := 0.0;
  OtHours := 0.0;
  Commission := 0.0;
  GrossPay := 0.0;
  NetPay := 0.0;
  FedTax := 0.0;
  StateTax := 0.0;
  FicaTax := 0.0;
  YtdGrossPay := 0.0;
  YtdFedTax := 0.0;
  YtdStateTax := 0.0;
  YtdFicaTax := 0.0;
  YtdNetPay := 0.0;
end;

procedure employee.addYtdGrossPay(money : real);
begin
  YtdGrossPay := YtdGrossPay + money;
end;

procedure employee.addYtdFedTax(money : real);
begin
  YtdFedTax := YtdFedTax + money;
end;

procedure employee.addYtdStateTax(money : real);
begin
  YtdStateTax := YtdStateTax + money;
end;

procedure employee.addYtdFicaTax(money : real);
begin
  YtdFicaTax := YtdFicaTax + money;
end;

procedure employee.addYtdNetPay(money : real);
begin
  YtdNetPay := YtdNetPay + money;
end;

procedure employee.addYtdTotals;
begin
  employee.addYtdGrossPay(GrossPay);
  employee.addYtdFedTax(FedTax);
  employee.addYtdStateTax(StateTax);
  employee.addYtdFicaTax(FicaTax);
  employee.addYtdNetPay(NetPay);
end;

procedure employee.pay;
begin
  { Fall-through method - does nothing };
end;

destructor employee.done;
begin
{a destructor can be empty and still deallocate memory}
end;

procedure programmer.pay;
begin
  NetPay := (Salary - FedTax - StateTax - FicaTax);
  GrossPay := Salary;
  employee.addYtdTotals;
end;

procedure clerk.pay;
var
  holdGrossPay : real;
begin
  holdGrossPay := (RegRate * RegHours) + (OtRate * OtHours);
  NetPay := (holdGrossPay - FedTax - StateTax - FicaTax);
  GrossPay := holdGrossPay;
  employee.addYtdTotals;
end;

procedure salesman.pay;
var
  holdGrossPay : real;
begin
  holdGrossPay := Salary + Commission;
  NetPay := (holdGrossPay - FedTax - StateTax - FicaTax);
  GrossPay := holdGrossPay;
  employee.addYtdTotals;
end;

end.
