{ Sample Turbo Pascal 5.5 program demonstrating use of object libraries.
  Uses Object Professional objects for windows, menus.  }

{$D+,L+,S-,R-}

unit PAYREG;                      {Display payroll register}

interface

uses FileObj, EmpObj;

procedure RunPayroll(EmpMastFile : MasterFile);

implementation

uses OpCrt, OpFrame, OpWindow;

var
{ EmpMastFile : MasterFile; }
  EP : EmployeePtr;               {Pointer to an employee record}
  W1 : StackWindow;

procedure Pause;
var
  Finished : boolean;
begin
  Finished := False;
  repeat
    case ReadKeyWord of
      $4800 : W1.ScrollVert(-1);       {Up Arrow}
      $5000 : W1.ScrollVert(1);        {Down Arrow}
    else
      Finished := True;                {any other key}
    end;
  until Finished;
end;

procedure ShowWindow;
begin
{ ClrScr; }
  W1.InitCustom(10, 5, 70, 20, DefaultColorSet,
    wClear+wSaveContents+wBordered+wAltFrame);
  W1.EnableExplosions(20);
  W1.Draw;
end;

procedure PaintWindow;
var
  Finished : boolean;
begin
  Finished := False;
  WriteLn;
  WriteLn(EP^.EmpNum, '   ', EP^.EmpName);
  WriteLn('gross pay..............', EP^.GrossPay:8:2);
  WriteLn('net pay................', EP^.NetPay:8:2);

end;

procedure CloseWindow;
begin
  W1.Erase;
  W1.Done;
end;

procedure RunPayroll(EmpMastFile : MasterFile);
begin
  ShowWindow;
  EP := EmpMastFile.ReadFirst;
  while EP <> nil do
  begin
    EP^.Pay;
    PaintWindow;
    EP := EmpMastFile.ReadNext;
  end;
  Pause;
  CloseWindow;
end;

end.

