program OwlTab;
{
  Illustrates how to have multi-line edit controls allow
  the tab character to switch between controls rather
  than inserting a tab character into the text.
}
uses
  WinTypes, WinProcs,
  OWindows, ODialogs;

type
  PNewEdit = ^TNewEdit;
  TNewEdit = object(TEdit)
    procedure WMKeyDown(var Msg: TMessage);
      virtual wm_First + wm_KeyDown;
  end;

  PMainWin = ^TMainWin;
  TMainWin = object(TWindow)
    Edit1,
    Edit2: PEdit;
    constructor Init(AParent: PWindowsObject; ATitle: PChar);
  end;

  PMainApp = ^TMainApp;
  TMainApp = object(TApplication)
    procedure InitMainWindow; virtual;
  end;

procedure TNewEdit.WMKeyDown(var Msg: TMessage);
begin
  if Msg.WParam = vk_Tab then
    begin
      if (GetKeyState(vk_Shift) and $80) <> 0 then
        Previous^.Focus
      else
        Next^.Focus;
    end;
  inherited WMKeyDown(Msg);
end;

constructor TMainWin.Init(AParent: PWindowsObject; ATitle: PChar);
begin
  inherited Init(AParent, ATitle);
  Edit1 := New(PEdit, Init(@Self, 100, 'Edit1', 5, 5, 100, 26, 25, False));
  Edit2 := New(PNewEdit, Init(@Self, 101, 'Edit2', 5, 35, 100, 75, 25, True));
  EnableKBHandler;
end;

procedure TMainApp.InitMainWindow;
begin
  MainWindow := New(PMainWin, Init(nil, 'OWLTab'));
end;

var
  MainApp: TMainApp;

begin
  MainApp.Init('OWLTAB');
  MainApp.Run;
  MainApp.Done;
end.
