{$R-,S-,I-,V-,B-}

program PAs2Tpu;

{$I OPDEFINE.INC}

uses
  Dos,
  OpDos,
  OpInline,
  OpString,
  OpRoot,
  OpCrt,
  OpColor,
  {$IFDEF UseMouse}
  OpMouse,
  {$ENDIF}
  OpAbsFld,
  OpCmd,
  OpField,
  OpFrame,
  OpWindow,
  OpSelect,
  OpEntry,
  PULLTPU;

  {$IFDEF UseMouse}
const
  MouseChar  : Char = #04;
  {$ENDIF}

{......$I GTDX.ICD}


{Color set used by entry screen}
const
  EsColors : ColorSet = (
    TextColor       : YellowOnBlue;       TextMono        : WhiteOnBlack;
    CtrlColor       : YellowOnBlue;       CtrlMono        : WhiteOnBlack;
    FrameColor      : CyanOnBlue;         FrameMono       : LtGrayOnBlack;
    HeaderColor     : WhiteOnCyan;        HeaderMono      : BlackOnLtGray;
    ShadowColor     : DkGrayOnBlack;      ShadowMono      : WhiteOnBlack;
    HighlightColor  : WhiteOnRed;         HighlightMono   : BlackOnLtGray;
    PromptColor     : LtGrayOnBlue;       PromptMono      : LtGrayOnBlack;
    SelPromptColor  : LtGrayOnBlue;       SelPromptMono   : LtGrayOnBlack;
    ProPromptColor  : LtGrayOnBlue;       ProPromptMono   : LtGrayOnBlack;
    FieldColor      : YellowOnBlue;       FieldMono       : LtGrayOnBlack;
    SelFieldColor   : BlueOnCyan;         SelFieldMono    : WhiteOnBlack;
    ProFieldColor   : LtGrayOnBlue;       ProFieldMono    : LtGrayOnBlack;
    ScrollBarColor  : CyanOnBlue;         ScrollBarMono   : LtGrayOnBlack;
    SliderColor     : CyanOnBlue;         SliderMono      : WhiteOnBlack;
    HotSpotColor    : BlackOnCyan;        HotSpotMono     : BlackOnLtGray;
    BlockColor      : YellowOnCyan;       BlockMono       : WhiteOnBlack;
    MarkerColor     : WhiteOnCyan;        MarkerMono      : BlackOnLtGray;
    DelimColor      : YellowOnBlue;       DelimMono       : WhiteOnBlack;
    SelDelimColor   : BlueOnCyan;         SelDelimMono    : WhiteOnBlack;
    ProDelimColor   : YellowOnBlue;       ProDelimMono    : WhiteOnBlack;
    SelItemColor    : YellowOnCyan;       SelItemMono     : BlackOnLtGray;
    ProItemColor    : LtGrayOnBlue;       ProItemMono     : LtGrayOnBlack;
    HighItemColor   : WhiteOnBlue;        HighItemMono    : WhiteOnBlack;
    AltItemColor    : WhiteOnBlue;        AltItemMono     : WhiteOnBlack;
    AltSelItemColor : WhiteOnCyan;        AltSelItemMono  : BlackOnLtGray;
    FlexAHelpColor  : WhiteOnBlue;        FlexAHelpMono   : WhiteOnBlack;
    FlexBHelpColor  : WhiteOnBlue;        FlexBHelpMono   : WhiteOnBlack;
    FlexCHelpColor  : LtCyanOnBlue;       FlexCHelpMono   : BlackOnLtGray;
    UnselXrefColor  : YellowOnBlue;       UnselXrefMono   : LtBlueOnBlack;
    SelXrefColor    : WhiteOnCyan;        SelXrefMono     : BlackOnLtGray;
    MouseColor      : WhiteOnRed;         MouseMono       : BlackOnLtGray
  );

var
  ES          : EntryScreen;
  UR          : UserRecord;
  Status      : Word;
  line,
  count       : LongInt;
  S1, S2, S3  : string;
  inny, outty : text;
  RW          : RawWindow;
  RWOpts      : LongInt;
  ToContinue  : boolean;
  RightP,
  LeftP       : byte;

{$F+}

Procedure DefaultOutput;
begin
     UR.OutPut := JustName(UR.Input);
     UR.OutPut := UR.OutPut + '.2TP';
     ES.DrawField(idOutput);
end;

procedure PreEdit(ESP : EntryScreenPtr);
  {-Called just before a field is edited}
begin
  with ESP^ do
    case GetCurrentID of
      idInput                : ;
      idOutput               : ;
    end;
end;

procedure PostEdit(ESP : EntryScreenPtr);
  {-Called just after a field has been edited}
begin
  with ESP^ do
    case GetCurrentID of
      idInput                :if UR.Input <> '' then DefaultOutput;
      idOutput               : ;
    end;
end;

procedure ErrorHandler(UnitCode : Byte; var ErrCode : Word; Msg : string);
  {-Report errors}
begin
  RingBell;
end;

procedure DisplayHelp(UnitCode : Byte; IdPtr : Pointer; HelpIndex : Word);
  {-Display context sensitive help}
begin
end;
{$F-}


Procedure GetNames;
var
     ImDone : boolean;

begin

  {initialize user record}
  InitUserRecord(UR);

  {initialize entry screen}
  Status := InitEntryScreen(ES, UR, EsColors);
  if Status <> 0 then begin
    WriteLn('Error initializing entry screen: ', Status);
    Halt(1);
  end;

  {set up user hooks}
  ES.SetPreEditProc(PreEdit);
  ES.SetPostEditProc(PostEdit);
  ES.SetErrorProc(ErrorHandler);
  EntryCommands.SetHelpProc(DisplayHelp);
  EntryCommands.AddCommand(ccUser0, 1, $4400, 0);
  ImDone := False;
  with ES do
          repeat
               Process;
               case GetLastCommand of
                    ccError, ccDone,
                        ccQuit : ImDone := true;

                    ccUser0    : RingBell;

               end;          { case }

          until ImDone;
          if ES.GetLastCommand = ccQuit then ToContinue := false;

  ES.Erase;
  ES.Done;
end;


Function Strip(L,C:char;Str:string):string;
{L is left,center,right,all,ends}
var I :  byte;
begin
    Case Upcase(L) of
    'L' : begin       {Left}
              While (Str[1] = C) and (length(Str) > 0) do
                    Delete(Str,1,1);
          end;
    'R' : begin       {Right}
              While (Str[length(Str)] = C) and (length(Str) > 0) do
                    Delete(Str,length(Str),1);
          end;
    'B' : begin       {Both left and right}
              While (Str[1] = C) and (length(Str) > 0) do
                    Delete(Str,1,1);
              While (Str[length(Str)] = C) and (length(Str) > 0)  do
                    Delete(Str,length(Str),1);
          end;
    'A' : begin       {All}
              I := 1;
              Repeat
                   If (Str[I] = C) and (length(Str) > 0) then
                      Delete(Str,I,1)
                   else
                      I := succ(I);
              Until (I > length(Str)) or (Str = '');
          end;
    end;
    Strip := Str;
end;  {Func Strip}



Function First(N:byte;Str:string):string;
var Temp : string;
begin
    If N > length(Str) then
       Temp := Str
    else
       Temp := copy(Str,1,N);
    First := Temp;
end;  {Func First}

Procedure Finish(why : byte);
 begin
          Clrscr;
          case why of
              1 : Writeln('Program terminated by user...');
              2 : Writeln('Input file ', UR.Input, ' not available...Program terminated.');
              3 : Writeln('No procedures or functions were found in ', UR.Input);
              4 : Writeln('All done ....  File to merge into TPU source code is ', UR.Output);
              5 : Writeln('Output file ', UR.Output,' already exists...Program terminated.');
              6 : Writeln('Input or output file names were not specified by user...Program terminated.');

          end;  { case }

         Halt;

end;



begin   { Main Program }
     ToContinue := true;
     ClearWindow(1, 1, ScreenWidth, 25, chr(206), ColorMono($2F, $70));
     ClearWindow(1, 1, ScreenWidth, 1, chr(32), ColorMono($4F, $07));
     FastCenter('PAS - TO- TPU', 1, $4F);
     GetNames;
     if not ToContinue then Finish(1);
     if (UR.Input = '') or (UR.OutPut = '') then Finish(6);

     if not ExistFile(TrimTrail(UR.Input)) then Finish(2);
     UR.Output := TrimTrail(UR.Output);
     if ExistFile(UR.Output) then Finish(5);

     RWOpts := wBordered + wClear;
     if not RW.InitCustom(20, 8, 60, 13, ESColors,
                          RWOpts) then exit;
     RW.EnableExplosions(7);

     RW.Draw;
     HiddenCursor;
     RW.wFastCenter('Processing data....Now on line',
                    2, ColorMono($6B, $70));

     Assign(Inny , UR.Input);
     ReSet(Inny);
     Assign(Outty, UR.Output);
     ReWrite(Outty);
     Line := 0;
     Count := 0;
     while not EOF(Inny) do
     begin
          readln(Inny, S1);
          inc(line);
          RW.wFastText(Long2Str(line) + '    ', 5, 18);
          S1 := Strip('L', ' ', S1);
          S2 := first(8, S1);
          S2 := StUpCase(S2);
          LeftP := Pos('(',S1);
          RightP := Pos(')', S1);
          if (S2 = 'PROCEDUR') or (S2 = 'FUNCTION') then
          begin
               inc(count);
               S3 := '  { ' + Long2Str(line) + ' }';
               Write(Outty, S1);
               Writeln(Outty, S3);
               if LeftP > 0 then if RightP = 0 then
               repeat
                    readln(Inny, S1);
                    LeftP := Pos('(',S1);
                    RightP := Pos(')', S1);
                    inc(line);
                    writeln(Outty, S1);
               until RightP > 0;
          end;
     end;
     Close(Inny);
     Close(Outty);
     RW.Erase;
     RW.Done;
     NormalCursor;
     if Count = 0 then
     begin
          Assign(Outty, UR.Output);
          Erase(Outty);
          Finish(3);
     end
         else Finish(4);
end.


