{$R-,S-,I-,V-,B-}

unit PULLTPU;

interface

{$I OPDEFINE.INC}

uses
  Dos,
  OpInline,
  OpString,
  OpRoot,
  OpCrt,
  OpColor,
  {$IFDEF UseMouse}
  OpMouse,
  {$ENDIF}
  OpAbsFld,
  OpCmd,
  OpField,
  OpFrame,
  OpWindow,
  OpSelect,
  OpEntry;

{Entry field constants}
const
  idInput                = 0;
  idOutput               = idInput + 1;

{Help index constants}
const
  hiInput                = 1;
  hiOutput               = hiInput + 1;

type
  UserRecord =
    record
      Input                : string[12];
      Output               : string[12];
    end;

function InitEntryScreen(var ES : EntryScreen;
                         var UR : UserRecord;
                         var EsColors : ColorSet) : Word;
  {-Initialize entry screen generated by MAKESCRN}

procedure InitUserRecord(var UR : UserRecord);
  {-Initialize user record}

  {===========================================================}

implementation

procedure InitUserRecord(var UR : UserRecord);
begin
  FillChar(UR, SizeOf(UR), 0);
end;

function InitEntryScreen(var ES : EntryScreen;
                         var UR : UserRecord;
                         var EsColors : ColorSet) : Word;
const
  Frame1 = 'ĳ';
  WinOptions = wBordered+wClear+wUserContents;
begin
  with ES do begin
    if not InitCustom(5, 5, 75, 14, EsColors, WinOptions) then begin
      InitEntryScreen := InitStatus;
      Exit;
    end;

    wFrame.SetFrameType(Frame1);
    EnableExplosions(6);
    wFrame.AddShadow(shBR, shSeeThru);
    wFrame.AddHeader(' Ctrl-Enter when finished ', heBR);
    wFrame.AddHeader(' F10 gets directory ', heBL);
    SetWrapMode(WrapAtEdges);

    AddTextField(
      'Pull procedure/function lines for a TPU header', 9, 9);

  {idInput:}
    AddStringField(
      'Input File Name: ', 3, 9,
      '!!!!!!!!!!!!', 3, 28, 12,
      hiInput, UR.Input);

  {idOutput:}
    AddStringField(
      'Output File Name: ', 6, 9,
      '!!!!!!!!!!!!', 6, 28, 12,
      hiOutput, UR.Output);

    InitEntryScreen := RawError;
  end;
end;

end.
