                    CHAPTER 10 - Standard Input/Output



            During  the  course of this tutorial we have been  using 
        the WRITE and WRITELN procedures to display data,  and it is 
        now time to discuss them fully.  Actually there is little to 
        be said that has not already been said,  but in order to get 
        all  of the data in one place they will be  redefined  here.  
        As  mentioned  earlier,  WRITE and WRITELN are not  actually 
        reserved words but are procedure calls.   They are therefore 
        merely  identifiers that could be changed but  there  should 
        never  be  a  reason to do so.   Lets get on  to  our  first 
        example program WRITELNX which has lots of output.

                          MANY OUTPUT STATEMENTS

            Pascal  has two output statements that are only slightly 
        different  in  the way they  work.   The  WRITELN  statement 
        outputs  all of the data specified within it,  then  returns 
        the  cursor  to the beginning of the next line.   The  WRITE 
        statement outputs all of the data specified within it,  then 
        leaves  the  cursor at the next character  where  additional 
        data  can be output.   The WRITE statement can therefore  be 
        used  to  output a line in bits and pieces  if  desired  for 
        programming convenience.  The first example program for this 
        chapter,  WRITELNX,  has  many  output statements  for  your 
        observation.   All  outputs are repeated so you can  observe 
        where the present field ends and the next starts.

            Observe the INTEGER output statements.  The first simply 
        directs the system to output "index" twice, and it does with 
        no  separating blanks.   The second statement says to output 
        "index" twice also,  but it instructs the system to put each 
        output  in  a field 15 characters wide with the  data  right 
        justified  in the field.   This makes the output  look  much 
        better.   This  illustrates  that you have complete  control 
        over the appearance of your output data.

            The  REAL output statements are similar to  the  integer 
        except  that when the data is put into a field 15 characters 
        wide,  it is still displayed in scientific format.  Adding a 
        second field descriptor tells the system how many digits you 
        want displayed after the decimal point.   The next few lines 
        illustrate the second field and its use.

            The BOOLEAN,  CHAR,  and STRING examples should be  self 
        explanatory.   Notice  that when the string is output,  even 
        though  the  string  has been defined as  a  maximum  of  10 
        characters,  it  has  been  assigned  a  string  of  only  8 
        characters, so only 8 characters are output.





                                  Page 46









                    CHAPTER 10 - Standard Input/Output


                   NOW FOR SOME INPUT FROM THE KEYBOARD

            The  example  file READINT will illustrate reading  some 
        integer data from the keyboard.  A message is output with an 
        interesting fact that should be pointed out.  Anyplace where 
        Pascal  uses  a string variable or  constant,  it  uses  the 
        apostrophe  for  a  delimiter.    Thus,  anyplace  where  an 
        apostrophe is used in a string, it will end the string.  Two 
        apostrophes   in  a  row  will  be  construed  as  a  single 
        apostrophe  within  the string and will  not  terminate  the 
        string.  The term 'READ' within the string will therefore be 
        displayed as shown earlier in this sentence.

            The  variable "index" is used to loop five times through 
        a sequence of statements with one READ statement in it.  The 
        three integer variables are read in and stored with the  one 
        statement.   If  less than three are input in the statement, 
        only as many as are read in will be defined,  the rest  will 
        be unchanged.  Following completion of the first loop, there 
        is a second loop that will be executed 5 times with only one 
        minor  change,  the READ statement is replaced by the READLN 
        statement.   At this point it would be best run this program 
        trying several variations with input data.

            When  you run READINT,  it will request three  integers.  
        Reply with three small integers of your choice with as  many 
        blank  spaces  between  each as you desire,  followed  by  a 
        carriage  return.   The system will echo your three  numbers 
        back  out,  and request three more.   Respond with only  one 
        number  this time,  different from each of the first  three.  
        You  will  get  your new number followed  by  your  previous 
        second and third number indicating that you did not re-enter 
        the last two integer variables.  Enter all three again, this 
        time  including a negative number and observe the echo  once 
        again.

            Continue  entering numbers until the system outputs  the 
        message  indicating that it will now be using  the  'READLN' 
        for reading data.  At this point enter the same numbers that 
        you  did in the previous section and notice the  difference, 
        which is only very slight.   Each time you hit the enter key 
        to  cause  the  computer to process the data you  have  just 
        given it,  it will echo the carriage return to the  display, 
        and  the  "Thank you" message will be on a new  line.   When 
        entering data from the keyboard, the only difference in READ 
        and  READLN is whether or not the carriage return is  echoed 
        to the display following the data read operation.

            It should not be a surprise to you that after you  enter 
        the  data,  the data is stored within the program and can be 



                                  Page 47









                    CHAPTER 10 - Standard Input/Output


        used anywhere that integer data is legal for use.  Thus, you 
        could read in an integer, and use the integer to control the 
        number of times through a loop, as a CASE selector, etc.

                        TIME TO CRASH THE COMPUTER

            Crashing the computer will not hurt a thing.   Rerun the 
        above  program and instead of entering integer  data,  enter 
        some real data with decimal points,  or even some  character 
        data.   The  computer  should display some kind  of  message 
        indicating that you have caused an I/O error (Input/Output), 
        and  most  implementations  of Pascal  will  probably  abort 
        operation  (that simply means to stop the program and return 
        control  to the operating system).   No harm has been  done, 
        simply start it again to enter more numbers or errors.

                           READING REAL NUMBERS

            The example program READREAL will illustrate how to read 
        real numbers into the computer.  It will read an integer and 
        three  real  numbers  each time through  the  loop.   It  is 
        perfectly fine to give the system a number without a decimal 
        point for a real number.   The computer will simply read  it 
        as  a decimal number with zeros after the decimal point  and 
        consider it as a real number internally. As you found out in 
        the last example program,  however, it is not permissible to 
        include  a  decimal  point in the data if  the  computer  is 
        looking  for  an integer variable.   Include some  character 
        data for a real number and crash the system in this  program 
        too.

                          READING CHARACTER DATA

            The  next example program,  READCHAR,  will read in  one 
        character each time through the loop and display it for you.  
        Try  entering more than one character and you will see  that 
        the  extra  characters will simply be ignored.   It  is  not 
        possible  to  crash this program because any  character  you 
        enter will be valid.

            The  next example,  READARRY,  will read in a string  of 
        characters  and display them for you.   Up to 10  characters 
        will be read, and if less than 10 are read, the rest will be 
        blank filled.   Try entering 10 characters,  then 4,  to see 
        that  the  residual  6  characters are  blanked  out  before 
        storing  and  printing.   Since the array is  fixed  at  ten 
        characters, ten characters are always printed out, including 
        trailing blanks.





                                  Page 48









                    CHAPTER 10 - Standard Input/Output


            Finally READSTRG will also read up to 10 characters, but 
        since  a string is a dynamic length variable,  it will  only 
        print  out  the characters you input each time,  up  to  the 
        maximum  of 10 as defined in the VAR declaration.   It  will 
        display  trailing blanks if you type them in because  blanks 
        are valid characters.

                         BULLET PROOF PROGRAMMING

            It  can be frustrating to be running a program and  have 
        it  declare  an  I/O error and  terminate  operation  simply 
        because  you  have  entered  an  incorrect  character.   The 
        integer and real data inputs defined earlier in this chapter 
        are   fine   for  quick  little  programs  to  do   specific 
        calculations,  but  if you are writing a large  applications 
        program  it is better to use another technique.   Since  the 
        character  and string inputs cannot abort operation  of  the 
        program,  it  is best to use them to input the variable data 
        and  check  the  data  internally  under  your  own  program 
        control.  An error message can then be given to the operator 
        and  another opportunity granted to input the correct  data.  
        All  well  written  large  application  programs  use   this 
        technique.

                 HOW DO I PRINT SOMETHING ON THE PRINTER

            With all of the Pascal knowledge you now have, it is the 
        simplest thing in the world to get data to the printer.  The 
        example  file  PRINTOUT will show you graphically how to  do 
        it.   Every WRITE or WRITELN statement is required to have a 
        device identifier prior to the first output field.  If there 
        is  none,  it  is automatically defaulted  to  the  standard 
        output device, the display monitor.  The example program has 
        a  few  outputs  to the monitor with the  device  identifier 
        included,  namely "output".   This is only done to show  you 
        the  general form of the WRITE statements.   There are  also 
        many  statements in this program with the display identifier 
        "lst",  which is the standard name for the "list" device  or 
        the printer.  Compile and run this program with your printer 
        turned on for some printer output.

            Just  to supply you with a bit more  information,  every 
        READ  and READLN statement is also required to have a device 
        identifier  prior  to the first input  field.   As  you  may 
        suspect,  it  is  also  defaulted  to  "input"  if  none  is 
        specified, and the standard input device is the keyboard.







                                  Page 49









                    CHAPTER 10 - Standard Input/Output


                           PROGRAMMING EXERCISE

        1.  Write a program containing a loop to read in a character 
            string  up to 60 characters long,  then print the string 
            on your printer. When you run the program, you will have 
            the  simplest word processing program in the  world.  Be 
            sure  to  include a test to end the loop,  such as  when 
            "END" is typed in.













































                                  Page 50

