                 CHAPTER 3 - The simple Pascal data types


            Pascal  has only 5 basic data types which are predefined 
        and  can be used anywhere you desire provided you  use  them 
        properly.   The  five  types  and a very  brief  description 
        follows;

            Integer   The integers from -32768 to 32767
            Byte      The integers from 0 to 255
            Real      Floating point numbers from 1E-38 to 1E+38
            Boolean   Can only have the value TRUE or FALSE
            Char      Any character in the ASCII character set

            Please note that the Byte type of data is not a part  of 
        the  standard  Pascal  definition  but  is  included  as  an 
        extension to the TURBO Pascal compiler.

            A  complete definition of these can be found on pages 41 
        and  42 of the TURBO Pascal reference manual (version  3.0).  
        It  would  be good to read those two pages now  for  a  good 
        definition  prior to our learning how to define and use them 
        in  a  program.   The  integers are by far  the  easiest  to 
        understand so we will start with a simple program that  uses 
        some  integers in a very simple way.   Load INTVAR into your 
        TURBO system and lets take a look at it.

                            OUR FIRST VARIABLES

            Immediately  following the PROGRAM statement is  another 
        reserved word, VAR.  VAR is used to define a variable before 
        it  can  be  used anywhere in  the  program.   There  is  an 
        unbroken  rule  of Pascal that states "Nothing can  be  used 
        until  it is defined."  The compiler will complain at you if 
        you try to use a variable without properly defining it.   It 
        seems  a  bit bothersome to have to  define  every  variable 
        prior  to  its  use but this rule will catch  many  spelling 
        errors of variables before they cause trouble.   Some  other 
        languages  will  simply define a new variable with  the  new 
        name and go merrily on its way producing some well formatted 
        garbage for you.

            Notice  that  there is only one VAR,  but it is used  to 
        define three different variables,  "count",  "x",  and  "y".  
        Once  a  VAR is recognized,  the compiler will  continue  to 
        recognize  variable  definitions  line after line  until  it 
        finds another reserved word.  It would be permissible to put 
        a VAR on the second line also but it is not  necessary.   It 
        would  also be permissible to put all three variables on one 
        line  but programming style will dictate where you  put  the 
        three  variables.   Following the colon on each line is  the 
        word  INTEGER  which  is  a  standard  identifier  which  is 
        different from a reserved word.  An identifier is predefined 
        like  a reserved word but you can redefine it thereby losing 


                                  Page 11









                 CHAPTER 3 - The simple Pascal data types


        its  original purpose and meaning.   For now and for a  long 
        time, don't do that. Page 38 contains a list of identifiers.

                           OUR FIRST ARITHMETIC

            Now that we have three variables defined as integer,  we 
        are  free to use them in a program in any way we  desire  as 
        long as we use them properly.   If we tried to assign a REAL 
        value  to  "x",  the compiler will generate an  error,  once 
        again preventing a garbage output.  Observe the start of the 
        main  body  of  the program.   There  are  three  statements 
        assigning values to "x",  "y", and "count".  A fine point of 
        mathematics  would state that "count" is only equal  to  the 
        value of x+y until either was modified,  therefore the equal 
        sign used in so many other languages is not used here.   The 
        sign  :=  is used,  and can be read as "is replaced  by  the 
        value   of"   when  reading  a  listing  to   preserve   the 
        mathematical purity of Pascal. Another quicker way is to use 
        the word "gets".   Thus x := x + 1 would be read "x gets the 
        value of x plus 1".  We will see later that the simple equal 
        sign is reserved for use in a different manner.

            The first three statements give "x" the value of 12, "y" 
        the  value of 13,  and "count" the value of 12+13 or 25.  We 
        need  to get those values out of the computer,  so  we  need 
        another extension to the WRITELN statement.   The first part 
        of the data within the parentheses should be familiar to you 
        now,  but  the second part is new.   Multiple outputs can be 
        handled within one WRITELN if the fields are separated by  a 
        comma.   To  output a variable,  simply write the variable's 
        name in the output field.  The number following the variable 
        in  each case is the number of output columns to be used  by 
        the output data.  This number is optional and can be omitted 
        allowing the system to use as many columns as it needs.  For 
        purposes  of  illustration  they  have  all  been   assigned 
        different  numbers  of  columns.   At this  point,  you  can 
        compile and run INTVAR to see its output.  

            To  illustrate  the various ways to  output  data,  load 
        INTVAR2   and  observe  that  even  though  the  output   is 
        identical,  it  is output in a completely different  manner.  
        Observe  especially  that  a WRITELN all  by  itself  simply 
        returns to the beginning of a new line on the video monitor.  
        Compile and run this program also to observe its output.

                      NOW LET'S USE LOTS OF VARIABLES

            Load  ALLVAR to observe a short program using all  5  of 
        the  basic  data types.   The variables are simply  assigned 
        values and the values are printed.   A complete and detailed 
        description of the options available in the WRITE  statement 


                                  Page 12









                 CHAPTER 3 - The simple Pascal data types


        is  given in the TURBO reference manual on pages 111 through 
        113.   It would be to your advantage to read this section at 
        this time since very little explanation will be given  about 
        WRITE  statements from this point on.   We will discuss  the 
        method  by which we can write to disk files or other  output 
        devices when the time comes.

            Back  to  the basic types.   Pascal does lots  of  cross 
        checking  for obvious errors.   It is illegal to assign  the 
        value of any variable with a value that is of the wrong type 
        or outside the allowable range of that variable.   There are 
        routines  to convert from one system to another when that is 
        necessary.  Suppose, for example, that you wished to use the 
        value of an integer in a calculation of real numbers.   That 
        is  possible  by first converting the integer  into  a  real 
        number  of the same value and using the new real variable in 
        the  desired calculations.   The new real variable  must  of 
        course  be defined in a VAR as a real before it can be used.  
        Details of how to do the conversion will be given later.

            Since we have some variables defined,  it would be  nice 
        to  use  the  properties  of computers for  which  they  are 
        famous, namely some mathematics.  Two programs are available 
        for your observation to illustrate the various kinds of math 
        available,  REALMATH using real variables, and INTMATH using 
        integer variables.   You can edit, compile, and run these on 
        your  own  with  no  comment from  me  except  the  comments 
        embedded into the source files.  Chapter 6 on pages 51 to 54 
        of your TURBO reference manual completely defines the simple 
        mathematics available.

            Byte is used just like integers but with a much  smaller 
        value.   Only  one byte of computer memory is used for  each 
        variable defined as byte but 2 are used for integer types.

                             BOOLEAN VARIABLES

            Lets  take a look at the boolean variable which is  only 
        allowed  to  take on two different values,  TRUE  or  FALSE.  
        This  variable  is  used  for loop  controls,  end  of  file 
        indicators  or  any other TRUE or FALSE  conditions  in  the 
        program.   Variables  can be compared to determine a boolean 
        value.  An  illustration is the best way to learn about  the 
        boolean variable so load BOOLMATH, observe, compile, and run 
        it.

            Char is a very useful variable,  but not all by  itself.  
        It is very powerful when used in an array or some other user 
        defined  data  structure which is beyond the scope  of  this 
        chapter.   A  very simple program,  CHARDEMO is included  to 
        give  you  an  idea  of how a char  variable  can  be  used.  


                                  Page 13









                 CHAPTER 3 - The simple Pascal data types


        Observe  and run CHARDEMO for a very brief idea of what  the 
        char variable is all about.

            Examine  the sample program CONVERT for several examples 
        of converting data from one simple variable to another.  The 
        program is self explanatory.


                           PROGRAMMING EXERCISE

        1.  Write a program containing several variable  definitions 
            and do some math on them, printing out the results.









































                                  Page 14

