                CHAPTER 7 - Strings and string procedures


                              PASCAL STRINGS

             According to the Pascal definition,  a string is simply 
        an  array  of  2 of more characters of  type  CHAR,  and  is 
        contained  in  an array defined in a VAR  declaration  as  a 
        fixed length.  Look at the example program STRARRAY.  Notice 
        that  the  strings are defined in the TYPE declaration  even 
        though  they could have been defined in the VAR part of  the 
        declaration. This is to begin getting you used to seeing the 
        TYPE declaration.  The strings defined here are nothing more 
        than arrays with CHAR type variables.

            The interesting part is the program.   Notice that  when 
        the  variable  "first_name" is assigned a value,  the  value 
        assigned  to  it must contain exactly 10 characters  or  the 
        compiler  will generate an error.   Try editing out a  blank 
        and you will get an invalid type error.   Pascal is neat  in 
        allowing  you  to write out the values in the  string  array 
        without specifically writing each character in a loop as can 
        be  seen in the "WRITELN" statement.   To combine the  data, 
        called  concatenation,   requires  the  use  of  the  rather 
        extensive  looping and subscripting seen in the last part of 
        the  program.   It  would  be even messier  if  we  were  to 
        consider  variable length fields which is nearly always  the 
        case in a real program.

            Two  things should be noticed in this  program.   First, 
        notice  the fact that the string operations are truly  array 
        operations  and  will  follow  all  of  the  characteristics 
        discussed in the last chapter.  Secondly, it is very obvious 
        that  Pascal is rather weak when it comes to its handling of 
        text type data.   Keep in mind that Pascal will handle  text 
        data,  even  though it may be difficult.   This concerns the 
        standard description of Pascal,  we will see next that TURBO 
        Pascal really shines here.

                       THE TURBO PASCAL STRING TYPE

            Look  at the example program STRINGS.   You will  see  a 
        much  neater program that actually does more.   TURBO Pascal 
        has,  as an extension to standard Pascal, the STRING type of 
        variable.  It is used as shown, and the number in the square 
        brackets in the VAR declaration is the maximum length of the 
        string.   In actual use in the program,  the variable can be 
        used  as any length from zero characters up to  the  maximum 
        given  in the declaration.   The variable "first_name",  for 
        example, actually has 11 locations stored for its data.  The 
        current length is stored in "first_name[0]" and the data  is 
        stored  in  "first_name[1]" through  "first_name[10]".   All 
        data is stored as byte variables,  including the  size,  and 



                                 Page 33









                CHAPTER 7 - Strings and string procedures


        the  length  is  therefore  limited  to  a  maximum  of  255 
        characters.

            Now  look  at  the  program  itself.   Even  though  the 
        variable  "first_name" is defined as 10 characters long,  it 
        is perfectly legal to assign it a 4 character constant, with 
        "first_name[0]"  automatically set to four and the last  six 
        characters undefined and unneeded.   When the program is run 
        the  three variables are printed out all  squeezed  together 
        indicating  that the variables are indeed shorter than their 
        full  size  as defined in the VAR  declaration.   Using  the 
        STRING  type  is  even easier when  you  desire  to  combine 
        several  fields into one as can be seen in the assignment to 
        "full_name".   Notice that there are even two blanks, in the 
        form  of  constant fields,  inserted between  the  component 
        parts of the full name.   When it is written out,  the  full 
        name is formatted neatly and is easy to read.

                    WHAT IS IN A STRING TYPE VARIABLE?

            The next example program named WHATSTRG,  is intended to 
        show you exactly what is in a string variable.  This program 
        is  identical  to  the last program except  for  some  added 
        statements  at the end.   Notice the assignment to  "total".  
        The  function "length" is available in TURBO Pascal to  find 
        out  what is the current length of any STRING type variable, 
        it  returns a byte type variable with the value of  the  [0] 
        position  of  the  variable.   We print out  the  number  of 
        characters  in the string at this point,  and then print out 
        each  character on a line by itself to illustrate  that  the 
        TURBO  Pascal  STRING  type  variable  is  simply  an  array 
        variable.

            The TURBO Pascal reference manual has a full description 
        of  several more procedures and functions available in TURBO 
        Pascal   only.    Refer  to  your  manual  for  a   complete 
        description given in chapter 9,  beginning on page 67.   The 
        use  of these should be clear after you grasp  the  material 
        covered here.

                           PROGRAMMING EXERCISES

        1.  Write a program in which you store your  first,  middle, 
            and last names as variables,  then display them one to a 
            line. Concatenate the names with blanks between them and 
            display your full name as a single variable.







                                 Page 34

