                           CHAPTER 9 - Records


            We  come  to  the grandaddy of all  data  structures  in 
        Pascal,  the  RECORD.   A record is composed of a number  of 
        variables  any of which can be of any predefined data  type, 
        including  other records.   Rather than spend time trying to 
        define  a  record  in detail,  lets go right  to  the  first 
        example program, SMALLREC.  This is a program using nonsense 
        data that will illustrate the use of a record.

                           A VERY SIMPLE RECORD

            There is only one entry in the TYPE declaration part  of 
        the program,  namely the record identified by "description".  
        The record is composed of three fields, the "year", "model", 
        and  "engine" variables.   Notice that the three fields  are 
        each of a different type,  indicating that the record can be 
        of  mixed types.   You have a complete example of the way  a 
        record  is  defined  before  you.   It is  composed  of  the 
        identifier ("description"),  the reserved word  RECORD,  the 
        list of elements,  and followed by END;.  This is one of the 
        places   in   Pascal  where  an  END  is  used   without   a 
        corresponding BEGIN.   Notice that this only defines a TYPE, 
        it  does not define any variables.   That is done in the VAR 
        declaration where the variable "cars" is defined to have  10 
        complete  records of the type "description".   The  variable 
        "cars[1]" has three components, year, model, and engine, and 
        any  or  all of these components can be used to  store  data 
        pertaining to "cars[1]".

            In  order  to assign values to the various  fields,  the 
        variable name is followed by the sub-field with a separating 
        period.   Keep  in mind that "cars[1]" is a complete  record 
        containing three variables,  and to assign or use one of the 
        variables,  you  must  designate  which  sub-field  you  are 
        interested in.   See the program where the three fields  are 
        assigned  meaningless  data for  illustration.   The  "year" 
        field  is  assigned  an  integer  number  varying  with  the 
        subscript,   all   "model"  fields  are  assigned  the  name 
        "Duesenburg",  and  all "engine" variables are assigned  the 
        value "V8".   In order to further illustrate that there  are 
        actually  30  variables in use here,  a few are  changed  at 
        random  in  the next few statements,  being very careful  to 
        maintain   the  required  types  as  defined  in  the   TYPE 
        declaration part of the program.  Finally, all ten composite 
        variables,  consisting  of 30 actual variables in a  logical 
        grouping  are  printed  out using  the  same  "var.subfield" 
        notation described above.

            If the preceding description of a record is not clear in 
        your mind,  review it very carefully.  It's a very important 
        concept in Pascal,  and you won't have a hope of a chance of 
        understanding the next example until this one is clear.


                                  Page 39









                           CHAPTER 9 - Records



                              A SUPER RECORD

            Examine  the  Pascal  example file  BIGREC  for  a  very 
        interesting  record.   First  we  have a  constant  defined.  
        Ignore  it for the moment,  we will come back to  it  later.  
        Within  the TYPE declaration we have three records  defined, 
        and  upon close examination,  you will notice that the first 
        two  records are included as part of the definition  of  the 
        third record.   The record identified as "person",  actually 
        contains   9   variable  definitions,   three   within   the 
        "full_name" record,  three of its own,  and three within the 
        "date"  record.   This  is a TYPE declaration and  does  not 
        actually define any variables,  that is done in the VAR part 
        of the program.

            The  VAR  part  of the program  defines  some  variables 
        beginning  with the array of "friend" containing 50 (because 
        of  the  constant definition in the CONST part)  records  of 
        "person".   Since  "person" defines 9 fields,  we  have  now 
        defined  9  times 50 = 450 separate and distinct  variables, 
        each  with its own defined type.   Remember that  Pascal  is 
        picky about assigning data by the correct type.  Each of the 
        450  separate variables has its own type associated with it, 
        and the compiler will generate an error if you try to assign 
        any  of  those  variables the wrong  type  of  data.   Since 
        "person" is a TYPE definition, it can be used to define more 
        than  one variable,  and in fact it is used again to  define 
        three more records,  "self",  "mother", and "father".  These 
        three records are each composed of 9 variables,  so we  have 
        27  more  variables  which  we  can  manipulate  within  the 
        program.   Finally we have the variable "index" defined as a 
        simple byte type variable.

                    HOW TO MANIPULATE ALL OF THAT DATA

            In  the program we begin by assigning data to all of the 
        fields of "self".   Examining the first three statements  of 
        the main program,  we see the construction we learned in the 
        last  example program being used,  namely the period between 
        descriptor fields.   The main record is named "self", and we 
        are  interested  in the first part of it namely  the  "name" 
        part  of the person record.   Since the "name" part  of  the 
        person  record  is itself composed of three parts,  we  must 
        designate  which  part  of it we  are  interested  in.   The 
        complete description "self.name.first_name" is the  complete 
        description  of  the first name of "self" and is  the  first 
        assignment   statement   which  is  assigned  the  name   of 
        "Charley".   The next two fields are handled in the same way 
        and are self explanatory.



                                  Page 40









                           CHAPTER 9 - Records


                        WHAT IS THE WITH STATEMENT?

            Continuing on to the fourth field, the "city", there are 
        only  two  levels  required because "city"  is  not  another 
        record definition.  The fourth field is therefore completely 
        defined   by  "self.city".    Notice  the  "WITH  self   DO" 
        statement.   This  is a shorthand notation used with  record 
        definitions to simplify coding.   From the BEGIN at the next 
        statement  to the matching END;  about 10 statements  later, 
        any  variables within the "self" record are used  as  though 
        they had a "self." in front of them.   It greatly simplifies 
        coding  to be able to omit the leading identifier within the 
        WITH section of code.   You will see that  "city",  "state", 
        and  "zipcode"  are easily assigned values  without  further 
        reference to the "self" variable.   When we get to the "day" 
        part  of the birthday,  we are back to three levels and  the 
        complete  definition is "self.birthday.day" but once  again, 
        the  "self." part is taken care of automatically because  we 
        are still within the "WITH self DO" area.

            To  illustrate  the WITH statement further,  another  is 
        introduced namely "WITH birthday DO", and an area is defined 
        by  the  BEGIN  END pair.   Within this  area  both  leading 
        identifiers  are handled automatically to  simplify  coding, 
        and  "month" is equivalent to writing  "self.birthday.month" 
        if both WITH statements were removed.   You may be wondering 
        how   many   levels  of  nesting  are  allowed   in   record 
        definitions.   There  doesn't appear to be a limit according 
        to the Pascal definition, but we do get a hint at how far it 
        is possible to go.  In TURBO Pascal, you are allowed to have 
        WITH  statements  nested to nine levels,  and  it  would  be 
        worthless  to nest WITH statements deeper than the level  of 
        records.   Any  program  requiring more levels than nine  is 
        probably  far beyond the scope of your programming  ability, 
        and  mine,  for a long time.   Pascal implementations  other 
        than  TURBO  Pascal probably have their own  WITH  statement 
        nesting limitation. Check your reference manual.

            After assigning a value to the year,  the entire  record 
        of "self" is defined, all nine variables.

                        SUPER-ASSIGNMENT STATEMENTS

            The   next   statement,   "mother  :=  self;"  is   very 
        interesting.   Since both of these are records, both are the 
        same type of record, and both therefore contain 9 variables, 
        Pascal  is smart enough to recognize that,  and  assign  all 
        nine   values  contained  in  "self"  to  the  corresponding 
        variables of "mother".   So after one statement, "mother" is 
        completely  defined.   The next statement assigns  the  same 
        values  to the nine respective fields of "father",  and  the 


                                  Page 41









                           CHAPTER 9 - Records


        next  two  lines assign all 50 "friend" variables  the  same 
        data.   We  have therefore generated 450 + 27 = 477 separate 
        pieces  of data so far in this program.   We could print  it 
        all out,  but since it is nonsense data, it would only waste 
        time and paper.  The next three lines write out three sample 
        pieces of the data for your inspection.

                         WHAT GOOD IS ALL OF THIS

            It should be obvious to you that what this program does, 
        even  though  the  data  is  nonsense,  appears  to  be  the 
        beginning of a database management program,  which indeed it 
        is.  It is a crude beginning, and has a long way to go to be 
        useful, but you should see a seed for a useful program.

            Now to go back to the CONST as promised.   The number of 
        friends was defined as 50 and used for the size of the array 
        and in the assignment loop near the end of the program.  You 
        can  now edit this number and see how big this database  can 
        become on your computer.  If you are using TURBO Pascal, you 
        will  be limited to slightly more than 1000 because  of  the 
        64K  limitation of an executable program,  and the fact that 
        all  of this data is stored within that 64K  boundary.   See 
        how  big you can make the number of friends before  you  get 
        the  memory  overflow  message.   Keep the  number  in  mind 
        because  when we get to the chapter on Pointers and  Dynamic 
        Allocation,  you  will  see a marked increase  in  allowable 
        size, especially if you have a large amount of RAM installed 
        in your computer.

                             A VARIANT RECORD

            If  any part of this chapter is still unclear,  it would 
        be good for you to go back and review it at this time.   The 
        next  example  will  really  tax  your  mind  to  completely 
        understand  it,  especially  if the prior  material  is  not 
        clear.

            Examine  the  Pascal program VARREC for an example of  a 
        program with a variant record definition.   In this example, 
        we first define a scalar type,  namely "kind_of_vehicle" for 
        use  within  the record.   Then we have  a  record  defining 
        "vehicle",  intended  to  define several different types  of 
        vehicles,  each with different kinds of data.   It would  be 
        possible  to define all variables for all types of vehicles, 
        but  it  would  be a waste of storage space  to  define  the 
        number  of  tires for a boat,  or the  number  of  propeller 
        blades  used on a car or truck.   The variant record lets us 
        define  the data precisely for each vehicle without  wasting 
        data storage space.



                                  Page 42









                           CHAPTER 9 - Records


                           WHAT IS A TAG-FIELD?

            In the record definition we have the usual RECORD header 
        followed  by three variables defined in the same  manner  as 
        the records in the last two example programs.   Then we come 
        to the CASE statement.  Following this statement, the record 
        is  different  for  each of the four types  defined  in  the 
        associated  scalar definition.   The variable "what_kind" is 
        called  the tag-field and must be defined as a  scalar  type 
        prior  to  the  record definition.   The tag-field  is  what 
        selects the variant used,  when the program uses one of  the 
        variables with this record type.   The tag-field is followed 
        by  a colon and its type definition,  then the reserved word 
        OF.   A list of the variants is then given, with each of the 
        variants  having  the  variables  for  its  particular  case 
        defined.   The  list of variables for one variant is  called 
        the field list.

            A few rules are in order at this point.  The variants do 
        not have to have the same number of variables in each  field 
        list,  and in fact,  one or more of the variants may have no 
        variables  at all in its variant part.   If a variant has no 
        variables,  it  must still be defined with a pair  of  empty 
        parentheses followed by a semi-colon.   All variables in the 
        entire  variant  part  must have unique  names.   The  three 
        variables, "wheels", "tires", and "tyres", all mean the same 
        thing  to  the  user,  but they must be  different  for  the 
        compiler.   You may use the same identifiers again in  other 
        records  and  for  simple  variables anywhere  else  in  the 
        program.   The  Pascal compiler can tell which variable  you 
        mean by its context.  Using the same variable name should be 
        discouraged  as  bad  programming practice  because  it  may 
        confuse  you  or another person trying  to  understand  your 
        program at a later date.  The final rule is that the variant 
        part of the record must be the last part of it, and in fact, 
        the  last  part  of any or all variants can  itself  have  a 
        variant part to it.  That is getting pretty advanced for our 
        level of use of Pascal at this time however.

                         USING THE VARIANT RECORD

            We  properly define four variables with the record  type 
        and go on to examine the program itself.

            We  begin  by  defining  one of our  variables  of  type 
        "vehicle",  namely  the variable named  "ford".   The  seven 
        lines  assigning  values to "ford" are similar to the  prior 
        examples  with  the exception of the fourth  line.   In  the 
        fourth  line  the  tag-field which  selects  the  particular 
        variant used is set equal to the value "truck",  which is  a 
        scalar  definition,  not  a variable.   This means that  the 


                                  Page 43









                           CHAPTER 9 - Records


        variables  named  "motor",   "tires",   and  "payload"   are 
        available for use with the record "ford",  but the variables 
        named "wheels", "engine", "tyres", etc. are not available in 
        the record named "ford".

            Next,  lets  define the record "sunfish" as a boat,  and 
        define all of its variables.  All of sunfish's variables are 
        defined but in a rather random order to illustrate that they 
        need not be defined in a particular order.

            To  go even further in randomly assigning the  variables 
        to a record,  we redefine "ford" as having an "engine" which 
        it  can only have if it is a car.   This is one of the  fine 
        points  of  the Pascal record.   If you assign  any  of  the 
        variant  variables,  the record is changed to that  variant, 
        but  it  is  the programmers responsibility  to  assign  the 
        correct  tag-field  to  the  record,   not  Pascal's.   Good 
        programming practice would be to assign the tag-field before 
        assigning  any of the variant variables.   The remainder  of 
        the  "ford" variables are assigned to complete that  record, 
        the non-variant part remaining from the last assignment.

            The  variable  "mac"  is now set equal to  the  variable 
        "sunfish".   All  variables within the record are copied  to 
        "mac" including the tag-field, making "mac" a boat.

                  NOW TO SEE WHAT WE HAVE IN THE RECORDS

            We  have  assigned "ford" to be a  car,  and  two  boats 
        exist,  namely  "sunfish"  and "mac".   Since "schwinn"  was 
        never defined,  it has no data in it,  and is at this  point 
        useless.  The "ford" tag-field has been defined as a car, so 
        it should be true in the IF statement, and the first message 
        should  print.   The "sunfish" is not a bicycle,  so it will 
        not  print.   The  "mac" has been defined as a boat  in  the 
        single assignment statement, so it will print a message with 
        an  indication  that  all  of the data  in  the  record  was 
        transferred to its variables.

            Even  though  we  can make  assignment  statements  with 
        records,  they cannot be used in any mathematical operations 
        such as addition,  or multiplication.   They are simply used 
        for data storage.   It is true however,  that the individual 
        elements  in  a  record  can be  used  in  any  mathematical 
        statements legal for their respective types.

            One other point should be mentioned.   The tag-field can 
        be completely eliminated resulting in a "free union" variant 
        record.   This  is  possible  because  Pascal,  as  you  may 
        remember from above,  will automatically assign the  variant 
        required when you assign data to one of the variables within 


                                  Page 44









                           CHAPTER 9 - Records


        a variant.  This is the reason that all variables within any 
        of  the  variants must have unique names.   The  free  union 
        record  should be avoided in your early programming  efforts 
        because  you cannot test a record to see what variant it has 
        been assigned to.  It is definitely an advanced technique in 
        Pascal.

                           PROGRAMMING EXERCISE

        1.  Write  a simple program with a record to store the names      
            of five of your friends and display the names.










































                                  Page 45

