(*************************************************************)
(*                                                           *)
(*          DOOR.PAS           April 95                      *)
(*                                                           *)
(*   EXAMPLE CODE: Gain control w/o resetting UART.          *)
(*                                                           *)
(*   (1) Start your communications program such as PROCOMM   *)
(*   (2) Select "DOS gateway" to get the DOS prompt.         *)
(*   (3) Start this program. You will gain control of the    *)
(*       COM port without resetting the UART or dropping the *)
(*       modem carrier.                                      *)
(*   (4) When done, exit this program, then type EXIT to     *)
(*       return to MSDOS.                                    *)
(*                                                           *)
(*   For more information, see documentation.                *)
(*                                                           *)
(*************************************************************)


program door;
uses crt, PCL4P;

var
   BaudCode : Integer;
   RetCode  : Integer;
   Byte : Char;
   i    : Integer;
   Port : Integer;
   ResetFlag : Boolean;
   BufPtr    : Pointer;
   BufSeg    : Integer;

procedure SayError( Code : Integer );
var
   RetCode : Integer;
begin
   if Code < 0 then RetCode := SioError( Code )
   else if (Code and (FramingError or ParityError or OverrunError)) <> 0 then
      begin (* Port Error *)
         if (Code and FramingError) <> 0 then writeln('Framing Error');
         if (Code and ParityError)  <> 0 then writeln('Parity Error');
         if (Code and OverrunError) <> 0 then writeln('Overrun Error')
      end
end;

procedure MyHalt( Code : Integer );
var
   RetCode : Integer;
begin
   if Code < 0 then SayError( Code );
   if ResetFlag then RetCode := SioDone(Port);
   writeln('*** HALTING ***');
   Halt;
end;

begin   (* main program *)
   (* fetch PORT # from command line *)
   if ParamCount <> 1 then
      begin
         writeln('USAGE: "DOOR <port> "');
         halt;
      end;
   Val( ParamStr(1),Port, RetCode );
   if RetCode <> 0 then
      begin
         writeln('Port must be 1 to 16');
         Halt;
      end;
   (* COM1 = 0, COM2 = 1, etc. *)
   Port := Port - 1;
   if (Port<COM1) or (Port>COM16) then
      begin
         writeln('Port must be 1 to 16');
         Halt
      end;
   (* setup 1K receive buffer *)
   GetMem(BufPtr,1024+16);
   BufSeg := Seg(BufPtr^) + ((Ofs(BufPtr^)+15) SHR 4);
   RetCode := SioRxBuf(Port, BufSeg, Size1024);
   if RetCode < 0 then MyHalt( RetCode );
   (* reset port *)
   RetCode := SioReset(Port,NORESET);
   (* if error then try one more time *)
   if RetCode <> 0 then RetCode := SioReset(Port,NORESET);
   (* Was port reset ? *)
   if RetCode <> 0 then
     begin
        writeln('Cannot reset COM',Port+1);
        MyHalt( RetCode );
     end;
   (* Port successfully reset *)
   writeln;
   writeln('COM',1+Port,' @ 9600 Baud');

   (* begin terminal loop *)
   writeln('Enter terminal loop ( Type ^Z to exit )');
   while TRUE do
      begin
         (* did user press Ctrl-BREAK ? *)
         if SioBrkKey then
            begin
               writeln('User typed Ctl-BREAK');
               RetCode := SioDone(Port);
               Halt;
            end;
         (* anything incoming over serial port ? *)
         RetCode := SioGetc(Port,0);
         if RetCode < -1 then MyHalt( RetCode );
         if RetCode > -1 then Write( chr(RetCode) );
         (* has user pressed keyboard ? *)
         if KeyPressed then
            begin
               (* read keyboard *)
               Byte := ReadKey;
               (* quit if user types ^Z *)
               if Byte = chr($1a) then
                  begin
                     writeln('User typed ^Z');
                     RetCode := SioDone(Port);
                     Halt;
                  end;
               (* send out over serial line *)
               RetCode := SioPutc(Port, Byte );
               if RetCode < 0 then MyHalt( RetCode );
            end
      end
end.

