{$R-,S-}
program pcxshow;

uses
  DrawPics;

  procedure grab_a_key;
    { Key result ends up in AX register              }
    { Could be defined as function grab_a_key : Word }
  inline($CD/$28/                 { INT 28 }
         $B4/$01/                 { MOV AH, 01 }
         $CD/$16/                 { INT 16 }
         $74/$F8/                 { JZ -08 }
         $B4/$00/                 { MOV AH, 00 }
         $CD/$16);                { INT 16 }

  function ExistFile(FName : string) : Boolean;
    {-Return true if file is found}
  var
    F              : file;
  begin
    ExistFile := False;
    {check for empty string}
    if Length(FName) > 0 then begin
      {$I-}
      Assign(F, FName);
      Reset(F, 1);
      {$I+}
      if IoResult = 0 then begin
        ExistFile := True;
        Close(F);
      end;
    end;
  end;

  {.PA}
var
  OrigMode       : Word;
  Pics           : Byte;
  FileName       : string;

  procedure ErrorMsg(Msg : string);
  begin
    DrawMode(OrigMode);
    WriteLn(Msg);
  end;

begin
  OrigMode := LastDrawMode;
  if ParamCount = 0 then
    WriteLn('Format:  pcxshow filename; e.g. pcxshow sample.pcx')
  else
    for Pics := 1 to ParamCount do begin
      FileName := ParamStr(Pics);

      if ExistFile(FileName) then
        case DrawPic(FileName) of
          NoError : ;
          IOError : ErrorMsg('IO Error occurred while reading '+FileName);
          BadFormat : ErrorMsg('I can''t identify '+FileName+' as graphical.');
          PaletteMissing : ErrorMsg('Palette File for '+FileName+' not found.');
        end
      else ErrorMsg('File '+FileName+' not found.');

      grab_a_key;
    end;

  DrawMode(OrigMode);
end.
