{************************************************}
{                                                }
{   Turbo Pascal for Windows                     }
{   Bitmaps unit                                 }
{   Copyright (c) 1991 by Borland International  }
{                                                }
{************************************************}

unit BitMaps;

{$S-}

interface

uses WinTypes, WinProcs;

function LoadBitMapFile(FileName: PChar): HBitMap;

implementation

procedure AHIncr; far; external 'KERNEL' index 114;

function LoadBitMapFile(FileName: PChar): HBitMap;
label
  Exit1, Exit2, Exit3;
type
  PtrRec = record Lo, Hi: Word end;
var
  F: Integer;
  N: Word;
  H: THandle;
  DC: HDC;
  Size, L: Longint;
  P: PBitMapInfo;
  Header: TBitMapFileHeader;
begin
  LoadBitMapFile := 0;
  F := _LOpen(FileName, of_Read);
  if F = -1 then goto Exit1;
  if (_LRead(F, @Header, SizeOf(Header)) <> SizeOf(Header)) or
    (Header.bfType <> $4D42) then goto Exit2;
  Size := Header.bfSize - SizeOf(TBitMapFileHeader);
  H := GlobalAlloc(gmem_Moveable, Size);
  if H = 0 then goto Exit2;
  P := GlobalLock(H);
  L := 0;
  while L < Size do
  begin
    N := Size - L;
    if N > $8000 then N := $8000;
    if _LRead(F, Ptr(PtrRec(P).Hi + PtrRec(L).Hi * Ofs(AHIncr),
      PtrRec(L).Lo), N) <> N then goto Exit3;
    Inc(L, N);
  end;
  if P^.bmiHeader.biSize <> SizeOf(TBitMapInfoHeader) then goto Exit3;
  N := P^.bmiHeader.biBitCount;
  if N = 24 then N := 0 else N := (1 shl N) * SizeOf(TRGBQuad);
  DC := GetDC(0);
  LoadBitMapFile := CreateDIBitMap(DC, P^.bmiHeader,
    cbm_Init, Ptr(PtrRec(P).Hi, SizeOf(TBitMapInfoHeader) + N),
    P^, dib_RGB_Colors);
  ReleaseDC(0, DC);
  Exit3:
  GlobalUnlock(H);
  GlobalFree(H);
  Exit2:
  _LClose(F);
  Exit1:
end;

end.
