{************************************************}
{                                                }
{   Turbo Pascal for Windows                     }
{   Graphical Hello Windows application          }
{   Copyright (c) 1991 by Borland International  }
{                                                }
{************************************************}

program HelloWin;

uses WinProcs, WinTypes, WObjects, Strings, BitMaps;

const

  GlobeFileName = 'world%d.bmp';
  GlobeCount = 32;

  HelloCount = 10;
  HelloText: array[0..HelloCount - 1] of PChar = (
    'Hello', 'Bonjour', 'Wilkommen', 'Konnichiwa', 'G''day!',
    'Bongiorno', 'Goddag', 'Aloha!', 'Hej', 'Hola!');

type

  PGlobeWindow = ^TGlobeWindow;
  TGlobeWindow = object(TWindow)
    Font: HFont;
    Globes: array[0..GlobeCount - 1] of HBitmap;
    CurGlobe, CurText, TextCount: Integer;
    Text: array[0..1] of PChar;
    constructor Init;
    destructor Done; virtual;
    procedure GetWindowClass(var WndClass: TWndClass); virtual;
    procedure SetupWindow; virtual;
    procedure Paint(DC: HDC; var PS: TPaintStruct); virtual;
    procedure WMTimer(var Msg: TMessage); virtual wm_First + wm_Timer;
  end;

  TGlobeApp = object(TApplication)
    procedure InitMainWindow; virtual;
  end;

constructor TGlobeWindow.Init;
var
  I: Integer;
  Palette: Word;
  W, H: Longint;
  Name: array[0..79] of Char;
begin
  TWindow.Init(nil, 'Hello, Windows');
  Attr.W := 300;
  Attr.H := 300;
  Font := CreateFont(36, 0, 0, 0, fw_Normal, 0, 0, 0, ansi_CharSet,
    out_Default_Precis, clip_Default_Precis, default_Quality,
    variable_Pitch or ff_Roman, 'Tms Rmn');
  SetCursor(LoadCursor(0, idc_Wait));
  for I := 0 to GlobeCount - 1 do
  begin
    WVSPrintF(Name, GlobeFileName, I);
    Globes[GlobeCount - I - 1] := LoadBitMapFile(Name);
  end;
  SetCursor(LoadCursor(0, idc_Arrow));
  CurGlobe := 0;
  CurText := 0;
  TextCount := 0;
  Text[0] := HelloText[0];
  Text[1] := HelloText[1];
end;

destructor TGlobeWindow.Done;
var
  I: Integer;
begin
  for I := 0 to GlobeCount - 1 do DeleteObject(Globes[I]);
  DeleteObject(Font);
  TWindow.Done;
end;

procedure TGlobeWindow.GetWindowClass(var WndClass: TWndClass);
begin
  TWindow.GetWindowClass(WndClass);
  WndClass.hbrBackground := CreateSolidBrush($000000);
end;

procedure TGlobeWindow.SetupWindow;
begin
  TWindow.SetupWindow;
  SetTimer(HWindow, 0, 100, nil);
end;

procedure TGlobeWindow.Paint(DC: HDC; var PS: TPaintStruct);
var
  MemDC: HDC;
  R, T: TRect;
  BitMap: TBitMap;
begin
  GetClientRect(HWindow, R);
  SelectObject(DC, Font);
  SetTextColor(DC, $FFFFFF);
  SetBkColor(DC, $000000);
  SetTextAlign(DC, ta_Center or ta_Top);
  T.left := R.left; T.right := R.right;
  T.top := 10; T.bottom := 46;
  ExtTextOut(DC, R.right div 2, T.top, eto_Opaque, @T,
    Text[0], StrLen(Text[0]), nil);
  T.top := R.bottom - 46; T.bottom := R.bottom - 10;
  ExtTextOut(DC, R.right div 2, T.top, eto_Opaque, @T,
    Text[1], StrLen(Text[1]), nil);
  MemDC := CreateCompatibleDC(DC);
  SelectObject(MemDC, Globes[CurGlobe]);
  GetObject(Globes[CurGlobe], SizeOf(BitMap), @BitMap);
  BitBlt(DC, (R.right - BitMap.bmWidth) div 2,
    (R.bottom - BitMap.bmHeight) div 2, BitMap.bmWidth,
    BitMap.bmHeight, MemDC, 0, 0, SrcCopy);
  DeleteDC(MemDC);
end;

procedure TGlobeWindow.WMTimer(var Msg: TMessage);
var
  P: PChar;
begin
  Inc(CurGlobe);
  if CurGlobe = GlobeCount then CurGlobe := 0;
  Inc(TextCount);
  if TextCount = 10 then
  begin
    TextCount := 0;
    repeat
      P := HelloText[Random(HelloCount)];
    until (P <> Text[0]) and (P <> Text[1]);
    Text[CurText] := P;
    CurText := 1 - CurText;
  end;
  InvalidateRect(HWindow, nil, False);
end;

procedure TGlobeApp.InitMainWindow;
begin
  MainWindow := New(PGlobeWindow, Init);
end;

var
  GlobeApp: TGlobeApp;

begin
  GlobeApp.Init('HelloWin');
  GlobeApp.Run;
  GlobeApp.Done;
end.
