;Faster string search routine to substitute the POS()
;function (for characters only) in Turbo Pascal 4 or 5.
;
;Declare as follows:
;	{$F+}
;	{$L POSCH.OBJ}
;	FUNCTION posCH(Ch : CHAR; Str : STRING) : BYTE; EXTERNAL;
;Call as follows:
;	location := posCH(Ch, Str);
;
;Courtesy of Toad Hall

;Total stack (caller's plus work stack)
cstk	STRUC
bpsave	dw	0			;save BP here
retaddr	dd	0			;points to return address
straddr	dd	0			;points to string address
chr	db	0			;actual character
cstk	ENDS

PARAMSIZE	EQU SIZE chr + SIZE straddr	;size of parameter list

PUBLIC	PosCH				;function name declaration

CODE	SEGMENT PARA PUBLIC 'CODE'
	ASSUME	CS:CODE

;Entry point to PosCH function

PosCH	proc	FAR
	push	bp
	mov	bp,sp

	mov	dx,DS			;save caller's DS
	cld

;Get and save string text length and address
	lds	si,[bp.straddr]
	lodsb				;get string length
	or	al,al			;if string text is null
	jz	NoMatch			; then exit

	mov	bx,si			;save address ofs
	xor	ah,ah			;clear msb
	mov	cx,ax			;CX = string length
	mov	al,[bp.chr]		;snarf char

	mov	di,DS			;DS has string's seg
	mov	ES,di			;into ES for the scas
	mov	di,si			;string offset

	repne	scasb			;search
	jnz	NoMatch			;not found, exit

Match1:
	mov	ax,di			;just past char found
;	sub	ax,2			;adjust DI psn

	sub	ax,bx			;- start of strtxt
;	add	ax,2			; in strtxt where pattern is found
	jmp	short EndSearch		;exit function

NoMatch:
	xor	ax,ax			;no match, return a 0

EndSearch:
	mov	DS,dx			;recover

	mov	sp,bp			;recover last stack psn
	pop	bp			;recover BP
	ret	PARAMSIZE		;return with AX the posCH value

PosCH	ENDP

CODE	ENDS
	END
