(*----------------------------------------------------------------------*)
(* Program: BlackJack for PowerDOOR by Russell Frey                     *)
(*                                                                      *)
(* Date: August 15, 1991                                                *)
(*                                                                      *)
(* A demonstration of what you can do with PowerDOOR.  It should        *)
(* give you a basic idea of the structure.                              *)
(*----------------------------------------------------------------------*)


program blackjack;
uses windos,winprocs,strings,powrwin,powrdoor;

var
 to_gamble: integer;
 taken_time:integer;
 num_ace:   integer;

procedure get_gamble;
var
 temps: string;
 minsleft:integer;

begin
 minsleft:= callinfo.minutes_useable-taken_time;
 writeln_com(SENDYELLOW+'You have '+SENDMAGENTA+int_to_asc(minsleft)+
             SENDYELLOW+' minutes left.');
 write_com(SENDCYAN+'How many minutes would you like to bet (9 mins max, 0 to quit)? ');
 ask_user(temps,1);
 to_gamble := asc_to_int(temps);
 if to_gamble > minsleft then to_gamble := 0;
 dec(callinfo.upload_credit,to_gamble);
 inc(taken_time,to_gamble);
 writelncom;
end;

function get_card: integer;

var
 tempi: integer;

begin
 randomize;
 tempi := random(13) + 2;
 case tempi of
  2..10: write_com(int_to_asc(tempi));
  11: begin
       tempi := 10;
       write_com('J');
      end;
  12: begin
       write_com('Q');
       tempi := 10;
      end;
  13: begin
       tempi := 10;
       write_com('K');
      end;
  14: begin
       inc(num_ace);
       write_com('A');
       tempi := 11;
      end;
 end;
 get_card := tempi;
end;

procedure play_blackjack;
var
 total_computer,total_user: integer;
 commandline: string;
 command: char;
 next: integer;

begin
 total_computer := 0;
 total_user := 0;
 write_com('Computer has ');
 inc(total_computer,get_card);
 writelncom;
 write_com('You have ');
 inc(total_user,get_card);
 write_com(' and ');
 inc(total_user,get_card);
 writelncom;
 next := 2;
 writelncom;
 repeat
  write_com('[S]tay or [H]it? ');
  ask_user(commandline,1);
  command := upcase(commandline[1]);
  writelncom;
  if command = 'H' then
   begin
    write_com('Taking the top card... ');
    inc(total_user,get_card);
    writelncom;
   end;
  if total_user > 21 then
   begin
    if (num_ace > 0) then
     begin
      dec(total_user,10);
      dec(num_ace);
     end
    else
     begin
      writelncom;
      writeln_com('You went OVER, you LOSE!');
      exit;
     end;
   end;
 until (drop_carrier) or (command = 'S');
 writelncom;
 write_com('The computer gets ... ');
 repeat
  inc(total_computer,get_card);
  write_com('  ');
  if total_computer = total_user then
   begin
    writelncom;
    writeln_com('A TIE!');
    inc(callinfo.upload_credit,to_gamble);
    dec(taken_time,to_gamble);
    exit;
   end
  else
  if total_computer > 21 then
   begin
    writelncom;
    writeln_com('The COMPUTER went over. YOU WIN!');
    inc(callinfo.upload_credit,to_gamble*2);
    dec(taken_time,to_gamble*2);
    exit;
   end
  else
  if total_computer > total_user then
   begin
    writelncom;
    writeln_com('THE COMPUTER WINS!!  Too bad, LOSER!');
    exit;
   end;
 until (drop_carrier);
end;

var
  name: string;
  comment: string;

begin
  begin_live_program('BlackJack for WINDOWS');
  name := userinfo.name;
  taken_time := 0;
  delete_after_spaces(name);
  writeln_com('Welcome '+name+' to PowerBBS for Windows BLACKJACK GAMBLE DOOR v1.1!');
  writeln_com('A demonstration of PowerBBSs PowerDOORs interface.');
  writelncom;
  repeat
   get_gamble;
   if to_gamble <> 0 then play_blackjack;
  until (drop_carrier) or (to_gamble = 0);
  if taken_time = 0 then
   activity('Broke even in BlackJack')
  else
   if taken_time > 0 then
    activity('Lost '+int_to_asc(taken_time)+' minutes in BlackJack')
  else
   activity('Won '+int_to_asc(taken_time)+' minutes in BlackJack');
  end_live_program;
end.
