{$N-,V-,B-,S-,R-,D-}

(*----------------------------------------------------------------------*)
(* Program: PowrSYS - SysOp Menu for PowerBBS by Russell Frey           *)
(*                                                                      *)
(* Date: September 26, 1991                                             *)
(*                                                                      *)
(* Source code to the PowerBBS SysOp's Menu in PowerDOOR format.        *)
(* Update this program, and you can replace the standard PowrSys.EXE    *)
(*                                                                      *)
(* You are free to modify and distribute under the Shareware or         *)
(* public domain format, but you MAY NOT distribute any program         *)
(* any other way.  Refer to PowrDoor.DOC for more information.          *)
(*----------------------------------------------------------------------*)
(* There are many modifications that can be done to improve this source *)
(* code.  So have fun modifying and learning PowrDOOR!                  *)
(*----------------------------------------------------------------------*)
(* If you have modifications to this file, that you would like to       *)
(* distribute, please upload it to the support bbs.                     *)
(*----------------------------------------------------------------------*)

Program PowerBBS_SysOp_Menu_Door;

uses windos,winprocs,strings,powrwin,powrdoor;

type
   char2 = array [1..2] of char;

   powr_caller_rec = record
      message:        array[1..75] of char;
      crlf:           char2;
   end;

var
   UserTemp: PowrUser;
   powr_caller:    powr_caller_rec;

   K,N,KK,MM : Integer;
   L : String;

   i:   integer;
   ofd:        text;
   Pass : Boolean;
   Temp42 : String;
   R : Integer;

   Temps5: String;

(* -------------------------------------------------------------------- *)
Function Show_Boolean(TrueFalse : Boolean) : String;

Begin
 if Truefalse then Show_Boolean := 'Yes'
              else Show_Boolean := 'No ';
End;

(* -------------------------------------------------------------------- *)
Procedure DisplayUpdate(Start1:   String;
                         Info1:    String;
                         Answer1:  String;
                         Start2:   String;
                         Info2:    String;
                         Answer2:  String);
Var
 Tempstring1: String;

Begin
 write_com(SENDWHITE);
 write_com(' '+Start1+' ');
 write_com(SENDCYAN);
 write_com(Info1);
 write_com(': ');
 Tempstring1 := Answer1;
 delete_after_spaces(Tempstring1);
 write_com(SENDGREEN+Tempstring1);
 writeln_com_spaces(36-(Length(Info1)+Length(Tempstring1)));
 write_com(SENDWHITE+Start2+' ');
 write_com(SENDCYAN);
 write_com(Info2);
 write_com(': ');
 Tempstring1 := Answer2;
 delete_after_spaces(Tempstring1);
 write_com(SENDGREEN+Tempstring1);
 writelncom;
End;

(* -------------------------------------------------------------------- *)
Procedure Get_Input(MaxStr : Integer;
                    Question : String);

Begin
 Repeat
  writelncom;
  Pass := True;
  R := Length(Question) - 1;
  writeln_com_border(R,Maxstr);
  write_com(SENDGREEN+Question);
  ask_user(Temp42,MaxStr);
  upper_string(temp42);
  delete_after_spaces(Temp42);
  if Length(Temp42) < 1 then Pass := False;
  if Pass = False then Begin
                         writelncom;
                         writeln_com(SENDYELLOW +'Invalid Response! Try Again. ');
                       End;
 Until (Pass = True) Or (drop_carrier);
 writelncom;
End;

(* -------------------------------------------------------------------- *)
Procedure New_Birthday;

Var
  Birth_Date: String;

Begin
  writelncom;
  write_com(SENDYELLOW+' Enter the date you were born ['+SENDWHITE+'MM-DD-YY'+
       SENDYELLOW+']: ');
  Get_Date(Birth_Date,False,'');
  put_chars_into(UserTemp.Birthday,Birth_Date,Sizeof(UserTemp.Birthday));
End;

(* -------------------------------------------------------------------- *)
procedure mode_toggle;

Var
  Temp724 : String;

begin
  writelncom;
  write_com(SENDYELLOW+'Monitor type: ['+SENDWHITE+'C'+SENDYELLOW+']olor, ['+SENDWHITE+
       'M'+SENDYELLOW+']onochrome, or ['+SENDWHITE+'N'+SENDYELLOW+']one');
  if GetInput(True,Temp724,1) then Exit;
  if Temp724 = 'C' then
                         UserTemp.Monitor_Type := 'C'

else if Temp724 = 'M' then
                         UserTemp.Monitor_Type := 'M'
                      else
                         UserTemp.Monitor_Type := 'N';
End;

(* -------------------------------------------------------------------- *)
Procedure New_Password;

Var temp999 : STRING;
Begin
 Repeat
  writelncom;
  Get_Input(10,' Password (One word please!): ');
  temp999 := Temp42;
  Get_Input(10,'  Re-enter password to check: ');
  if temp999 <> Temp42 then Begin
                             writelncom;
                             writeln_com(SENDYELLOW+' Password do not match ! ');
                            End;
 Until drop_carrier Or (temp999 = Temp42);
  put_chars_into(UserTemp.Password,Temp42,sizeof(UserTemp.Password));
End;

(* -------------------------------------------------------------------- *)
Procedure New_VoicePhone;

Begin
  writelncom;
  write_com(SENDYELLOW+'Enter your HOME Phone # [XXX-XXX-XXXX]: ');
  Get_A_Input('(###) ###-####',Temp42,False,'');
  put_chars_into(UserTemp.Phone_Number,Temp42,sizeof(UserTemp.Phone_Number));
End;

(* -------------------------------------------------------------------- *)
Procedure New_City;

Begin
  writelncom;
  Get_Input(20,' City and State calling From? ');
  put_chars_into(UserTemp.Location,temp42,sizeof(UserTemp.Location));
End;

(* -------------------------------------------------------------------- *)
Procedure New_Computer;

Begin
  writelncom;
  Get_Input(15,'    What is your Computer type? ');
  put_chars_into(UserTemp.Computer,Temp42,sizeof(UserTemp.Computer));
End;

(* -------------------------------------------------------------------- *)
Procedure Set_Page;

Var
  Temp25: String;
  Halt: Boolean;

Begin
  Halt := False;
  temp25 := '';
  writelncom;
  write_com(SENDYELLOW+'Enter '+SENDWHITE+'PAGE Length'+SENDYELLOW+' ['+SENDWHITE+
       'ENTER'+SENDYELLOW+'='+int_to_asc(UserTemp.Screen_lines)+']: ');
  ask_user(TEMP25,2);
  upper_string(TEMP25);
  if temp25 = '' then Halt := True;
  if Halt = False then UserTemp.Screen_lines := asc_to_int(TEMP25);
  writelncom;
End;


(* -------------------------------------------------------------------- *)
Procedure Sysop_SB;

Var
  User_File: file_handle;
  Num_users: LongInt;
  Tempi6,Tempi7: Integer;

Begin
   User_File := Open_File(UserFile_Path,2);
   num_users := (seek_file(User_File,0,2) div sizeof(UserTemp))-1;
   seek_file(user_file,0,0);
   tempi6 := -1;
   repeat
      inc(tempi6);
      Tempi7 := read_file(User_File,UserTemp,Sizeof(UserTemp));
      writeln_com(SENDWHITE+rjust(int_to_asc(Tempi6+1),4)+'. '+SENDGREEN+UserTemp.Last_Call+
              ' '+SENDYELLOW+UserTemp.Name+' '+SENDRED+UserTemp.Location+' '+SENDCYAN+
              UserTemp.Last_Time+SENDWHITE+' '+rjust(UserTemp.Last_Time,3)+' Min');
   until (tempi6 >= num_users) or (user_abort) or (drop_carrier);
   close_file(User_File);
   get_a_return;
End;

(* -------------------------------------------------------------------- *)
procedure display_activitylog(todisplay: string);
var
 Caller_FH:  file_handle;
 tempi6, tempi7: longint;
 temps1: string;

begin
   Caller_FH := Open_File(todisplay,2);
   tempi6 := seek_file(Caller_FH,0,2);
   tempi6 := (tempi6 div sizeof(powr_caller))-1;
   close_file(caller_FH);
   caller_FH := Open_File(todisplay,2);
   repeat
     seek_file(caller_FH,tempi6*sizeof(powr_caller),0);
     Tempi7 := read_file(Caller_FH,powr_caller,Sizeof(powr_caller));
     temps1 := powr_caller.Message;
     delete_after_spaces(temps1);
     writeln_com(temps1);
     dec(tempi6);
   until (user_abort) or (drop_carrier) or (tempi6 < 1);
   close_file(Caller_FH);
   get_a_return;
end;

(* -------------------------------------------------------------------- *)
Procedure View_Caller;
Var
 temps1,tempactlog:   string;

 Begin
   tempactlog := copy(CallerLog,1,length(CallerLog)-1);
   writeln_com_node_status;
   writelncom;
   write_com('Enter Node # to view Actlog');
   if getinput(false,temps1,2) then exit;
   tempactlog := tempactlog + temps1;
   if Not file_exists(tempactlog) then exit;
   display_activitylog(tempactlog);
End;

(* -------------------------------------------------------------------- *)
Procedure Update_Conferences;

Var
  Tempi10: Integer;
  Temps11: String;

Begin
  writelncom;
   writeln_com(' Enter * for forums to give access, or [Enter] for no change.');
   writeln_com('        0.........1.........2.........3.........4.........');
   writeln_com_spaces(8);
   For Tempi10 := 0 to 49 do
    if bit_from_byte(UserTemp.Forum_Data[tempi10].Options,1) then
      write_com('*')
    else
      write_com(' ');
   writelncom;
     write_com('Access= ');
     ask_user(Temps11,50);
     delete_after_spaces(Temps11);
     if Temps11 <> '' then
      Begin
      For Tempi10 := 0 To 49 Do
       set_bit_byte(UserTemp.Forum_Data[Tempi10].Options,1,False);
      For Tempi10 := 1 to Length(Temps11) Do
       set_bit_byte(UserTemp.Forum_Data[tempi10-1].Options,1,Copy(Temps11,Tempi10,1) = '*');
      End;
   writelncom;
   writeln_com('        5.........6.........7.........8.........9.........');
   writeln_com_spaces(8);
   For Tempi10 := 50 to 99 do
    if bit_from_byte(UserTemp.Forum_Data[tempi10].Options,1) then
     write_com('*')
    else
     write_com(' ');
   writelncom;
     write_com('Access= ');
     ask_user(Temps11,50);
     delete_after_spaces(Temps11);
     if Temps11 <> '' then
     Begin
      For tempi10 := 50 to 99 do
       set_bit_byte(UserTemp.Forum_Data[Tempi10].Options,1,False);
      For Tempi10 := 1 to Length(Temps11) Do
       set_bit_byte(UserTemp.Forum_Data[tempi10+49].Options,1,Copy(Temps11,Tempi10,1) = '*');
     End;
End;

(* -------------------------------------------------------------------- *)
Procedure User_Database_Update;

Var Hotkeym: Char;
    Temp020 : String;
    User_File: file_handle;
    Num_Users: LongInt;
    User_Num,Junki: Integer;
    Temps6,temps7,Temps8,Temps15,Temps26: String;
    Tempi8,Tempi9: Integer;
    Tempi10: Integer;
    PL,PP: Integer;
    PA:    Real;
    tempc25: char25;
    tempw: word;

Begin
 User_Num := 0;
 Repeat
  User_File := open_file(UserFile_Path,2);
  num_users := (seek_file(user_file,0,2) div sizeof(UserTemp))-1;
  ClearScreen;
  if User_Num > Num_Users then User_Num := Num_Users - 1;
  seek_file(user_file,user_num*sizeof(UserTemp),0);
  Junki := read_file(User_File,UserTemp,Sizeof(UserTemp));
  close_file(User_File);
    writeln_com(SENDYELLOW+'Record # '+SENDWHITE+int_to_asc(User_num + 1)+SENDYELLOW+' of '+SENDWHITE+int_to_asc(Num_Users+1));
    writelncom;
    DisplayUpdate(' 1.','  User''s name',UserTemp.Name,' 2.','Dead & Locked Out',
                    Show_Boolean(bit_from_byte(UserTemp.options,4)));
    DisplayUpdate(' 3.',' Calling From',UserTemp.Location,' 4.',' Last Called',
                   UserTemp.Last_Call+' '+UserTemp.Last_Time);
    DisplayUpdate(' 5.','     Password','<Not Shown>',' 6.','  Sec. Level',
                   int_to_asc(UserTemp.access));
    DisplayUpdate(' 7.','     Birthday',UserTemp.Birthday,' 8.',' # Downloads',
                   int_to_asc(UserTemp.Downloads)+'   '+double_to_kilobyte(UserTemp.Download_Bytes)+' k');
    DisplayUpdate(' 9.','   Home Phone',UserTemp.Phone_Number,'10.','   # Uploads',
                   int_to_asc(UserTemp.Uploads)+'   '+double_to_kilobyte(UserTemp.uploads_bytes)+' k');
    DisplayUpdate('11.','       Expert',Show_Boolean(bit_from_byte(UserTemp.options,1)),
                   '12.','     # Calls',int_to_asc(UserTemp.Calls));
    DisplayUpdate('13.','     Computer',UserTemp.Computer,'14.',' # Msgs Left',
                   int_to_asc(UserTemp.Messages_Left));
    DisplayUpdate('15.','     Protocol',UserTemp.Xproto,'   ','','');
    DisplayUpdate('16.','Screen Length',int_to_asc(UserTemp.Screen_lines),'   ','','');
    DisplayUpdate('17.',' Monitor Type',UserTemp.Monitor_Type,'   ','','');
    DisplayUpdate('18.','Expiring Date/Level',UserTemp.Expiration_Date+' '+int_to_asc(UserTemp.Expiration_Access),
                   '   ','','');
    writelncom;
    writeln_com('        0.........1.........2.........3.........4.........5');
      write_com('20.     ');
    For Tempi10 := 0 to 50 Do
     if bit_from_byte(UserTemp.Forum_Data[Tempi10].Options,1) then
      write_com(chr(Tempi10 mod 10+ord('0')))
     else
      write_com(' ');
    writelncom;
    writeln_com_spaces(9);
    For Tempi10 := 51 to 99 Do
     if bit_from_byte(UserTemp.Forum_Data[Tempi10].Options,1) then
      write_com(chr(Tempi10 mod 10+ord('0')))
     else
      write_com(' ');
    writelncom;
    writeln_com(infotext('Time Left: |MINLEFT|'));
    writelncom;
    write_com(SENDYELLOW+'[F]ind, [J]ump, [Q]uit, [1..20], [ENTER=Next]: ');
    ask_user(Temps6,20);
    upper_string(Temps6);
    delete_after_spaces(Temps6);
    Temp020 := Temps6;
    writelncom;
    if drop_carrier then exit;
    case asc_to_int(Temps6) of
     1: Begin
           writelncom;
           Get_Input(25,' New User Name? ');
           put_chars_into(UserTemp.Name,Temp42,Sizeof(UserTemp.Name));
          End;
     2: set_bit_byte(UserTemp.options,4, Not bit_from_byte(UserTemp.options,4));
     3: New_City;
     4: Begin
           Temps5 := UserTemp.Last_Call;
           write_com(SENDYELLOW+'Enter Last Called ['+SENDWHITE+'DATE'+'], ['+SENDWHITE+'ENTER'+
                SENDYELLOW+'='+UserTemp.Last_Call+') (MM-DD-YY): ');
           Get_A_Input('##-##-##',Temps5,True,Temps5);
           put_chars_into(UserTemp.Last_Call,Temps5,Sizeof(UserTemp.Last_Call));
           Temps5 := UserTemp.Last_Time;
           write_com(SENDYELLOW+'Enter Last Called ['+SENDWHITE+'TIME'+'], ['+SENDWHITE+'ENTER'+
                SENDYELLOW+'='+Temps5+') (XX:XX): ');
           Get_A_Input('##:##',Temps5,True,Temps5);
           put_chars_into(UserTemp.Last_Time,Temps5,Sizeof(UserTemp.Last_Time));
          End;
     5: New_Password;
     6: Begin
           writelncom;
           Get_Input(3,' New Security Level? ');
           UserTemp.access := asc_to_int(Temp42);
         End;
     7: New_Birthday;
     8: Begin
           Get_Input(4,'   Total Number Of Downloads: ');
           UserTemp.Downloads := asc_to_int(Temp42);
           Get_Input(4,' Total Number Of K Downloads: ');
           val(temp42,Pa,tempw);
           PA := PA * 1024;
           real_to_double(PA,UserTemp.Download_Bytes);
          End;
     9: New_VoicePhone;
    10: Begin
           Get_Input(4,'   Total Number Of Uploads: ');
           UserTemp.Uploads := asc_to_int(Temp42);
           Get_Input(4,' Total Number Of K Uploads: ');
           val(temp42,Pa,tempw);
           PA := PA * 1024;
           real_to_double(PA,UserTemp.uploads_bytes);
          End;
    11: set_bit_byte(UserTemp.options,1, Not bit_from_byte(UserTemp.options,1));
    12: Begin
           writelncom;
           Get_Input(3,' New Number Of Calls? ');
           UserTemp.Calls := asc_to_int(Temp42);
          End;
    13: New_Computer;
    14: Begin
           Get_Input(4,' Total Number Of Messages Left: ');
           UserTemp.Messages_Left := asc_to_int(Temp42);
          End;
    15: Begin
           writelncom;
           Get_Input(1,' New Default Protocol? ');
           put_chars_into(UserTemp.Xproto,Temp42,Sizeof(UserTemp.Xproto));
          End;
    16: Set_Page;
    17: Mode_Toggle;
    18: Begin
         writelncom;
         write_com(' Enter Expiration Date: ');
         Temp42 := UserTemp.Expiration_Date;
         Get_Date(Temp42,True,Temp42);
         put_chars_into(UserTemp.Expiration_Date,Temp42,Sizeof(UserTemp.Expiration_Date));
         write_com('Enter Expiration Level: ');
         ask_user(Temp42,3);
         delete_after_spaces(Temp42);
         if Temp42 <> '' then UserTemp.Expiration_Access := asc_to_int(Temp42);
        End;
    20: Update_Conferences;
    End;
   User_File := open_file(UserFile_Path,2);
   seek_file(user_file,user_num*sizeof(UserTemp),0);
   write_file(User_File,UserTemp,Sizeof(UserTemp));
   close_file(User_File);
   if Temps6 = 'J' then Begin
    writelncom;
    write_com(SENDYELLOW+'Jump: ('+SENDWHITE+'1..'+int_to_asc(Num_Users+1)+SENDYELLOW+')? ');
    ask_user(Temps7,5);
    delete_after_spaces(Temps7);
    Tempi8 := asc_to_int(Temps7);
    if (Tempi8 < 1) Or (Tempi8 > Num_Users+1) then Temps6 := 'Q';
    User_Num := Tempi8 - 1;
   End;
   if Temps6 = 'F' then Begin
    writelncom;
    write_com(SENDYELLOW+'Enter Users '+SENDWHITE+'FULL NAME'+SENDYELLOW+': ');
    ask_user(Temps7,25);
    delete_after_spaces(Temps7);
    upper_string(Temps7);
    put_chars_into(tempc25,temps7,sizeof(tempc25));
    Tempi8 := search_userrec_for(UserTemp,tempc25);
    if tempi8 > 0 then user_num := tempi8 - 1;
   End;
   if Temps6 = '' then Begin
     inc(user_num);
     if User_Num > Num_Users then Temps6 := 'Q';
     End;
 Until (drop_carrier) Or (Temps6 = 'Q');
End;

(* -------------------------------------------------------------------- *)
procedure sysop_main_menu;
var
 menucommand: string;

const
   None = '~';
begin
 repeat
   writelncom;
   type_file('\Powrbbs\Screen\SysOp');
   writelncom;
   write_com(SENDYELLOW+'SysOps Door Demo Command? ');
   Repeat
    Get_Hotkey(MenuCommand[1]);
   Until drop_carrier or (MenuCommand[1] <> chr(13));
   writeln_com(MenuCommand[1]);
   if drop_carrier then exit;

   case menucommand[1] of
         'A':  View_Caller;
         'L':  Sysop_Sb;
         'Q':  Exit;
         'U':  User_Database_Update;
      end;
  until drop_carrier;
end;

begin
 begin_live_program('PowerSys - System_Door - (c) 1991 by Russell Frey');
 Sysop_Main_Menu;
 end_live_program;
End.
