title	'XCRC linkage to CRC'
name	xcrc
cseg	segment byte public 'CODE'
	assume	cs : cseg
	public	crcasm, crca
;
; PROCEDURE crc(byte, VAR integer);
; incorporates byte in integer using x^16+x^12+x^5+1
crcasm	proc	far
	pop	dx;		return offset
	pop	cx;		return segment
	pop	bx;		^integer, offset
	pop	es;		^integer, segment
	pop	ax;		al := byte
	push	cx;		return segment
	push	dx;		return offset
	mov	dx,es:[bx];	old crc value
;	------		busy regs - speed optimized.
	xor	al,dh;	al ah dl dh
	mov	ah,al;	 x  x  x  
	ror	al,1;	 x  x  x
	ror	al,1;	 x  x  x
	ror	al,1;	 x  x  x
	ror	al,1;	 x  x  x
	and	al,0fh;	 x  x  x
	xor	al,ah;   x     x
	mov	dh,al;	 x     x  .  
	ror	al,1;	 x     x  .
	ror	al,1;	 x     x  .
	ror	al,1;	 x     x  .
	mov	ah,al;	 x  x  x  .
	and	al,1fh;	 x  x  x  .
	xor	al,dl;	 x  x     .
	xchg	dh,al;	 .  .     .
	mov	dl,al;	    .  .  .
	mov	al,ah;	 x  x  .  x
	and	al,0e0h; x  x     x
	xor	dl,al;	    .  .  .
	ror	ah,1;	    x  x  x
	and	ah,0f0h;    x  x  x
	xor	dh,ah;	       x  x	one byte done
;	-----
	mov	es:[bx],dx;	save result
	ret
crcasm	endp
;
; PROCEDURE crca(VAR byte array; VAR integer);
; incorporates bytes in integer using x^16+x^12+x^5+1
crca	proc	far
	pop	dx;		return offset
	pop	ax;		return segment
	pop	bx;		^integer, offset
	pop	es;		^integer, segment
	pop	cx;		length
	pop	si;		^array, offset
	pop	di;		^array, segment
	push	ax;		return segment
	push	dx;		return offset
	push	ds;		save
	mov	ds,di;		array segment
	mov	dx,es:[bx];	incoming crc
	jcxz	crca2;		zero length
crca1:	lodsb
;	------		busy regs - speed optimized
	xor	al,dh;	al ah dl dh
	mov	ah,al;	 x  x  x  
	ror	al,1;	 x  x  x
	ror	al,1;	 x  x  x
	ror	al,1;	 x  x  x
	ror	al,1;	 x  x  x
	and	al,0fh;	 x  x  x
	xor	al,ah;   x     x
	mov	dh,al;	 x     x  .  
	ror	al,1;	 x     x  .
	ror	al,1;	 x     x  .
	ror	al,1;	 x     x  .
	mov	ah,al;	 x  x  x  .
	and	al,1fh;	 x  x  x  .
	xor	al,dl;	 x  x     .
	xchg	dh,al;	 .  .     .
	mov	dl,al;	    .  .  .
	mov	al,ah;	 x  x  .  x
	and	al,0e0h; x  x     x
	xor	dl,al;	    .  .  .
	ror	ah,1;	    x  x  x
	and	ah,0f0h;    x  x  x
	xor	dh,ah;	       x  x	one byte done
;	-----
	loop	crca1;		over the array
	mov	es:[bx],dx;	save result
crca2:	pop	ds
	ret
crca	endp

cseg	ends
	end
