{**************************************************************
 *                                                            *
 *  Scroll - Turbo Vision program showing to use a scroller   *
 *  descendant to display an array of lines. Also shows how   *
 *  the contents of these lines can be tied to commands on    *
 *  the menubar.   JJS-12/30/93                               *
 *                                                            *
 **************************************************************}

program Scroll;

uses
  Objects, Views, Drivers, Menus, App;

const
  cmHello = 100;
  cmReset = 101;

type
  PMainScroller = ^TMainScroller;
  TMainScroller = object(TScroller)
    Lines: array[1..55] of String;
    constructor Init(var Bounds: TRect; AHScrollbar,
      AVScrollbar: PScrollBar);
    procedure Draw; virtual;
  end;

  PMainWin = ^TMainWin;
  TMainWin = object(TWindow)
    Interior: PMainScroller;
    constructor Init(Bounds: TRect; ATitle: TTitleStr;
      ANumber: Integer);
  end;

  PMainApp = ^TMainApp;
  TMainApp = object(TApplication)
    MainWin: PMainWin;
    constructor Init;
    procedure InitMenuBar; virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure HelloProc;
    procedure ResetProc;
  end;

constructor TMainScroller.Init(var Bounds: TRect; AHScrollbar,
  AVScrollbar: PScrollbar);
var I: Integer;
begin
  inherited Init(Bounds, AHScrollbar, AVScrollbar);

{ Sets the GrowMode so the Interior's right and bottom margins
  are consistant with those of the MainWin when the MainWin
  changes size.  Very important!
}
  GrowMode := gfGrowHiX + gfGrowHiY;

{ Set the bounds for the scrollbars }
  SetLimit(80, 55);

{ Initialize the array of lines so that scrolling may be seen. }
{ In this demo, each line simply indicates its line number.    }
  for I := 1 to 55 do
    begin
      Str(I, Lines[I]);
      Lines[I] := ' Line #' + Lines[I] + ' ';
    end;
end;

procedure TMainScroller.Draw;
var
  I: Integer;
begin

{ Display all lines }
  for I := 1 to 55 do
    begin

    { Write out blanks to erase previous contents }
      WriteChar(0, I-1, ' ', 1, 80);

    { Write out line accounting for scrolling. Delta.X holds the
      appropriate scrolling in the horizontal.  Delta.Y holds
      scrolling for the verical. Here, the Copy function is used
      for representing the string affected by horizontal
      scrolling.  Whereas, vertical scrolling only determines
      which line is drawn first.
    }
      WriteStr(0, I-1,
        Copy(Lines[I + Delta.Y],Delta.X, 255),
        1);
    end;
end;

constructor TMainWin.Init(Bounds: TRect; ATitle: TTitleStr;
  ANumber: Integer);
var R: TRect;
begin
  inherited Init(Bounds, ATitle, ANumber);

{ Create and Insert the Scroller }
  GetExtent(R);  R.Grow(-1, -1);
  Interior := New(PMainScroller, Init(R,
    StandardScrollbar(sbHorizontal + sbHandleKeyBoard),
    StandardScrollbar(sbVertical + sbHandleKeyboard)));
  Insert(Interior);
end;

constructor TMainApp.Init;
var R: TRect;
begin
  inherited Init;

{ Create and insert the MainWindow upon start up. }
  Desktop^.GetExtent(R);
  New(MainWin, Init(R, 'Main Window', 0));
  Desktop^.Insert(MainWin);
end;

procedure TMainApp.InitMenubar;
var
  R: TRect;
begin
  GetExtent(R);
  R.B.Y := R.A.Y + 1;
  Menubar := New(PMenuBar, Init(R, NewMenu(
    NewItem('~H~ello', '', kbNoKey, cmHello, hcNoContext,
    NewItem('~R~eset', '', kbNoKey, cmReset, hcNoContext,
    nil))
  )));
end;

procedure TMainApp.HandleEvent(var Event: TEvent);
begin
  inherited HandleEvent(Event);

{ Respond to the commands from the menubar }
  if Event.What = evCommand then
    case Event.Command of
      cmHello: HelloProc;
      cmReset: ResetProc;
    end;
end;

procedure TMainApp.HelloProc;
begin
  with MainWin^.Interior^ do
    begin
    { Change line 3 and force the interior to draw itself }
      Lines[3] := 'Hello there!';
      DrawView;
    end;
end;

procedure TMainApp.ResetProc;
begin
  with MainWin^.Interior^ do
    begin
      Lines[3] := ' Line #3 ';
      DrawView;
    end;
end;

var
  MainApp: TMainApp;


begin
  MainApp.Init;
  MainApp.Run;
  MainApp.Done
end.


